/**
 * Copyright pasodania ( http://wonderfl.net/user/pasodania )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8sXD
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.geom.Rectangle;
    import flash.events.MouseEvent;
    import flash.text.TextFieldAutoSize;
    import flash.display.Shape;

    public class TextField_getCharBoundariesExample extends Sprite
    {
        private var myTextField:TextField = new TextField();    
        private var spotlight:Shape = new Shape();
        
        public function TextField_getCharBoundariesExample() {
            
            myTextField.x = 10;
            myTextField.y = 10; 
            myTextField.border = true;
            myTextField.selectable = false;
            myTextField.autoSize = TextFieldAutoSize.LEFT;
            
            myTextField.text = "Selected a character from this text by clicking on it."

            myTextField.addEventListener(MouseEvent.CLICK, clickHandler);
            
            this.addChild(myTextField);    
            this.addChild(spotlight);
         }

        private function clickHandler (e:MouseEvent):void {
            var index:int = myTextField.getCharIndexAtPoint(e.localX, e.localY);
 
            if (index != -1) {
                 var frame:Rectangle = myTextField.getCharBoundaries(index);

                spotlight.graphics.clear();    
                spotlight.graphics.beginFill(0xFFFF00, .35);
                spotlight.graphics.drawRect((frame.x + 10), (frame.y + 10), frame.width, frame.height);            
                spotlight.graphics.endFill();
            }
        } 
    }

}