/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8sUS
 */

package 
{
    import com.bit101.components.CheckBox;
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;
    import com.bit101.components.NumericStepper;
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * ...
     * @author ypc
     */
    [SWF(width = 465, height = 465, backgroundColor = "#ffffff")]
    public class Main extends Sprite 
    {
        public var mapWidth:int = 8;
        public var mapHeight:int = 8;
        public var mapWidthMax:int = 16;
        public var mapHeightMax:int = 26;
        
        public var mapScale:int = 3;
        
        public var cellSprite:Sprite;
        public var cellWidth:int = 16;
        public var cellArray:Array;
        
        public var widthStepper:NumericStepper;
        public var heightStepper:NumericStepper;
        public var mirrorXCheck:CheckBox;
        public var mirrorYCheck:CheckBox;
        public var colorCheck:CheckBox;
        public var generateCheck:CheckBox;
        public var generateButton:PushButton;
        public var saturationSlider:HSlider;
        public var saturationLabel:Label;
        public var colorSlider:HSlider;
        public var colorLabel:Label;
        public var sampleStepper:NumericStepper;
        
        public var scaleStepper:NumericStepper;        
        public var diagonalLeftCheck:CheckBox;
        public var diagonalRightCheck:CheckBox;
        
        public var clearButton:PushButton;
        public var spaceShipButton:PushButton;
        public var dragonButton:PushButton;
        public var robotButton:PushButton;
        public var treeButton:PushButton;
        public var racerButton:PushButton;
        public var humanoidButton:PushButton;
        public var bowButton:PushButton;
        public var badgeButton:PushButton;
        
        public var sampleArray:Array;
        
        public var outputBitmapData:BitmapData;
        public var outputBitmap:Bitmap;
        public var outputSprite:Sprite;
        
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = "noScale";
            
            initCell();
            showCell();
            initUI();
            initBitmap();
            
            spaceShip();
        }
        
        private function generate(e:Event = null):void
        {
            if (generateCheck.selected == false)
            {
                return;
            }
            
            initSample();
            generateRandomSample();
            
            if (diagonalLeftCheck.selected == true)
            {
                mirrorDiagonalLeft();
            }
            else if (diagonalRightCheck.selected == true)
            {
                mirrorDiagonalRight();
            }
            
            mirror();
            generateEdges();
            renderPixelData();
        }
        
        private function initCell():void
        {
            var i:int;
            var j:int;
            var cell:Cell;
            
            cellSprite = new Sprite();
            cellSprite.addEventListener(MouseEvent.CLICK, onCellClick, true);
            cellSprite.addEventListener(MouseEvent.MOUSE_OVER, onCellOver, true);
            cellSprite.addEventListener(MouseEvent.MOUSE_OUT, onCellOut, true);
            addChild(cellSprite);
            
            cellArray = [];
            
            for (i = 0; i < mapHeightMax; i += 1)
            {
                for (j = 0; j < mapWidthMax; j += 1)
                {
                    cell = new Cell(j, i);
                    cell.x = j * cellWidth;
                    cell.y = i * cellWidth;
                    
                    cell.visible = false;
                    
                    cellSprite.addChild(cell);
                    cellArray.push(cell);
                }
            }
            
        }
        
        private function showCell():void
        {
            var i:int;
            var j:int;
            var cell:Cell;
            
            for (i = 0; i < mapHeightMax; i += 1)
            {
                for (j = 0; j < mapWidthMax; j += 1)
                {
                    cell = cellArray[i * mapWidthMax + j];
                    if (i < mapHeight && j < mapWidth)
                    {
                        cell.visible = true;
                    }
                    else
                    {
                        cell.visible = false;
                    }
                }
            }
            
        }
        
        private function clearCell(e:Event = null):void
        {
            var i:int;
            var j:int;
            var cell:Cell;
            
            for (i = 0; i < mapHeightMax; i += 1)
            {
                for (j = 0; j < mapWidthMax; j += 1)
                {
                    cell = cellArray[i * mapWidthMax + j];
                    cell._status = 0;
                    
                    cell.draw();
                }
            }
        }
        
        private function initUI():void
        {
            var label:Label;
            label = new Label(this, stage.stageWidth - 110, 10, "Width ");
            
            widthStepper = new NumericStepper(this, label.x + label.width + 10, label.y, function(e:Event):void {
                mapWidth = e.target.value;
                showCell();
                
                generate();
            });
            widthStepper.minimum = 1;
            widthStepper.maximum = mapWidthMax;
            widthStepper.value = mapWidth;
            widthStepper.width = stage.stageWidth -  widthStepper.x - 10;
            
            label = new Label(this, stage.stageWidth - 110, 30, "Height");
            
            heightStepper = new NumericStepper(this, label.x + label.width + 10, label.y, function(e:Event):void {
                mapHeight = e.target.value;
                showCell();
                
                generate();
            });
            heightStepper.minimum = 1;
            heightStepper.maximum = mapHeightMax;
            heightStepper.value = mapHeight;
            heightStepper.width = stage.stageWidth -  heightStepper.x - 10;
            
            mirrorXCheck = new CheckBox(this, label.x, 50, "Mirror X", generate);
            
            mirrorYCheck = new CheckBox(this, label.x, 70, "Mirror Y", generate);
            
            colorCheck = new CheckBox(this, label.x, 90, "Colored", generate);
            colorCheck.selected = true;
            
            generateCheck = new CheckBox(this, label.x, 110, "Live Gen.");
            generateCheck.selected = true;
            
            generateButton = new PushButton(this, label.x, 130, "Generate", generate);
            
            label = new Label(this, stage.stageWidth - 110, 150, "Saturation");
            
            saturationLabel = new Label(this, label.x, 170, "0.5");
            
            saturationSlider = new HSlider(this, saturationLabel.x + 20, 170 + 5, function(e:Event):void {
                saturationLabel.text = String(e.target.value);
                generate();
            });
            saturationSlider.value = 0.8;
            saturationSlider.minimum = 0;
            saturationSlider.maximum = 1;
            saturationSlider.width = stage.stageWidth - saturationSlider.x - 10;
            
            label = new Label(this, saturationLabel.x, 190, "Color Var.");
            
            colorLabel = new Label(this, label.x, 210, "0.2");
            
            colorSlider = new HSlider(this, colorLabel.x + 20, 210 + 5, function(e:Event):void {
                colorLabel.text = String(e.target.value);
                generate();
            });
            colorSlider.value = 0.2;
            colorSlider.minimum = 0;
            colorSlider.maximum = 0.99;
            colorSlider.width = stage.stageWidth - colorSlider.x - 10;
            
            label = new Label(this, stage.stageWidth - 110, 230, "Sample#");
            
            sampleStepper = new NumericStepper(this, label.x + label.width, 230, generate);
            sampleStepper.minimum = 1;
            sampleStepper.maximum = 300;
            sampleStepper.value = 80;
            sampleStepper.width = stage.stageWidth - sampleStepper.x - 10;
            
            clearButton = new PushButton(this, mapWidthMax * cellWidth + 10, 10, "CLEAR", clearCell);
            clearButton.width = stage.stageWidth - 110 - clearButton.x - 10;
            
            spaceShipButton = new PushButton(this, clearButton.x, clearButton.y + clearButton.height, "SpaceShip", spaceShip);
            spaceShipButton.width = stage.stageWidth - 110 - spaceShipButton.x - 10;
            
            dragonButton = new PushButton(this, spaceShipButton.x, spaceShipButton.y + spaceShipButton.height, "Dragon", function(e:Event):void {
                
                var data:Array = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
                                0, 0, 0, 1, 1, 2, 2, 1, 1, 0, 0, 0,
                                0, 0, 1, 1, 1, 2, 2, 1, 1, 1, 0, 0,
                                0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0,
                                0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0,
                                0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0,
                                0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0,
                                0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
                                0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
                                0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
                
                setCell(data, 12, 12);
                
                mirrorXCheck.selected = false;
                mirrorYCheck.selected = false;
                diagonalLeftCheck.selected = false;
                diagonalRightCheck.selected = false;
                colorCheck.selected = true;
                saturationSlider.value = 0.5;
                saturationLabel.text = String(saturationSlider.value);
                colorSlider.value = 0.2;
                colorLabel.text = String(colorSlider.value);
                
                generate();
            });
            dragonButton.width = spaceShipButton.width;
            
            robotButton = new PushButton(this, dragonButton.x, dragonButton.y + dragonButton.height, "Robot", function(e:Event):void {
                
                var data:Array = [0, 0, 0, 0,
                                0, 1, 1, 1,
                                0, 1, 2, 2,
                                0, 0, 1, 2,
                                0, 0, 0, 2,
                                1, 1, 1, 2,
                                0, 1, 1, 2,
                                0, 0, 0, 2,
                                0, 0, 0, 2,
                                0, 1, 2, 2,
                                1, 1, 0, 0];
                
                setCell(data, 4, 11);
                
                mirrorXCheck.selected = true;
                mirrorYCheck.selected = false;
                diagonalLeftCheck.selected = false;
                diagonalRightCheck.selected = false;
                colorCheck.selected = true;
                saturationSlider.value = 0.5;
                saturationLabel.text = String(saturationSlider.value);
                colorSlider.value = 0.2;
                colorLabel.text = String(colorSlider.value);
                
                generate();
            });
            robotButton.width = dragonButton.width;
            
            treeButton = new PushButton(this, robotButton.x, robotButton.y + robotButton.height, "Tree", function(e:Event):void {
                
                var data:Array = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1,
                                0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, -1,
                                0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1,
                                0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1,
                                0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1,
                                0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 1, -1,
                                0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 1, -1,
                                0, 0, 0, 1, 1, -1, -1, -1, 0, 0, 0, 1, -1,
                                0, 0, 0, 0, 0, 0, 0, 1, -1, -1, -1, 1, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, -1,
                                0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 1, -1,
                                0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 1, -1,
                                0, 0, 1, -1, -1, -1, -1, 0, 0, 0, 0, 1, -1,
                                0, 1, 0, 0, 0, 1, -1, -1, -1, 0, 0, 1, -1,
                                0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, -1, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1];
                
                setCell(data, 13, 26);
                
                mirrorXCheck.selected = true;
                mirrorYCheck.selected = false;
                diagonalLeftCheck.selected = false;
                diagonalRightCheck.selected = false;
                colorCheck.selected = true;
                saturationSlider.value = 0.5;
                saturationLabel.text = String(saturationSlider.value);
                colorSlider.value = 0.2;
                colorLabel.text = String(colorSlider.value);
                
                generate();
            });
            treeButton.width = robotButton.width;
            
            racerButton = new PushButton(this, treeButton.x, treeButton.y + treeButton.height, "Racer", function(e:Event):void {
                
                var data:Array = [0, 0, 0, 0,
                                0, 1, 1, 1,
                                1, 0, 1, 2,
                                2, 0, 0, 1,
                                2, 0, 1, 2,
                                2, 1, 1, 1,
                                2, 0, 1, 1,
                                2, 0, 0, 0,
                                2, 0, 0, 0,
                                2, 0, 0, 1,
                                2, -1, -1, 1];
                
                setCell(data, 4, 11);
                
                mirrorXCheck.selected = true;
                mirrorYCheck.selected = false;
                diagonalLeftCheck.selected = false;
                diagonalRightCheck.selected = false;
                colorCheck.selected = true;
                saturationSlider.value = 0.5;
                saturationLabel.text = String(saturationSlider.value);
                colorSlider.value = 0.2;
                colorLabel.text = String(colorSlider.value);
                
                generate();
            });
            racerButton.width = treeButton.width;
            
            humanoidButton = new PushButton(this, racerButton.x, racerButton.y + racerButton.height, "Humanoid", function(e:Event):void {
                
                var data:Array = [0, 0, 0, 0, 0, 1, 1,
                                0, 0, 0, 1, 1, 2, 2,
                                0, 0, 0, 1, 2, 2, 2,
                                0, 0,-1, 2, 0, 0, 2,
                                0, 0, 1, 2, 2, 2, -1,
                                0, 0, 0, 1, 2, 1, -1,
                                0, 0, 0, 0, 1, 2, 1,
                                0, 0, 0, 0, 2, 2, 1,
                                0, 0, 1, 1, 1, 2, 2,
                                0, 1, 2, 2, 2, 2, 2,
                                1, 2, 1, 1, 1, 2, 2,
                                1, 2, 0, 1, 1, 2, 2,
                                1, 2, 0, 0, 1, 1, 2,
                                0, 2, 0, 0, 1, 1, 2,
                                0, 0, 0, 0, 1, 1, 3,
                                0, 0, 0, 0, 1, 1, 2,
                                0, 0, 0, 1, 1, 2, 0,
                                0, 0, 0, 1, 2, 2, 0,
                                0, 0, 0, 1, 2, 2, 0,
                                0, 0, 1, 2, 2, 0, 0,
                                1, 1, 2, 2, 0, 0, 0,
                                1, 2, 2, 1, 1, 0, 0];
                
                setCell(data, 7, 22);
                
                mirrorXCheck.selected = true;
                mirrorYCheck.selected = false;
                diagonalLeftCheck.selected = false;
                diagonalRightCheck.selected = false;
                colorCheck.selected = true;
                saturationSlider.value = 0.5;
                saturationLabel.text = String(saturationSlider.value);
                colorSlider.value = 0.2;
                colorLabel.text = String(colorSlider.value);
                
                generate();
            });
            humanoidButton.width = racerButton.width;
            
            bowButton = new PushButton(this, humanoidButton.x, humanoidButton.y + humanoidButton.height, "Bow", function(e:Event):void {
                
                var data:Array = [0, 0, 0, 0, 0, 0, 0, 0,
                                0, 1, 1, 0, 0, 0, 0, 0,
                                0, 1, 1, 1, 0, 0, 0, 0,
                                0, 0, 1, 1, 1, 0, 0, 0,
                                0, 0, 0, 1, 1, 1, 0, 0,
                                0, 0, 0, 0, 1, -1, 1, -1,
                                0, 0, 0, 0, 0, 1, -1, 2,
                                0, 0, 0, 0, 0, -1, 2, -1,
                                0, 0, 0, 1, 2, 2, 0, 0,
                                0, 0, 1, 1, 1, -1, 0, 0];
                
                setCell(data, 8, 10);
                
                mirrorXCheck.selected = false;
                mirrorYCheck.selected = true;
                diagonalLeftCheck.selected = false;
                diagonalRightCheck.selected = false;
                colorCheck.selected = true;
                saturationSlider.value = 0.5;
                saturationLabel.text = String(saturationSlider.value);
                colorSlider.value = 0.2;
                colorLabel.text = String(colorSlider.value);
                
                generate();
            });
            bowButton.width = humanoidButton.width;
            
            badgeButton = new PushButton(this, bowButton.x, bowButton.y + bowButton.height, "Badge", function(e:Event):void {
                
                var data:Array = [0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 1, 1,
                                0, 0, 1, 1, 1, 1,
                                0, 0, 0, 1, 1, 2,
                                0, 0, 0, 0, 1, 2,
                                0, 0, 0, 0, 0, -1];
                
                setCell(data, 6, 6);
                
                mirrorXCheck.selected = true;
                mirrorYCheck.selected = true;
                diagonalLeftCheck.selected = false;
                diagonalRightCheck.selected = true;
                colorCheck.selected = true;
                saturationSlider.value = 1;
                saturationLabel.text = String(saturationSlider.value);
                colorSlider.value = 0.05;
                colorLabel.text = String(colorSlider.value);
                
                generate();
            });

            badgeButton.width = bowButton.width;
            
            label = new Label(this, badgeButton.x, badgeButton.y + badgeButton.height + 5, "Scale");
            scaleStepper = new NumericStepper(this, label.x + label.width, label.y, function(e:Event):void {
                mapScale = e.target.value;
                outputSprite.scaleX = outputSprite.scaleY = mapScale;
                renderPixelData();
            });
            scaleStepper.minimum = 1;
            scaleStepper.maximum = 10;
            scaleStepper.value = mapScale;
            scaleStepper.width = colorLabel.x - scaleStepper.x - 10;
            
            diagonalLeftCheck = new CheckBox(this, clearButton.x, colorLabel.y + 5, "Diagonal Left", function(e:Event):void {
                if (e.target.selected == true)
                {
                    diagonalRightCheck.selected = false;
                }
                generate();
            });
            diagonalRightCheck = new CheckBox(this, diagonalLeftCheck.x, diagonalLeftCheck.y + diagonalLeftCheck.height + 10, "Diagonal Right", function(e:Event):void {
                if (e.target.selected == true)
                {
                    diagonalLeftCheck.selected = false;
                }
                generate();
            });
        }
        
        private function spaceShip(e:Event = null):void
        {
            var data:Array = [0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 1, 1,
                                0, 0, 0, 0, 1, -1,
                                0, 0, 0, 1, 1, -1,
                                0, 0, 0, 1, 1, -1,
                                0, 0, 1, 1, 1, -1,
                                0, 1, 1, 1, 2, 2,
                                0, 1, 1, 1, 2, 2,
                                0, 1, 1, 1, 2, 2,
                                0, 1, 1, 1, 1, -1,
                                0, 0, 0, 1, 1, 1,
                                0, 0, 0, 0, 0, 0];
                
            setCell(data, 6, 12);
            
            mirrorXCheck.selected = true;
            mirrorYCheck.selected = false;
            diagonalLeftCheck.selected = false;
            diagonalRightCheck.selected = false;
            colorCheck.selected = true;
            saturationSlider.value = 0.5;
            saturationLabel.text = String(saturationSlider.value);
            colorSlider.value = 0.2;
            colorLabel.text = String(colorSlider.value);
            
            generate();
        }

        private function setCell(data:Array, w:int, h:int):void
        {
            var i:int;
            var j:int;
            var cell:Cell;
            
            mapWidth = w;
            mapHeight = h;
            
            showCell();
            
            for (i = 0; i < mapHeight; i += 1)
            {
                for (j = 0; j < mapWidth; j += 1)
                {
                    cell = cellArray[i * mapWidthMax + j];
                    cell._status = data[i * mapWidth + j];
                    
                    cell.draw();
                }
            }
            
        }
        
        private function initBitmap():void
        {
            outputBitmapData = new BitmapData(465, 465, true, 0x00ffffff);
            outputBitmap = new Bitmap(outputBitmapData);
            //outputBitmap.y = mapHeightMax * cellWidth + 10;
            
            outputSprite = new Sprite();
            outputSprite.addChild(outputBitmap);
            outputSprite.scaleX = outputSprite.scaleY = mapScale;
            outputSprite.y = 16 * cellWidth + 10;
            
            outputSprite.mouseEnabled = false;
            
            addChild(outputSprite);
            
        }
        
        private function onCellClick(e:MouseEvent):void
        {
            var cell:Cell = e.target as Cell;
            
            if (cell._status == 2)
            {
                cell._status = -1;
            }
            else
            {
                cell._status += 1;
            }
            
            cell.draw();
            
            generate();
            
        }
        
        private function onCellOver(e:MouseEvent):void
        {
            var cell:Cell = e.target as Cell;
            cell._outline.visible = true;
        }
        
        private function onCellOut(e:MouseEvent):void
        {
            var cell:Cell = e.target as Cell;
            cell._outline.visible = false;
        }
        
        private function initSample():void
        {
            sampleArray = [];
            
            var i:int;
            var j:int;
            var k:int;
            var len:int = sampleStepper.value;
            var sample:Array;
            var posObj:Object;
            var posArray:Array;
            var cellString:String;
            var mirrorObj:Object;
            
            for (k = 0; k < len; k += 1)
            {
                posObj = new Object();
                
                for (i = 0; i < mapHeight; i += 1)
                {
                    for (j = 0; j < mapWidth; j += 1)
                    {
                        posObj[String(j) + "#" + String(i)] = cellArray[i * mapWidthMax + j]._status;
                    }
                }
                
                sampleArray.push(posObj);
            }
            
            
        }
        
        private function generateRandomSample():void
        {
            var posObj:Object;
            var posArray:Array;
            var newObj:Object;
            
            var k:int;
            var len:int = sampleArray.length;
            var dot:int;
            var cellString:String;
            
            for (k = 0; k < len; k += 1)
            {
                posObj = sampleArray[k];
                newObj = new Object();
                
                for (cellString in posObj)
                {
                    dot = posObj[cellString];
                    
                    if (dot == 1)
                    {
                        dot = int(Math.random() * 2);
                    }
                    else if (dot == 2)
                    {
                        if (Math.random() < 0.5)
                        {
                            dot = 1;
                        }
                        else
                        {
                            dot = -1;
                        }
                    }
                    
                    newObj[cellString] = dot;
                }
                
                sampleArray.splice(k, 1, newObj);
                
            }
        }
        
        private function generateEdges():void
        {
            var i:int;
            var j:int;
            var k:int;
            
            var len:int;
            var posObj:Object;
            var posArray:Array;
            var cellString:String;
            
            var imageWidth:int;
            var imageHeight:int;
            
            imageWidth = mapWidth;
            if (mirrorXCheck.selected == true)
            {
               imageWidth *= 2;
            }
            imageHeight = mapHeight;
            if (mirrorYCheck.selected == true)
            {
                imageHeight *= 2;
            }
            
            len = sampleArray.length;
            
            for (k = 0; k < len; k += 1)
            {
                posObj = sampleArray[k];
                
                for (cellString in posObj)
                {
                    posArray = cellString.split("#");
                    
                    j = parseInt(posArray[0]);
                    i = parseInt(posArray[1]);
                    
                    if (posObj[cellString] > 0)
                    {
                        if (j > 0 && posObj[String(j - 1) + "#" + String(i)] == 0)
                        {
                            posObj[String(j - 1) + "#" + String(i)] = -1;
                        }
                        if (j < imageWidth - 1 && posObj[String(j + 1) + "#" + String(i)] == 0)
                        {
                            posObj[String(j + 1) + "#" + String(i)] = -1;
                        }
                        if (i > 0 && posObj[String(j) + "#" + String(i - 1)] == 0)
                        {
                            posObj[String(j) + "#" + String(i - 1)] = -1;
                        }
                        if (i < imageHeight - 1 && posObj[String(j) + "#" + String(i + 1)] == 0)
                        {
                            posObj[String(j) + "#" + String(i + 1)] = -1;
                        }
                    }
                }
                
            }
            
        }
        
        private function mirror():void
        {
            var posObj:Object;
            var posArray:Array;
            var cellString:String;
            var mirrorObj:Object;
            var k:int;
            var len:int;
            
            
            len = sampleArray.length;
            
            for (k = 0; k < len; k += 1)
            {
                posObj = sampleArray[k];
                
                if (mirrorXCheck.selected == true)
                {
                    mirrorObj = new Object();
                    for (cellString in posObj)
                    {
                        posArray = cellString.split("#");
                        
                        mirrorObj[String(mapWidth * 2 - parseInt(posArray[0]) - 1) + "#" + posArray[1]] = posObj[cellString];
                    }
                    
                    for (cellString in mirrorObj)
                    {
                        posObj[cellString] = mirrorObj[cellString];
                    }
                    
                }
                
                if (mirrorYCheck.selected == true)
                {
                    mirrorObj = new Object();
                    
                    for (cellString in posObj)
                    {
                        posArray = cellString.split("#");
                        
                        mirrorObj[posArray[0] + "#" + String(mapHeight * 2 - parseInt(posArray[1]) - 1)] = posObj[cellString];
                    }
                    
                    for (cellString in mirrorObj)
                    {
                        posObj[cellString] = mirrorObj[cellString];
                    }
                }
            }
        }
        
        private function mirrorDiagonalLeft():void
        {
            var posObj:Object;
            var posArray:Array;
            var cellString:String;
            var i:int;
            var j:int;
            var k:int;
            var len:int;
            
            len = sampleArray.length;
            
            var imageWidth:int;
            var imageHeight:int;
            
            imageWidth = mapWidth;
            if (mirrorXCheck.selected == true)
            {
                imageWidth *= 2;
            }
            imageHeight = mapHeight;
            if (mirrorYCheck.selected == true)
            {
                imageHeight *= 2;
            }
            
            var new_x:int;
            var new_y:int;
            
            for (k = 0; k < len; k += 1)
            {
                posObj = sampleArray[k];
                
                for (cellString in posObj)
                {
                    posArray = cellString.split("#");
                    
                    j = parseInt(posArray[0]);
                    i = parseInt(posArray[1]);
                    
                    if (i + j < imageWidth)
                    {
                        new_x = (mapWidth - 1) + 0 - i;
                        new_y = (mapWidth - 1) - j;
                        
                        posObj[String(new_x) + "#" + String(new_y)] = posObj[cellString];
                    }
               }
                
            }
            
            
        }
        
        private function mirrorDiagonalRight():void
        {
            var posObj:Object;
            var posArray:Array;
            var cellString:String;
            var i:int;
            var j:int;
            var k:int;
            var len:int;
            
            len = sampleArray.length;
            
            var imageWidth:int;
            var imageHeight:int;
            
            imageWidth = mapWidth;
            if (mirrorXCheck.selected == true)
            {
                imageWidth *= 2;
            }
            imageHeight = mapHeight;
            if (mirrorYCheck.selected == true)
            {
                imageHeight *= 2;
            }
            
            for (k = 0; k < len; k += 1)
            {
                posObj = sampleArray[k];
                
                for (cellString in posObj)
                {
                    posArray = cellString.split("#");
                    
                    j = parseInt(posArray[0]);
                    i = parseInt(posArray[1]);
                    
                    if (j > i)
                    {
                        posObj[String(i) + "#" + String(j)] = posObj[cellString];
                    }
                }
                
            }
        }
        
        private function renderPixelData():void
        {
            //outputBitmap.y = mapHeight * cellWidth + 10;
            
            outputBitmapData.fillRect(outputBitmapData.rect, 0x00ffffff);
            
            var i:int;
            var j:int;
            var k:int;
            
            var len:int;
            len = sampleArray.length;
            
            var isVerticalGradient:Boolean = Math.random() > 0.5;
            var saturation:Number;
            var hue:Number;
            var brightness:Number;
            
            var posObj:Object;
            var cellString:String;
            var posArray:Array;
            var dot:int;
            var imageWidthNum:int;
            var image_x:int;
            var image_y:int;
            
            var imageWidth:int;
            var imageHeight:int;
            
            imageWidth = mapWidth;
            if (mirrorXCheck.selected == true)
            {
                imageWidth *= 2;
            }
            imageHeight = mapHeight;
            if (mirrorYCheck.selected == true)
            {
                imageHeight *= 2;
            }
            
            var color:uint;

            imageWidthNum = int(outputBitmapData.width / (imageWidth + 1) / mapScale);
            
            for (k = 0; k < len; k += 1)
            {
                posObj = sampleArray[k];
                image_x = k % imageWidthNum;
                image_y = int(k / imageWidthNum);
                
                hue = Math.random();
                saturation = Math.max(Math.min((Math.random() * saturationSlider.value), 1), 0);
                
                for (cellString in posObj)
                {
                    posArray = cellString.split("#");
                    
                    dot = posObj[cellString];
                    
                    j = parseInt(posArray[0]);
                    i = parseInt(posArray[1]);
                    
                    if (dot != 0)
                    {
                        if (isVerticalGradient)
                        {
                            brightness = Math.sin((i / imageHeight) * Math.PI) * 0.7 + Math.random() * 0.3;
                        }
                        else
                        {
                            brightness = Math.sin((j / imageWidth) * Math.PI) * 0.7 + Math.random() * 0.3;
                        }
                        
                        if (Math.random() > (1 - colorSlider.value))
                        {
                            hue = Math.random();
                        }
                        
                        color = getColorFromHSL(hue, saturation, brightness);
                        
                        if (colorCheck.selected == true)
                        {
                            if (dot == -1)
                            {
                                outputBitmapData.setPixel32(image_x * (imageWidth + 1) + j, image_y * (imageHeight + 1) + i, (0xff << 24) | darken(color));
                            }
                            else
                            {
                                outputBitmapData.setPixel32(image_x * (imageWidth + 1) + j, image_y * (imageHeight + 1) + i, (0xff << 24) | color);
                            }
                        }
                        else if (dot == -1)
                        {
                            outputBitmapData.setPixel32(image_x * (imageWidth + 1) + j, image_y * (imageHeight + 1) + i, (0xff << 24) | 0x000000);
                        }
                    }
                }
            }
          
            
        }
        
        private function darken(color:uint):uint
        {
            var r:uint;
            var g:uint;
            var b:uint;
            
            r = color >> 16 & 0xff;
            g = color >> 8 & 0xff;
            b = color & 0xff;
            
            r *= 0.3;
            g *= 0.3;
            b *= 0.3;
            
            return r << 16 | g << 8 | b;
        }
        
        private function getColorFromHSL( h:Number, s:Number, l:Number ):uint
        {
            var r:Number = 0;
            var g:Number = 0;
            var b:Number = 0;
            
            var temp2:Number;
            var temp1:Number;
            
            if (l != 0.0)
            {
                if (s == 0.0)
                {
                    r = g = b = l;
                }
                else
                {
                    if (l < 0.5)
                    {
                        temp2 = l * (1 + s);
                    }
                    else
                    {
                        temp2 = l + s - (l * s);
                    }
                    temp1 = 2 * l - temp2;
                    
                    r = getColorComponent(temp1, temp2, h + 1 / 3.0);
                    g = getColorComponent(temp1, temp2, h);
                    b = getColorComponent(temp1, temp2, h - 1 / 3.0);
                }
            }
            
            return Math.round(r * 255) << 16 | Math.round(g * 255) << 8 | Math.round(b * 255);
        }
        
        private function getColorComponent(temp1:Number, temp2:Number, temp3:Number):Number
        {
            if (temp3 < 0)
            {
                temp3 += 1;
            }
            else if (temp3 > 1)
            {
                temp3 -= 1;
            }
            
            if (temp3 < 1 / 6.0)
            {
                return temp1 + (temp2 - temp1) * 6.0 * temp3;
            }
            else if (temp3 < .5)
            {
                return temp2;
            }
            else if (temp3 < 2 / 3.0)
            {
                return temp1 + ((temp2 - temp1) * ((2 / 3.0) - temp3) * 6.0);
            }
            
            return temp1;
        }
    }
    
}

Class
{
    import com.bit101.components.Label;
    import flash.display.Shape;
    import flash.display.Sprite;
    /**
     * ...
     * @author ypc
     */
    class Cell extends Sprite
    {
        public var _x:int;
        public var _y:int;
        public var _shape:Shape;
        public var _status:int = 0;
        public var _label:Label;
        public var _outline:Shape;
        
        public function Cell(_x:int, _y:int) 
        {
            this._x = _x;
            this._y = _y;
            
            _shape = new Shape();
            addChild(_shape);
            
            _label = new Label(this, 0, 0, String(_status));
            
            _outline = new Shape();
            _outline.graphics.lineStyle(3, 0xff0000, 0.7);
            _outline.graphics.drawRect(0, 0, 16, 16);
            _outline.visible = false;
            addChild(_outline);
            
            draw();
        }
        
        public function draw():void
        {
            _shape.graphics.clear();
            _shape.graphics.lineStyle(0, 0, 1);
            switch(_status)
            {
                case -1:
                    _shape.graphics.beginFill(0xFFC0C0);
                    
                    break;
                
                case 0:
                    _shape.graphics.beginFill(0xffffff);
                    
                    break;
                    
                case 1:
                    _shape.graphics.beginFill(0xC0FFC0);
                    
                    break;
                    
                case 2:
                    _shape.graphics.beginFill(0xC0C0FF);
                    
                    break;
            }
            
            _shape.graphics.drawRect(0, 0, 16, 16);
            _shape.graphics.endFill();
            
            _label.text = String(_status);
        }
        
    }

}