/**
 * Copyright web.flash.helper ( http://wonderfl.net/user/web.flash.helper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8rrM
 */

package {
    import flash.text.TextField;
    

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.filters.BitmapFilter;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.ByteArray;
    import flash.media.SoundLoaderContext;
    
    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]
    public class SoundTest extends Sprite {
        private static const POLICY_FILE:String = "http://www.mrxstudio.com/crossdomain.xml";
        private static const SOUND_FILE:String = "http://www.mrxstudio.com/blog/bgm1.mp3";
        
        private var _sound:Sound = new Sound();
        private var _channel:SoundChannel;
        
        private var _leftBars:Vector.<Bar>;
        private var _rightBars:Vector.<Bar>;
        
        private var _canvas:Bitmap;
        private var _colorTransform:ColorTransform = new ColorTransform(.9, .9, .9);
        private var _filter:BitmapFilter = new BlurFilter(8, 4);
        
        {
            Wonderfl.capture_delay( 33 );
        }
        
        
        public function SoundTest() {
     
            _leftBars = new Vector.<Bar>();
            _rightBars = new Vector.<Bar>();
            var bar:Bar;
            for (var i:uint=0; i<64; i++) {
                // 左
                bar = new Bar(0xffffff, false);
                bar.y = i * (Bar.LENGTH + Bar.MARGIN) + Bar.LENGTH + 10; 
                bar.x = (Bar.LENGTH + Bar.MARGIN) * Bar.NUM_RECT;
                _leftBars.unshift(bar);
                
                // 右
                bar = new Bar(0xffffff, false);
                bar.y = i * (Bar.LENGTH + Bar.MARGIN) + 10;
                bar.x = Math.floor(stage.stageWidth / 2) + 1;
                _rightBars.unshift(bar);
            }
            
       
            _canvas = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xff000000));
            addChild(_canvas);
            
           
            Security.loadPolicyFile(POLICY_FILE);
   
            _sound.addEventListener(Event.COMPLETE, onLoadComplete);
            _sound.addEventListener(IOErrorEvent.IO_ERROR, onLoadError);
            _sound.load(new URLRequest(SOUND_FILE), new SoundLoaderContext(10000, true));
        }
        
        
        private function onLoadComplete(evt:Event):void {
            this.addEventListener(Event.ENTER_FRAME, loop);
            _channel = _sound.play(0, int.MAX_VALUE);
        }
        
        
       
        private function loop(evt:Event):void {
            var data:ByteArray = new ByteArray();
            var matrix:Matrix;
            var rect:Rectangle = new Rectangle(0, 0, _canvas.width, _canvas.height);
            var dp:Point = new Point(0, 0);
            
            _canvas.bitmapData.lock();
  
            SoundMixer.computeSpectrum(data, true);
            
            // 色調整
            var d:Number = Math.max(_channel.rightPeak, _channel.leftPeak) * .02;
            _colorTransform.redMultiplier += (.5 - Math.random()) * d;
            _colorTransform.blueMultiplier += (.5 - Math.random()) * d;
            _colorTransform.greenMultiplier += (.5 - Math.random()) * d;
            _colorTransform.redMultiplier = Math.min(Math.max(_colorTransform.redMultiplier, .8), 1);
            _colorTransform.blueMultiplier = Math.min(Math.max(_colorTransform.blueMultiplier, .8), 1);
            _colorTransform.greenMultiplier = Math.min(Math.max(_colorTransform.greenMultiplier, .8), 1);
            _canvas.bitmapData.colorTransform(rect, _colorTransform);
            
      
            _canvas.bitmapData.applyFilter(_canvas.bitmapData, rect, dp, _filter);
            

            for (var i:uint=0; i<64; i++) {
                _leftBars[i].setLevel(Math.sqrt((data.readFloat() + data.readFloat() + data.readFloat() + data.readFloat()) / 4));
                matrix = new Matrix();
                matrix.rotate(Math.PI)
                matrix.translate(_leftBars[i].x, _leftBars[i].y);
                _canvas.bitmapData.draw(_leftBars[i], matrix);
            }
                
          
            for (i=0; i<64; i++) {
                _rightBars[i].setLevel(Math.sqrt((data.readFloat() + data.readFloat() + data.readFloat() + data.readFloat()) / 4));
                matrix = new Matrix();
                matrix.translate(_rightBars[i].x, _rightBars[i].y);
                _canvas.bitmapData.draw(_rightBars[i], matrix);
            }
            
            _canvas.bitmapData.unlock();
        }
        
        
        private function onLoadError(evt:IOErrorEvent):void {
            trace("失敗");
            var text:TextField = new TextField();
            text.text = "失敗";
            text.textColor = 0xffffff;
            text.width = 200;
            addChild(text);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;

class Bar extends Sprite {

    public static const NUM_RECT:uint = 33;

    public static const LENGTH:uint = 5;

    public static const MARGIN:uint = 2;

    public static const MAX_LENGTH:uint = (LENGTH + MARGIN) * NUM_RECT - MARGIN;
    

    private var _rects:Vector.<Bitmap>;
    

    public function Bar(color:uint=0xffffff, gradient:Boolean=false) {
        var r:uint = (color & 0x00ff0000) >> 16;
        var g:uint = (color & 0x0000ff00) >> 8;
        var b:uint = (color & 0x000000ff);
        
        _rects = new Vector.<Bitmap>;
        for (var i:uint = 0; i < NUM_RECT; i++) {
            var grad:Number = Math.min(Math.sqrt((i+1)/NUM_RECT+.4), 1)
            var c:uint = (r*grad << 16) | (g*grad << 8) | b*grad;
            var bmp:Bitmap = new Bitmap(new BitmapData(LENGTH, LENGTH, false, gradient ? c : color));
            
            bmp.x = i * (LENGTH + MARGIN);
            _rects[i] = bmp;
            addChild(bmp);
            bmp.visible = false;
        }
    }
    
 
    public function setLevel(level:Number):void {
        level = Math.min(NUM_RECT, Math.floor(NUM_RECT * level));
        
        for (var i:uint = 0; i<NUM_RECT; i++) {
            _rects[i].visible = i<level;
        }
    }
}
