/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8qq3
 */

// forked from ohisama's flash on 2013-1-30
package
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.utils.ByteArray;
    import com.bit101.components.*;
    public class Main extends Sprite
    {
        private const SAMPLE_CODE : String = '\tpush\t"i"\n\tpush\t"0"\t\n\tset\n\tpush\t"x"\nloop\tpush\t"i"\n\tpush\t"i"\n\tget\t\n\tpush\t"1"\n\t+\n\tset\n\tpush\t"29"\n\tpush\t"i"\n\tget\n\t>\n\t!\n\tif\tloop\n\tpush\t"i"\n\tget\n\tset\n';
        private var editor : TextArea;
        private var stdout : TextArea;
        private var button : PushButton;
        public function Main()
        {
            Style.fontSize = 10;
            editor = new TextArea(this, 0, 0);
            editor.width = 200;
            editor.height = 380;
            editor.text = SAMPLE_CODE;
            stdout = new TextArea(this, 250, 0);
            stdout.width = 200;
            stdout.height = 380;
            button = new PushButton(this, 200, 220, "abc", function(e : MouseEvent) : void
            {
                stdout.text = "";
                run();
            });
            button.width = 50;
        }
        private function run() : void
        {
            var c1 : int;
            var c2 : int;
            var c3 : int;
            var a : String;
            var i : int;
            var j : int;
            var pc : int = 0;
            var la : Array = new Array();
            var r : ByteArray = new ByteArray();
            var m : Array = String(editor.text).split("\n");
            //stdout.text = String(m.length);
            for (j = 0; j < m.length ; j++)
            {
                //stdout.text += m[j];
                var cm : Array = String(m[j]).split("\t");
                if (cm[0] != "") la[cm[0]] = pc + 2;
                switch (cm[1])
                {
                case "if":
                    r[pc] = 0x9D;
                    pc++;
                    r[pc] = 0x02;
                    pc++;
                    r[pc] = 0x00;
                    pc++;
                    if (la[cm[2]] > 1)
                    {
                        c3 = 255 + la[cm[2]] - pc - 3;
                        r[pc] = c3;
                        pc++;
                        r[pc] = 0xFF;
                        pc++;
                    }
                    else
                    {
                        r[pc] = cm[2];
                        pc++;
                        r[pc] = 0x00;
                        pc++;
                    }
                break;
                case "jump":
                    r[pc] = 0x99;
                    pc++;
                    r[pc] = 0x02;
                    pc++;
                    r[pc] = 0x00;
                    pc++;
                    if (la[cm[2]] > 1)
                    {
                        c3 = 255 + la[cm[2]] - pc - 3;
                        r[pc] = c3;
                        pc++;
                        r[pc] = 0xFF;
                        pc++;
                    }
                    else
                    {
                        r[pc] = cm[2];
                        pc++;
                        r[pc] = 0x00;
                        pc++;
                    }
                break;
                case "push":
                    r[pc] = 0x96;
                    pc++;
                    c1 = cm[2].indexOf("\"") + 1;
                    c2 = cm[2].indexOf("\"", 1) - c1;
                    a = cm[2].substr(c1, c2);
                    c3 = c2 + 2;
                    r[pc] = c3;
                    pc++;
                    r[pc] = 0x00;
                    pc++;
                    r[pc] = 0x00;
                    pc++;
                    for (i = 0; i < c2; i++)
                    {
                        r[pc] = a.charAt(i);
                        pc++;
                    }
                    r[pc] = 0x00;
                    pc++;
                break;
                case "end":
                    r[pc] = 0x00;
                    pc++;
                break;
                case "+":
                    r[pc] = 0x0A;
                    pc++;
                break;
                case "-":
                    r[pc] = 0x0B;
                    pc++;
                break;
                case "*":
                    r[pc] = 0x0C;
                    pc++;
                break;
                case "/":
                    r[pc] = 0x0D;
                    pc++;
                break;
                case "=":
                    r[pc] = 0x0E;
                    pc++;
                break;
                case ">":
                    r[pc] = 0x0F;
                    pc++;
                break;
                case "&":
                    r[pc] = 0x10;
                    pc++;
                break;
                case "|":
                    r[pc] = 0x11;
                    pc++;
                break;
                case "!":
                    r[pc] = 0x12;
                    pc++;
                break;
                case "eq":
                    r[pc] = 0x13;
                    pc++;
                break;
                case "len":
                    r[pc] = 0x14;
                    pc++;
                break;
                case "pop":
                    r[pc] = 0x17;
                    pc++;
                break;
                case "int":
                    r[pc] = 0x18;
                    pc++;
                break;
                case "get":
                    r[pc] = 0x1C;
                    pc++;
                break;
                case "set":
                    r[pc] = 0x1D;
                    pc++;
                break;
                case "add":
                    r[pc] = 0x21;
                    pc++;
                break;
                case "rnd":
                    r[pc] = 0x30;
                    pc++;
                break;
                case "time":
                    r[pc] = 0x34;
                    pc++;
                break;
                }
            }        
            for (j = 0; j < la.length; j++)
            {
                for (i = 0; i < pc; i++)
                {
                    if (r[i] == la[j])
                    {
                        c3 = la[j] - i - 4;
                        r[i] = c3;
                    }
                }
            }
            for (i = 0; i < r.length; i++)
            {
                stdout.text += String(i) + " - " + toHex(r[i]) + "\n";
            }
        }
        function toHex(intVal : int) : String 
        {
            var hex : String = intVal.toString(16);
            return (hex.length == 1) ? "0x0" + hex  : "0x" + hex;
        }
    }
}

