/**
 * Copyright djakarta_trap ( http://wonderfl.net/user/djakarta_trap )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8qMc
 */

// forked from nondelion's Brightness tween with BetweenAS3 
package
{
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.MouseEvent;
    import flash.filters.ColorMatrixFilter;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.IObjectTween;
    
    public class BrightnessTweenTest extends Sprite
    {   
        private var box:Sprite;
        private var t:IObjectTween;
        
        public function BrightnessTweenTest() 
        {
            box = addChild( new Sprite() ) as Sprite;
            box.graphics.beginFill(0xff0000, 1.0);
            box.graphics.drawRect(0, 0, 300, 300);
            box.graphics.endFill();
            box.x = 82.5;
            box.y = 82.5;
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            
            var txt:TextField = addChild( new TextField() ) as TextField;
            txt.text = "Click to start";
            txt.autoSize = TextFieldAutoSize.LEFT;
                 
        }
        
        private function mouseDownHandler(evt:MouseEvent):void
        {
            if(t) t.stop();
            t = BetweenAS3.tween( box,
                {
                    _colorMatrixFilter : {
                        matrix: [
                            1, 0, 0, 0, 0,
                            0, 1, 0, 0, 0,
                            0, 0, 1, 0, 0,
                            0, 0, 0, 1, 0
                        ]
                    }
                },
                {
                    _colorMatrixFilter : {
                        matrix: [
                            1, 0, 0, 0, -255,
                            0, 1, 0, 0, -255,
                            0, 0, 1, 0, -255,
                            0, 0, 0, 1, 0
                        ]
                    }
                }, 4.0, Linear.linear );
            t.play();
        }
    }
}