/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8qD5
 */

package {
    import flash.display.Sprite;
    import flash.geom.Point;
    [SWF(backgroundColor = "#000000", frameRate = 120)]
    public class FlashTest extends Sprite {
        public function FlashTest() {
			var cla:CurveLineAnimation = new CurveLineAnimation(stage);
			cla.start(new Point(0, 150), new Point(465, 465), new Vector.<Point>(new Point(150, 150), new Point(130, 300)), 3);
        }
    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.PixelSnapping;
import flash.display.Stage;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
class CurveLineAnimation {
	private static var stage:Stage;
	private var bitmap:Bitmap;
	private var bitmapData:BitmapData;
	private var sprite:Sprite;
	public function CurveLineAnimation(_stage:Stage) {
		stage = _stage;
		
		sprite = stage.addChild(new Sprite()) as Sprite;
		bitmapData = new BitmapData(465, 465, false, 0x111111);
		bitmap = stage.addChild(new Bitmap(bitmapData, PixelSnapping.AUTO, false)) as Bitmap;
	}
	
	private var drawPoint:Point;
	public function start(pointFrom:Point, pointTo:Point, controlPoints:Vector.<Point>, time:uint):void {
		drawPoint = pointFrom as Point;
		var pointsArray:Vector.<Array>;

		for (var i:uint = 0; i < controlPoints.length; i++) {
			pointsArray[0].push(controlPoints[i].x as Number);
			pointsArray[1].push(controlPoints[i].y as Number);
		}
		
		//pointsArray[0] とコントロールポイントに設定できない (?)
		var tween:ITween = BetweenAS3.bezier(drawPoint, { x: pointTo.x, y: pointTo.y }, null, { x: [150, 300, 200] , y: [100, 150, 300]}, time);
		tween.play();
		tween.addEventListener(TweenEvent.COMPLETE, completed);
		stage.addEventListener(Event.ENTER_FRAME, draw);
		
		function completed(e:TweenEvent):void {
			stage.removeEventListener(Event.ENTER_FRAME, draw);
		}
	}
	
	private function draw(e:Event = null):void {
		sprite.graphics.beginFill(0xffffff);
		sprite.graphics.drawCircle(drawPoint.x, drawPoint.y, 5);
		sprite.graphics.endFill();
		bitmapData.lock();
		bitmapData.draw(sprite);
		bitmapData.unlock();
		
		sprite.graphics.clear();
	}
}