/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8pm8
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.GouraudMaterial;

    public class FlashTest extends Sprite {
        private var _view:BasicView;
        private var _frame:uint;
        
        public function FlashTest() {
            _view = new BasicView(465, 465);
            _view.camera.zoom = 50;
            this.addChild(_view);            

            _frame = 0;
            
            var container:DisplayObject3D = new DisplayObject3D();
            container.rotationX = -30.0;
            _view.scene.addChild(container);

            var light:PointLight3D = new PointLight3D(false);
            light.x = 500;
            light.y = 300;
            light.z = -100;
            container.addChild(light);

            var mat:GouraudMaterial = new GouraudMaterial(light, 0xd0d0ff);
            var materials:MaterialsList = new MaterialsList();
            materials.addMaterial(mat, "all");
            
            var width:uint = 30;
            var height:uint = 20;
            var cubeArray:Array = new Array();
            for (var z:uint = 0; z < height; ++z) {
                cubeArray.push(new Array());
                for (var x:uint = 0; x < width; ++x) {
                    var size:Number = 25;
                    var cube:Cube = new Cube(materials, size, size, 5, 1, 1, 1);
                    cube.x = -(size * (width / 2)) + (x * size);
                    cube.z = -200 + z * size;
                    container.addChild(cube);
                    cubeArray[z].push(cube);
                }
            }

            _view.startRendering();

            var proc:Function = function(e:Event):void {
                ++_frame;
                for (var z:uint = 0; z < height; ++z) {
                    for (var x:uint = 0; x < width; ++x) {
                        var rad:Number = (x * 0.1) + (z * 0.1);
                        rad += _frame * 0.1;
                        cubeArray[z][x].y = Math.sin(rad) * 50;
                    }
                }
            };
            this.addEventListener(Event.ENTER_FRAME, proc);
        }
    }
}
