/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ov3
 */

// forked from s8t1h12akj's forked from: forked from: forked from: REDUX
// forked from s8t1h12akj's forked from: forked from: REDUX
// forked from s8t1h12akj's forked from: REDUX
// forked from spanvega's REDUX
package
{
    /*
    GUI CONTROLS
    - Fullscreen 
    ( disabled on wonderfl since file explorer exits fullscreen mode )
    - Open Image
    - Save image
    - Mode (0 : Static, 1 : Scroll , 2 : Animate)
    */

    import flash.net.*;
    import flash.geom.*;
    import flash.utils.*;
    import flash.events.*;
    import flash.display.*;
    import flash.system.LoaderContext;

    import com.bit101.components.*;

    /*  @author SPANVEGA // CHRISTIAN  */

    public class REDUX extends Sprite
    {
        private var w : uint, h : uint,
                    v : Vector.<uint>,
                    m : Vector.<uint>,
                    b : BitmapData,
                    r : Rectangle,
                    n : uint;

        private var size : int = 150,
                    edge : int = 10,
                    scale  : Number;
                    
        private var mode : int = 1,
                    index : int;

        private var source : BitmapData,
                    bitmap : Bitmap,
                    loader : Loader,
                    holder : Sprite;

        private var cursor_point : Point = new Point,
                    cursor_rect : Rectangle,
                    cursor : BitmapData;

        private var thumb_point : Point = new Point,
                    thumb_rect : Rectangle,
                    thumb : BitmapData;

        private var border_rect : Rectangle;

        private var fileFilter : FileFilter = new FileFilter
        (
            'Images (*.jpeg, *.jpg, *.gif, *.png)',
            '*.jpeg; *.jpg; *.gif; *.png;',
            'JPEG; jp2_; GIFF'
        );
        private var file : FileReference;


        public function REDUX ()
        {
            with (stage) { scaleMode = 'noScale'; align = 'TL'; frameRate = 30; color = 0xFFFFFF; }

            //

            var s : Shape = new Shape ();
            s.graphics.lineStyle (1, 0xFFFFFF);

            s.graphics.moveTo (0, 2);
            s.graphics.lineTo (5, 2);

            s.graphics.moveTo (2, 0);
            s.graphics.lineTo (2, 5);

            cursor = new BitmapData (s.width, s.height, true, 0);
            cursor.draw (s);

            cursor_rect = cursor.rect;

            //

            addChild (bitmap = new Bitmap ());

            gui ();

            //

            file = new FileReference ();

            file.addEventListener (Event.SELECT, select);
            file.addEventListener (Event.COMPLETE, load);

            //

            loader = new Loader ();

            loader.contentLoaderInfo.addEventListener (Event.COMPLETE, setup);
            loader.load (new URLRequest
            ('http://kouetu.sakura.ne.jp/yokihi.jpg'),
                         new LoaderContext (true));

            //

            stage.addEventListener (Event.RESIZE, function () : void
            {
                position ();

                holder.y = stage.stageHeight - 30;
            });

            stage.addEventListener (MouseEvent.MOUSE_DOWN, function () : void
            {
                var temp : int = location ();
            
                if (temp != -1)
                {
                    index = temp;

                    if (mode == 0) calc ();
                }
            });

            stage.addEventListener (Event.ENTER_FRAME, frame);
        }

        private function setup (e : Event = null) : void
        {
            w = e.target.width;
            h = e.target.height;

            scale = size / (w > h ? w : h);

            r = new Rectangle (0, 0, w, h);

            source = e.target.content.bitmapData;

            thumb = new BitmapData (w * scale, h * scale, false, 0);
            thumb.draw (source, new Matrix (scale, 0, 0, scale), null, null, null, true);

            thumb_rect = thumb.rect;

            border_rect = new Rectangle (0, 0, thumb.width + 2, thumb.height + 2);

            position ();

            v = source.getVector (r);

            m = new Vector.<uint> (n = w * h, true);

            b = new BitmapData (w, h, false, 0xFFFFFF);

            index = Math.random () * n;

            bitmap.bitmapData = b;

            //

            if (mode == 0) calc ();
        };

        private function frame (e : Event) : void
        {
            if (!b) return;

            if (mode != 0)
            {
                calc ();
    
                index += 1;
                index %= n;
            }

            draw ();

            // virtual cursor

            var temp : int = location ();

            if (temp != -1)
            {
                cursor_point.x = thumb_point.x + (temp % w) * scale - 2;
                cursor_point.y = thumb_point.y + (temp / w) * scale - 2;

                b.copyPixels (cursor, cursor_rect, cursor_point, null, null, true);
            }
        }

        private function location () : Number
        {
            var mx : int = mouseX,
                my : int = mouseY;

            if
            (
                mx > 0 && mx < w && my > 0 && my < h    // image bounds
                &&
                holder.hitTestPoint (mx, my) == false    // gui bounds
            ) 
            {
                // scale selected point to access entire image

                if (w > stage.stageWidth)
                {
                    mx *= w / stage.stageWidth;
                }
                if (h > stage.stageHeight)
                {
                    my *= h / stage.stageHeight;
                }

                return mx + my * w;
            }

            return -1;
        }

        private function calc () : void
        {
            var q : int = n;
            while (--q > -1)
            {
                m [q] = v
                [
                    (
                    q / w ^ 0
                    +
                    (
                    mode == 1
                    ?
                    q % w + index
                    :
                    q % w ^ index
                    )
                    )
                    %
                    n
                ];
            }
        }

        private function draw () : void
        {
            b.setVector (r, m);

            border_rect.x = thumb_point.x - 1;
            border_rect.y = thumb_point.y - 1;

            b.fillRect  (border_rect, 0xFFFFFF);

            b.copyPixels (thumb, thumb_rect, thumb_point, null, null, true);

            cursor_point.x = thumb_point.x + (index % w) * scale - 2;
            cursor_point.y = thumb_point.y + (index / w) * scale - 2;

            b.copyPixels (cursor, cursor_rect, cursor_point, null, null, true);
        }

        private function position () : void
        {
            thumb_point.x = int ((stage.stageWidth  < w ? stage.stageWidth  : w) - (w * scale + edge));
            
            thumb_point.y = int ((stage.stageHeight < h ? stage.stageHeight : h) - (h * scale + edge));
        }

        private function gui () : void
        {
            with (Style) { BACKGROUND = LABEL_TEXT = DROPSHADOW = 0xFFFFFF; BUTTON_FACE = 0x0; BUTTON_DOWN = 0x404040; }

            holder = new Sprite ();

            holder.graphics.beginFill (0x0, 0.35);

            holder.graphics.drawRect (0, 0, 190, 30);

            holder.y = stage.stageHeight - holder.height;

            with (new PushButton (holder, 5, 5, '+', screen))   { width = 15; draw (); enabled = false; }

            with (new PushButton (holder, 25, 5, 'OPEN', open)) { width = 50; draw (); }

            with (new PushButton (holder, 80, 5, 'SAVE', save)) { width = 50; draw (); }

            with (new NumericStepper (holder, 135, 5, change))  { width = 50; minimum = 0; maximum = 2; value = mode; draw (); }

            addChild (holder);
        }

        private function change (e : Event) : void { mode = e.target.value; }

        private function screen (e : Event) : void
        {
            if (stage.displayState == StageDisplayState.NORMAL)
            {
                stage.displayState = StageDisplayState.FULL_SCREEN;

                e.target.label = 'x';
            }
            else
            {
                stage.displayState = StageDisplayState.NORMAL;

                e.target.label = '+';
            }
        }

        private function open (e : Event) : void
        {
            file.browse ([fileFilter]);
        }

        private function select (e : Event) : void
        {
            file.load ();
        }

        private function load (e : Event) : void
        {
            loader.loadBytes (file.data);
        }

        private function save (e : Event) : void
        {
            var data : ByteArray = new ByteArray (),

                temp : BitmapData = b.clone ();

            temp.setVector (r, m);

            temp.encode (r, new PNGEncoderOptions (false), data);

            new FileReference ().save (data, ('REDUX_' + getTimer ()) + '.png');
        }
    }
}