/**
 * Copyright yaimo ( http://wonderfl.net/user/yaimo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8oiI
 */

/*
* Flash勉強会用wonderfl
* 基本的にはjavaと同じ記述方法です。
//ハイパーリンクな見せ方
//うすい（内容的
//背景
//一貫性
//目次読ませる
//自分の意見。
//ＰＣの活用
//文字が小さい
//スラドショーのスピード（たくさｎ
//内容別々
//ヒットする領域
*
AS3.0のAPIです。
http://livedocs.adobe.com/flash/9.0_jp/ActionScriptLangRefV3/index.html?language-elements.html&all-classes.html
*/
package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.text.*;
    
    //Flash SWFの初期設定を行います。幅、高さ、背景色、フレームレートなどを指定します。
    [SWF(width="465",height="465",backgroundColor="0xFFFFFF",frameRate="60")];
    
    //AS3ではSpriteかMovieClipクラスをextendsする必要があります。
    //わからない方はおまじないだと思ってください。
    public class FlashTest extends Sprite {
        
        //変数を宣言するときはvarを使います。
        //配列を用意します。配列を利用することで多くの値を管理することができます。
        private var lists:Array = new Array();
        
        public function FlashTest() {
            // write as3 code here..
            // Flashでは左上の座標が(0,0)となっており、右、下に行くほどx,y座標はプラスの値をとります。
            
            hellowWorld();
            
            //円を描きます
            //DrawCircle();
            
            //円を描き動かします
            //DrawAndMove();
            
            //円をランダムにたくさん生成します。
            //DrawCircleRandom();
        }
        
        public function hellowWorld():void{
            
            //テキストを扱うクラスTextFieldを生成します。
            var textField:TextField = new TextField();
            
            //テキストの内容をString型で指定します。
            textField.text = "Hellow World";
            
            //テキストの座標位置を(100,200)に設定します。
            textField.x = 100;
            textField.y = 200;
            
            //テキストを登録します。このように記述することで表示対象となります。
            addChild(textField);
        }
        
        //円を描く関数です
        public function DrawCircle():void{
            
            //円を描くための表示オブジェクトを用意します。
            //表示オブジェクトは名前のまま、Flashに描画できるクラスのことを指します。
            var circleSp:Sprite = new Sprite();
            
            //塗りの色を指定します。さらに描画の初めを宣言します。
            circleSp.graphics.beginFill(0xFFFF22);
     
            
            //円を描きます。x座標,y座標,円の半径を指定します。
            circleSp.graphics.drawCircle(0,0,50);
            
            /*
            * graphicsプロパティは円以外にも四角、楕円、線を引いたりなどのメソッドが含まれています。
            * 矩形を描画します。
            * Number型は小数点を含む数を扱います。
            * Flashでは、数値を扱うことができる変数の型は,int(整数),uint(正の整数),Number(小数点含む数)
            * circleSp.drawRect(x:Number, y:Number, width:Number, height:Number);
            */
       
            //描画の終わりを宣言します
            circleSp.graphics.endFill();
            
            //円の位置をstageの幅と高さの半分に指定します
            circleSp.x = stage.stageWidth/2;
            circleSp.y = stage.stageHeight/2;

            addChild(circleSp);
        }
        
        //円を描き動かす関数です
        public function DrawAndMove():void{
            var circleSp:Sprite = new Sprite();
            
            //Math.random()は0.0 ～ 1.0 の疑似乱数を返します。
            //0xFFFFFFをかけることで、ランダムな色を生成することができます。
            var color:uint = Math.random()*0xFFFFFF;
            
            circleSp.graphics.beginFill(color);
            circleSp.graphics.drawCircle(0,0,50);
            circleSp.graphics.endFill();
            circleSp.x = stage.stageWidth/2;
            circleSp.y = stage.stageHeight/2;
            addChild(circleSp);
            
            //配列に格納します。
            lists[0] = circleSp;
            //swfで指定したフレームレート(1フレーム)毎に呼び出されます。今回だと６０fpsなので1秒に60回呼び出されます。
            addEventListener(Event.ENTER_FRAME, enterFrameHandler1);
        }
        //毎フレームの処理 event:　には登録したイベントのクラスを指定します。今回だとEvent.なのでEventを指定します。
        public function enterFrameHandler1(event:Event):void{
            //配列から取り出します。
            var sp:Sprite = lists[0];
            
            //sp.xに+1したものをsp.xに格納します。
            //sp.x = sp.x +1;
            sp.x +=1;
            
            //ステージを飛び出したらx座標を反対側に設定にしてあげます。
            if(sp.x > stage.stageWidth) sp.x = 0;
            else if(sp.x < 0) sp.x = stage.stageWidth;
        }
        
        //円をランダムに描きます。
        public function DrawCircleRandom():void{
            for(var i:int = 0; i<100;i++){
                var circleSp:Sprite = new Sprite();
                var color:uint = Math.random()*0xFFFFFF;
                
                //第二引数を指定することでalpha:透明度を設定できます。
                circleSp.graphics.beginFill(color,Math.random());
                
                //半径1~50の円を生成します。
                circleSp.graphics.drawCircle(0,0,Math.random()*50);
                circleSp.graphics.endFill();
                circleSp.x = stage.stageWidth*Math.random();
                circleSp.y = stage.stageHeight*Math.random();
                addChild(circleSp);
                lists[i] = circleSp;
            }
  
        }
        
    }
    /*
    最後にお気に入りwonderfl
    http://wonderfl.net/code/448a0195da618461603cb61f9172fc6aff8420cf
    http://wonderfl.net/code/1a4af00b498fd32cea63a20b77210bc293aa65bc#
    http://wonderfl.net/code/03190641c00b157abc0dbe7d6a513fa80ec987db
    */
}