/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8oi4
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            stage.addEventListener( MouseEvent.MOUSE_DOWN, startPoly);
        }
        
        private const MIN_AREA:Number = 20;
        private var poly:PolyPoint;

        private function startPoly( e:Event ):void {
            graphics.clear();
            graphics.lineStyle( 2, 0xFF00 );

            stage.addEventListener( MouseEvent.MOUSE_UP, endPoly );
            stage.addEventListener( MouseEvent.MOUSE_MOVE, addPoint );
            poly = new PolyPoint( mouseX, mouseY );
            graphics.moveTo( mouseX, mouseY );
        }
        
        private function addPoint( e:Event ):void {
            var point:PolyPoint = new PolyPoint( mouseX, mouseY );
            
            poly = poly.addAsNext( point );
            graphics.lineTo( mouseX, mouseY );
        }
        
        private function endPoly( e:Event ):void {
            stage.removeEventListener( MouseEvent.MOUSE_UP, endPoly );
            stage.removeEventListener( MouseEvent.MOUSE_MOVE, addPoint );
            //stage.removeEventListener( MouseEvent.MOUSE_DOWN, startPoly );
            addPoint(e);
            
            graphics.lineStyle( 2, 0x00FF00 );
            poly.draw( graphics );
            
            poly = poly.smallestTriangle();
            while( poly.triangleArea < MIN_AREA && poly.count > 3 ) {
                poly.remove()
                poly = poly.next.smallestTriangle();
            }

            graphics.lineStyle( 1, 0xFF0000, 0.5 );
            graphics.beginFill( 0xFF, 0.5 );
            poly.draw( graphics );
            graphics.endFill();
        }
    }
}

import flash.display.Graphics;

class PolyPoint {
    public var x:Number;
    public var y:Number;
    public var next:PolyPoint;
    public var prev:PolyPoint;
    
    public function PolyPoint( x:Number, y:Number ) {
        this.x = x;
        this.y = y;
        next = prev = this;
    }
    
    public function addAsNext( p:PolyPoint ):PolyPoint {
        next.prev = p;
        p.next = next;
        next = p;
        p.prev = this;
        return p;
    }
    
    public function remove():void {
        next.prev = prev;
        prev.next = next;
    }
    
    public function get count():uint {
        var point:PolyPoint = next;
        var cnt:uint = 1;
        
        while( point != this ) {
            point = point.next;
            cnt++;
        }
        return cnt;
    }

    // returns the area of the triangle form by prev, this and next.
    // triangle area = ( x1*(y2-y3) + x2*(y3-y1) + x3*(y1-y2) ) / 2
    public function get triangleArea():Number {
        return Math.abs( (
            prev.x*(y-next.y) + 
            x*(next.y-prev.y) + 
            next.x*(prev.y-y)
        ) / 2 );
    }
    
    public function smallestTriangle():PolyPoint {
        var smallest:PolyPoint = this;
        var current:PolyPoint = this;
        
        while( current.next != this ) {
            current = current.next;
            if( current.triangleArea < smallest.triangleArea ) {
                smallest = current;
            }
        }
        
        return smallest;
    }
    
    public function draw( g:Graphics ):void {
        g.moveTo( x, y );
        var point:PolyPoint = this;
        
        do {
            point = point.next;
            g.lineTo( point.x, point.y );
            //g.drawCircle( point.x, point.y, 3 );
            //g.lineTo( point.x, point.y );
        } while( point != this );
    }
}
