/**
 * Copyright aaharu ( http://wonderfl.net/user/aaharu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8oKN
 */

package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    
    [SWF(width=500, height=500)]
    public class Step2 extends Sprite {
        private var list:Vector.<Sprite> = new Vector.<Sprite>();
        private var circle:Sprite = new Sprite();
        private var pp:PerspectiveProjection = root.transform.perspectiveProjection;
        
        public function Step2() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            circle.x = 250;
            circle.y = 250;
            addChild(circle);
            
            for(var i:uint = 0; i < 15; i++) {
                var sp:Sprite = new Sprite();
                sp.graphics.beginFill(0xFFFFFF * Math.random());
                sp.graphics.drawRect(-10, -10, 20, 20);
                sp.graphics.endFill();
                sp.x = Math.cos((2 * Math.PI / 15) * i) * 200;
                sp.z = Math.sin((2 * Math.PI / 15) * i) * 200;
                sp.rotationY = 90 - 24 * i;
                list.push(sp);
                circle.addChild(sp);
            }
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            pp.projectionCenter = new Point(250, 500 - mouseY);
            
            circle.rotationY++;
            list.sort(zSort);
            for(var i:uint = 0; i < 15; i++) {
                circle.removeChild(list[i]);
                circle.addChild(list[i]);
            }
        }
        
        private function zSort(a:Sprite, b:Sprite):Number {
            var mat1:Matrix3D = a.transform.getRelativeMatrix3D(stage);
            var mat2:Matrix3D = b.transform.getRelativeMatrix3D(stage);
            return mat2.position.z - mat1.position.z;
        }
    }
}