/**
 * Copyright Jacky.Riawan ( http://wonderfl.net/user/Jacky.Riawan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8oH4
 */

package 

{

    import flash.display.Bitmap;

    import flash.display.BitmapData;

    import flash.display.BitmapDataChannel;

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.events.MouseEvent;

    import flash.filters.BlurFilter;

    import flash.filters.DisplacementMapFilter;

    import flash.filters.DisplacementMapFilterMode;

    import flash.geom.Point;

    import flash.text.TextField;

    

    /**

     * ...

     * @author Jacky Riawan

     */

    public class Main extends Sprite 

    {

        private const blur:BlurFilter = new BlurFilter(5, 5);

        private var displacement:DisplacementMapFilter;

        public const bulletDisplay:BitmapData = new BitmapData(2, 2, false, 0xCCCC00);

        public const soldierDisplay:BitmapData = new BitmapData(4, 4, false, 0xFFFF00);

        public const soldierDeadDisplay:BitmapData = new BitmapData(4, 4, false, 0xC0C0C0);

        public const medicDisplay:BitmapData = new BitmapData(4, 4, false, 0x00FF00);

        public const turretDisplay:BitmapData = new BitmapData(10, 10, false, 0xFF0000);

        public const turret_bulletDisplay:BitmapData = new BitmapData(3, 3, false, 0xFF7171);

        //

        public var screen:BitmapData

        public var displacementBitmap:BitmapData;

        private var background:BitmapData;

        public const objects:Vector.<mapObjects> = new Vector.<mapObjects>();

        //

        public const grunts:Vector.<grunt> = new Vector.<grunt>();

        public const grunts_ready:Vector.<grunt> = new Vector.<grunt>();

        public const turrets:Vector.<turret> = new Vector.<turret>();

        public const turrets_ready:Vector.<turret> = new Vector.<turret>();

        public const turret_bullets:Vector.<turret_bullet> = new Vector.<turret_bullet>();

        public const turret_bullets_ready:Vector.<turret_bullet> = new Vector.<turret_bullet>();

        public const grunt_bullets:Vector.<grunt_bullet> = new Vector.<grunt_bullet>();

        public const grunt_bullets_ready:Vector.<grunt_bullet> = new Vector.<grunt_bullet>();

        private var spawnTimer:int = 0;

        private const textfield:TextField = new TextField();

        public function Main():void 

        {

            if (stage) init();

            else addEventListener(Event.ADDED_TO_STAGE, init);

        }

        

        private function init(e:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, init);

            // entry point

            screen = new BitmapData(stage.stageWidth, stage.stageHeight, false);

            background = new BitmapData(stage.stageWidth, stage.stageHeight, false);

            background.perlinNoise(256, 256, 10, 0, true, false);

            background.lock();

            displacementBitmap = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);

            //displacementBitmap.perlinNoise(512, 512, 10, 1, false, false,BitmapDataChannel.BLUE);

            displacement = new DisplacementMapFilter(displacementBitmap,new Point(),BitmapDataChannel.RED,BitmapDataChannel.RED,500,500,DisplacementMapFilterMode.WRAP);

            addChild(new Bitmap(screen));

            addChild(textfield);

            textfield.wordWrap = true;

            textfield.textColor = 0xFFFFFF;

            textfield.mouseEnabled = false;

            addEventListener(Event.ENTER_FRAME, update);

            stage.addEventListener(MouseEvent.CLICK, addTurretHandler);

        }

        

        private function addTurretHandler(e:MouseEvent):void 

        {

            addTurrets(new Point(mouseX, mouseY));

        }

        

        private function update(e:Event):void 

        {

            if(turrets.length>0){

                //if (spawnTimer == 0) {

                    spawnSoldiers();

                    //spawnTimer = Math.random()*3;

                //}else {

                //    spawnTimer--;

                //}

            }

            screen.lock();

            displacementBitmap.lock();

            screen.copyPixels(background, screen.rect, new Point());

            displacementBitmap.applyFilter(displacementBitmap, displacementBitmap.rect, new Point(), blur);

            screen.applyFilter(screen, screen.rect, new Point(), displacement);

            for (var i:int = 0; i < objects.length; i++) {

                var obj:mapObjects = objects[i];

                if (obj.onStage) {

                    objects[i].update();

                    objects[i].draw();

                }else{

                    objects.splice(i, 1);

                    i--;

                    if (obj is turret_bullet) {

                        turret_bullets_ready.push(obj);

                    }else if (obj is grunt_bullet) {

                        grunt_bullets_ready.push(obj);

                    }else if (obj is grunt) {

                        grunts_ready.push(obj);

                    }else if (obj is turret) {

                        turrets_ready.push(obj);

                    }

                }

            }
            screen.unlock();

            displacementBitmap.unlock();

            for (i = 0; i < turret_bullets.length; i++) {

                if (!turret_bullets[i].onStage) {

                    turret_bullets.splice(i, 1);

                }

            }

            for (i = 0; i < grunt_bullets.length; i++) {

                if (!grunt_bullets[i].onStage) {

                    grunt_bullets.splice(i, 1);

                }

            }

            textfield.text = "Turrets:"+turrets.length+"\nGrunts: " + grunts.length+"\nBullets: "+(turret_bullets.length+grunt_bullets.length)+"\nObjects: "+objects.length+"\nObject in pool: "+(turret_bullets_ready.length+turrets_ready.length+grunt_bullets_ready.length+grunts_ready.length);

        }

        private function addTurrets(pos:Point):void {

            var obj:turret;

            if (turrets_ready.length > 0) {

                obj = turrets_ready.pop();

                obj.reinit(pos);

            }else {

                obj = new turret(pos, this);

            }

            objects.push(obj);

            turrets.push(obj);

        }

        public function addGruntBullet(pos:Point,angle:Number):void {

            var obj:grunt_bullet;

            if (grunt_bullets_ready.length > 0) {

                obj = grunt_bullets_ready.pop();

                obj.resetBullet(pos,angle);

            }else {

                obj = new grunt_bullet(pos,angle, this);

            }

            objects.push(obj);

            grunt_bullets.push(obj);

        }

        public function addTurretBullet(pos:Point,angle:Number):void {

            var obj:turret_bullet;

            if (turret_bullets_ready.length > 0) {

                obj = turret_bullets_ready.pop();

                obj.resetBullet(pos,angle);

            }else {

                obj = new turret_bullet(pos,angle, this);

            }

            objects.push(obj);

            turret_bullets.push(obj);

        }

        private function spawnSoldiers():void 

        {

            var obj:grunt;

            if (grunts_ready.length > 0) {

                obj = grunts_ready.pop();

                obj.updateClass(Math.random()<.24);

            }else{

                obj = new grunt(Math.random()<.24,this);

            }

            objects.push(obj);

            grunts.push(obj);

        }

    }
}
import flash.display.BitmapData;

    import flash.geom.Point;

    import flash.geom.Rectangle;
class mapObjects 

    {

        public var loc:Point;

        public var assets:BitmapData;

        protected var main:Main;

        public var onStage:Boolean = true;

        public var health:Number = 100;

        private var drawLoc:Point = new Point();

        private var drawRect:Rectangle = new Rectangle();

        public function mapObjects(assets:BitmapData,loc:Point,main:Main) 

        {

            this.assets = assets;

            this.loc = loc;

            this.main = main;

            drawRect.width = assets.width;

            drawRect.height = assets.height;

        }

        protected function reset():void {

            onStage = true;

        }

        public function update():void {

            

        }

        public function draw():void {

            drawLoc.x = loc.x - assets.width / 2;

            drawLoc.y = loc.y - assets.height / 2;

            main.screen.copyPixels(assets, assets.rect, drawLoc);

            drawRect.x = drawLoc.x;

            drawRect.y = drawLoc.y;

            main.displacementBitmap.fillRect(drawRect,0xFFFFFF);

        }

    }
     import flash.display.BitmapData;

    import flash.geom.Point;
    class grunt extends mapObjects

    {

        public var isMedic:Boolean;

        private var target:mapObjects;

        private const viewRange:int = 40+Math.random()*50;

        public var knockedTime:int = 100;

        private var fireRate:int = 0;

        public function grunt(isMedic:Boolean,main:Main) 

        {

            this.isMedic = isMedic;

            var assets:BitmapData

            if (isMedic) {

                assets = main.medicDisplay;

            }else{

                assets = main.soldierDisplay;

            }

            super(assets, new Point(), main);

            loc.x = main.stage.stageWidth * Math.random();

            loc.y = main.stage.stageHeight * Math.random();

            var ran:Number = Math.random();

            if (ran<.25) {

                loc.x = 0;

            }else if (ran < .5) {

                loc.x = main.stage.stageWidth;

            }else if (ran < .75) {

                loc.y = 0;

            }else {

                loc.y = main.stage.stageHeight;

            }

        }

        private function updateTarget():void {

            if (target == null) {

                var i:int;

                var dist:int;

                var closest:int = int.MAX_VALUE;

                if (isMedic) {

                    if(main.turret_bullets.length>0){

                        for (i = 0; i < main.grunts.length; i++) {

                            var _grunt:grunt = main.grunts[i];

                            if (_grunt.onStage) {

                                if (!_grunt.isMedic) {

                                    if (_grunt.health <= 0) {

                                        dist = Math.sqrt(Math.pow(_grunt.loc.x - loc.x, 2) + Math.pow(_grunt.loc.y - loc.y, 2));

                                        if (dist <= closest) {

                                            target = _grunt;

                                            if (dist <= viewRange) {

                                                break;

                                            }else{

                                                closest = dist;

                                            }

                                        }

                                    }

                                }

                            }

                        }

                    }

                }else {

                    for (i = 0; i < main.turrets.length; i++) {

                        dist = Math.sqrt(Math.pow(main.turrets[i].loc.x - loc.x, 2) + Math.pow(main.turrets[i].loc.y - loc.y, 2));

                        if (dist <= closest) {

                            target = main.turrets[i];

                            if (dist < viewRange) {

                                break;

                            }else{

                                closest = dist;

                            }

                        }

                    }

                }

            }

        }

        public function updateClass(isMedic:Boolean ):void {

            this.isMedic = isMedic;

            if (isMedic) {

                assets = main.medicDisplay;

            }else {

                assets = main.soldierDisplay;

            }

            loc.x = main.stage.stageWidth * Math.random();

            loc.y = main.stage.stageHeight * Math.random();

            var ran:Number = Math.random();

            if (ran<.25) {

                loc.x = 0;

            }else if (ran < .5) {

                loc.x = main.stage.stageWidth;

            }else if (ran < .75) {

                loc.y = 0;

            }else {

                loc.y = main.stage.stageHeight;

            }

            knockedTime = 100;

            health = 100;

            target = null;

            reset();

        }

        override public function update():void 

        {

            if(health>0){

                if (target) {

                    var dx:Number = target.loc.x - loc.x;

                    var dy:Number = target.loc.y - loc.y;

                    var dist:Number = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));

                    var angle:Number = Math.atan2(dy, dx);

                    var speed:Number = Math.min(dist, 2);

                    if(isMedic){

                        loc.x += Math.cos(angle) * speed;

                        loc.y += Math.sin(angle) * speed;

                        if (dist <= 2) {

                            var _grunt:grunt = target as grunt;

                            _grunt.assets = main.soldierDisplay;

                            _grunt.health = 100;

                            _grunt.knockedTime = 100;

                            target = null;

                        }else {

                            if (target.health > 0) {

                                target = null;

                            }

                        }

                    }else {

                        if (dist <= viewRange) {

                            if (fireRate == 0) {

                                if (target.health <= 0) {

                                    target.onStage = false;

                                    target = null;

                                }else{

                                    main.addGruntBullet(loc.clone(), angle);

                                }

                                fireRate = 30;

                            }else {

                                fireRate--;

                            }

                        }else {

                            loc.x += Math.cos(angle) * speed;

                            loc.y += Math.sin(angle) * speed;

                        }

                    }

                }else {

                    updateTarget();

                }

            }else {

                if (knockedTime == 0||isMedic) {

                    onStage = false;

                }else {

                    knockedTime--;

                }

            }

            super.update();

        }

    }
    import flash.geom.Point;
    class turret extends mapObjects

    {

        private var fireRate:int = 0;

        private const range:int = 150;

        private var target:grunt;

        public function turret(pos:Point,main:Main) 

        {

            super(main.turretDisplay, pos, main);

            health = 200;

        }

        public function reinit(pos:Point):void {

            health = 200;

            loc = pos;

            reset();

        }

        private function findTarget():void {

            if (target == null) {

                for (var i:int = int(Math.random()*main.grunts.length); i < main.grunts.length; i++) {

                    if (main.grunts[i].onStage) {

                        if(main.grunts[i].health>0){

                            var dx:Number = main.grunts[i].loc.x - loc.x;

                            var dy:Number = main.grunts[i].loc.y - loc.y;

                            var dist:Number = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));

                            if (dist < range) {

                                target = main.grunts[i];

                                break;

                            }

                        }

                    }else {

                        main.grunts.splice(i, 1);

                    }

                }

            }

        }

        override public function update():void 

        {

            if (fireRate == 0) {

                if (target) {

                    if (target.health <= 0) {

                        target = null;

                    }else {

                        var dx:Number = target.loc.x - loc.x;

                        var dy:Number = target.loc.y - loc.y;

                        var dist:Number = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));

                        if(dist<=range){

                            main.addTurretBullet(loc.clone(), Math.atan2(dy, dx));

                        }else {

                            target = null;

                        }

                    }

                }else {

                    findTarget();

                }

                fireRate = 4;

            }else {

                fireRate--;

            }

            super.update();

        }

    }
    import flash.geom.Point;
    class turret_bullet extends mapObjects

    {

        private var speed:Point=new Point();

        private var range:int = 10;

        private var life:int = 25;

        public function turret_bullet(loc:Point,angle:Number,main:Main) 

        {

            super(main.turret_bulletDisplay, loc, main);

            speed.x = Math.cos(angle) * 6;

            speed.y = Math.sin(angle) * 6;

        }

        public function resetBullet(newLoc:Point,angle:Number):void 

        {

            life = 25;

            loc = newLoc;

            speed.x = Math.cos(angle) * 6;

            speed.y = Math.sin(angle) * 6;

            reset();

        }

        override public function update():void 

        {

            loc.x += speed.x;

            loc.y += speed.y;

            life--;

            if (loc.x < 0 || loc.x > main.stage.stageWidth || loc.y < 0 || loc.y > main.stage.stageHeight||life<=0) {

                onStage = false;

            }else {

                for (var i:int = 0; i < main.grunts.length; i++) {

                    if (main.grunts[i].onStage) {

                        if(main.grunts[i].health>0){

                            var dx:Number = main.grunts[i].loc.x - loc.x;

                            var dy:Number = main.grunts[i].loc.y - loc.y;

                            var dist:Number = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));

                            if (dist <= range) {

                                main.grunts[i].health = 0;

                                main.grunts[i].assets = main.soldierDeadDisplay;

                                //onStage = false;

                                break;

                            }

                        }

                    }else {

                        main.grunts.splice(i, 1);

                    }

                }

            }

            super.update();

        }

    }
    import flash.geom.Point;
    class grunt_bullet extends mapObjects

    {

        private var speed:Point=new Point();

        private var range:int = 3;

        private var life:int = 20;

        public function grunt_bullet(loc:Point,angle:Number,main:Main) 

        {

            super(main.bulletDisplay, loc, main);

            speed.x = Math.cos(angle) * 6;

            speed.y = Math.sin(angle) * 6;

        }

        public function resetBullet(newLoc:Point,angle:Number):void 

        {

            life = 20;

            loc = newLoc;

            speed.x = Math.cos(angle) * 6;

            speed.y = Math.sin(angle) * 6;

            reset();

        }

        override public function update():void 

        {

            loc.x += speed.x;

            loc.y += speed.y;

            life--;

            if (loc.x < 0 || loc.x > main.stage.stageWidth || loc.y < 0 || loc.y > main.stage.stageHeight||life<=0) {

                onStage = false;

            }else {

                for (var i:int = 0; i < main.turrets.length; i++) {

                    if (main.turrets[i].onStage) {

                        if(main.turrets[i].health>0){

                            var dx:Number = main.turrets[i].loc.x - loc.x;

                            var dy:Number = main.turrets[i].loc.y - loc.y;

                            var dist:Number = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));

                            if (dist < range) {

                                main.turrets[i].health--;

                                onStage = false;

                                break;

                            }

                        }

                    }else {

                        main.turrets.splice(i, 1);

                    }

                }

            }

            super.update();

        }

        

    }