/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8o0k
 */

package {
    import flash.geom.Point;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            stage.align = "TL";
            stage.scaleMode = "noScale";
            
            var p0:Point3D = new Point3D(0, 0, 0);
            var p1:Point3D = new Point3D(100, 0, 0);
            var p2:Point3D = new Point3D(100, 0, 100);
            var p3:Point3D = new Point3D(0, 0, 100);
            
            var sp0:Point = IsoUtils.isoToScreen(p0);
            var sp1:Point = IsoUtils.isoToScreen(p1);
            var sp2:Point = IsoUtils.isoToScreen(p2);
            var sp3:Point = IsoUtils.isoToScreen(p3);
            
            var tile:Sprite = new Sprite();
            tile.x = 200;
            tile.y = 200;
            addChild(tile);
            
            tile.graphics.lineStyle(0);
            tile.graphics.moveTo(sp0.x, sp0.y);
            tile.graphics.lineTo(sp1.x, sp1.y);
            tile.graphics.lineTo(sp2.x, sp2.y);
            tile.graphics.lineTo(sp3.x, sp3.y);
            tile.graphics.lineTo(sp0.x, sp0.y);
        }
    }
}
import flash.geom.Point;

class Point3D
{
    public var x:Number;
    public var y:Number;
    public var z:Number;
    
    public function Point3D(x:Number, y:Number, z:Number):void
    {
        this.x = x;
        this.y = y;
        this.z = z;
    }

}

class IsoUtils
{
    public static const Y_CORRECT:Number = Math.cos(-Math.PI / 6) * Math.SQRT2;//1.2247.....
    
    public static function isoToScreen(pos:Point3D):Point
    {
        var screenX:Number = pos.x - pos.z;
        var screenY:Number = pos.y * Y_CORRECT + (pos.x + pos.z) * 0.5;
        return new Point(screenX, screenY);
    }
    
    public static function screenToIso(point:Point):Point3D
    {
        var xpos:Number = point.y + point.x * 0.5;
        var ypos:Number = 0;
        var zpos:Number = point.y - point.x * 0.5;
        return new Point3D(xpos, ypos, zpos);
    }


}
