/**
 * Copyright michouse ( http://wonderfl.net/user/michouse )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8nF3
 */

package {

    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;

    // PaperVision3D
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.shaders.*;
    import org.papervision3d.materials.shaders.CellShader;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.parsers.*;
    import org.papervision3d.view.*;
    import org.papervision3d.events.*;
    import org.papervision3d.render.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.core.math.Quaternion;
    import org.papervision3d.core.math.Matrix3D;

    // BeTween
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.IObjectTween;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.tweens.ITweenGroup;
    
    [SWF(backgroundColor = "0x000000", width = "465", height = "465")]

    public class Main extends BasicView {

        private var cube:DAE;

        private var light:PointLight3D = new PointLight3D();

        public function Main() {

            super(0, 0, true, true);

            cube = new DAE();
            cube.addEventListener(FileLoadEvent.LOAD_COMPLETE, onLoadCompleteHandler);
            cube.load("http://www.piece-web.jp/FLASH/pumpkin/pumpkin.dae");

        }

        private function onLoadCompleteHandler(e:FileLoadEvent):void {

            trace("Load Complete");

            scene.addChild(cube);

            cube.x = 0;
            cube.y = 0;
            cube.z = 0;
            cube.rotationX = 0;

            camera.x = 0;
            camera.y = 150;
            camera.z = -750;
            
            var cameraTarget:DisplayObject3D = new DisplayObject3D();
            cameraTarget.y = 150;
            camera.target = cameraTarget;

            startRendering();

            addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);

        }

        private function onMouseDownHandler(e:MouseEvent):void {
            addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        }

        private function onMouseUpHandler(e:MouseEvent):void {
            removeEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        }

        private function onEnterFrameHandler(e:Event):void {
            
            var pos1:Quaternion = Quaternion.createFromMatrix(cube.transform);
            var pos2:Quaternion = Quaternion.createFromEuler(-1,0,0,true);

            pos2.normalize();
            pos2.mult(pos1);
            pos2.normalize();
            cube.copyTransform(org.papervision3d.core.math.Matrix3D.quaternion2matrix(pos2.x, pos2.y, pos2.z, pos2.w));
        }

    }

}