/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8mxs
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.utils.Timer;
    
    [SWF(frameRate=30)]
    
    public class Ectoplasm extends Sprite
    {
        // consts for adjustment
        private const SPR_MLT:Number   = 1 / 16;
        private const FRICTION:Number  = 1 / 8;
        private const THICKNESS:Number = 40;
        private const V/*hsv*/:Number  = 1 / 6;
        private const COL_MLT:Number   = 1 + 1 / 16;
        private const BLUR:Number      = 8;
        
        
        private var timer:Timer  = new Timer(1 / 60);
        private var counter:uint = 0;
        
        private var vx:Number = 0;
        private var vy:Number = 0;
        private var rx:Number = stage.stageWidth / 2;
        private var ry:Number = stage.stageHeight / 2;
        
        private var vec:Shape            = new Shape();
        private var cmds:Vector.<int>    = new <int>[1, 3];
        private var data:Vector.<Number> = new Vector.<Number>(6, true);
        
        private var bmd:BitmapData    = new BitmapData(stage.stageWidth, stage.stageHeight, false);
        private var buf:BitmapData    = bmd.clone();
        private var ct:ColorTransform = new ColorTransform(COL_MLT, COL_MLT, COL_MLT);
        private var pt:Point          = new Point();
        private var bf:BlurFilter     = new BlurFilter(BLUR, BLUR);
        
        
        public function Ectoplasm()
        {
            addChild(new Bitmap(bmd));
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
        }
        
        
        private function onTimer(e:TimerEvent):void
        {
            data[0] = rx;
            data[1] = ry;
            data[2] = vx;
            data[3] = vy;
            
            vx += (stage.mouseX - rx) * SPR_MLT - vx * FRICTION;
            vy += (stage.mouseY - ry) * SPR_MLT - vy * FRICTION;
            rx += vx;
            ry += vy;
            
            data[2] = data[0] + (data[2] + vx) / 4;
            data[3] = data[1] + (data[3] + vy) / 4;
            data[4] = rx;
            data[5] = ry;
            
            vec.graphics.clear();
            vec.graphics.lineStyle(THICKNESS, hue2rgb(counter));
            vec.graphics.drawPath(cmds, data);
            
            buf.draw(vec);
            
            counter++;
        }
        
        
        private function onEnterFrame(e:Event):void
        {
            bmd.copyPixels(buf, buf.rect, pt);
            buf.applyFilter(bmd, bmd.rect, pt, bf);
            buf.colorTransform(buf.rect, ct);
        }
        
        
        private function hue2rgb(h:Number):uint
        {
            var rgb:uint = 0x000000;
            
            h = h >= 360 ? h % 360 : (h < 0 ? h % 360 + 360 : h);
            
            var i:int    = int(h / 60);
            var f:Number = h / 60 - i;
            var m:Number = V * (1 - f);
            var n:Number = V * f;
            
            switch (i) {
                case 0: rgb = V * 0xFF << 16 | n * 0xFF << 8 |             0; break;
                case 1: rgb = m * 0xFF << 16 | V * 0xFF << 8 |             0; break;
                case 2: rgb =              0 | V * 0xFF << 8 | n * 0xFF << 0; break;
                case 3: rgb =              0 | m * 0xFF << 8 | V * 0xFF << 0; break;
                case 4: rgb = n * 0xFF << 16 |             0 | V * 0xFF << 0; break;
                case 5: rgb = V * 0xFF << 16 |             0 | m * 0xFF << 0; break;
            }
            
            return rgb;
        }
    }
}
