/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8mP4
 */

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	/**
	 * ...
	 * @author sliz http://game-develop.net/blog/
	 */
	public class TestTree extends Sprite
	{
		private var tasks:Array = [];
		public function TestTree() 
		{
			var c:int = 50;
			while(c-->0){
				var node:Node = new Node();
				tasks.push(node);
			}
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void 
		{
			for (var i:int = 0; i < 50; i++ ) {
				var node:Node = tasks[i];
				if (node!=null) {
					tasks.splice(i, 1);
					create(node);
				}else {
					break;
				}
			}
		}
		private function create(node:Node):void {
			var a:Number;
			var s:Number;
			var x:Number;
			var y:Number;
			if (node.parent) {
				a = node.parent.date.a + (0.5 - Math.random()) * 2;
				s = node.parent.date.s * 0.7;
				x = node.parent.date.x + node.parent.date.s * Math.cos(node.parent.date.a);
				y = node.parent.date.y + node.parent.date.s * Math.sin(node.parent.date.a);
				graphics.lineStyle(s / 5);
				graphics.moveTo(node.parent.date.x, node.parent.date.y);
				graphics.lineTo(x, y);
			}else {
				a = -Math.PI / 2;
				s = 50 * Math.random();
				x = 456 * Math.random();
				y = 456 * Math.random();
			}
			node.date.a = a;
			node.date.s = s;
			node.date.x = x;
			node.date.y = y;
			if (s > 5) {
				var num:int = s / 7;
				while(num-->0){
					var child:Node = new Node();
					child.parent = node;
					tasks.push(child);
				}
			}
		}
	}

}
class Node
	{
		public var parent:Node;
		public var childs:Array = [];
		public var date:Object = { };
		public function Node() 
		{
			
		}
		
	}