/**
 * Copyright JM-DG ( http://wonderfl.net/user/JM-DG )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/8m1V
 */

// --------------------
// Flashy Background
// Created By: JM-DG
// Date Creation: 08/11/2011
// Date Modified: 09/11/2011
// --------------------

package {
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.StageDisplayState;
    import flash.events.Event;
    import net.hires.debug.Stats; // For perfomance statistics *optional*
    import com.demonsters.debugger.MonsterDebugger;  // For debugging *optional*
    
    public class FlashyBackground extends Sprite {
        private var tex : Shape = new Shape();    
        private var backgroundColorChanger: Bling;
        
        public function FlashyBackground() {
            this.addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
        }
            
        private function onAddedToStage(event : Event) : void {
            this.removeEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
            stage.addEventListener(Event.RESIZE, doResize, false, 0, true);
            MonsterDebugger.initialize(this); // For debugging *optional*
            
            //------------------------------
            // Flashy Background
            //------------------------------
            backgroundColorChanger = new Bling(stage.stageWidth, stage.stageHeight, 0xFFFFFF * Math.random(),  0xFFFFFF * Math.random());
            backgroundColorChanger.alpha = .3; 
            this.addChild(backgroundColorChanger);
            
            //----------------------------------------------
            // Put your classes between the texture & the flash background
            //----------------------------------------------
            new Round(this, 50, 50);
            new Round(this, 100, 100);
            new Round(this, 150, 150);
            new Round(this, 200, 200);
            new Round(this, 250, 250);
            new Round(this, 300, 300);  
            new Round(this, 350, 350);  
            new Round(this, 400, 400);  
            new Round(this, 450, 450);  
            new Round(this, 500, 500);  
             
            this.addChild(new Stats()); // For perfomance statistics *optional*
            //----------------------------------------------
                
            //------------------------------
            // Top texture
            //------------------------------
            this.graphics.beginFill(0x222222);
            this.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
                    
            tex.graphics.beginBitmapFill(makeTexture());
            tex.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            tex.graphics.endFill();
            tex.alpha= 0.5;
            this.addChild(tex);
        }
        
        private function makeTexture() : BitmapData{
            var bmd : BitmapData = new BitmapData(2, 2, true, 0x0);
            bmd.setPixel32(0, 0, 0x33000000);
            return bmd;
        }
        
        private function doResize(e:Event):void{           
            this.graphics.beginFill(0x222222);
            this.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
            
            tex.graphics.clear();
            tex.graphics.beginBitmapFill(makeTexture());
            tex.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            tex.graphics.endFill();

            backgroundColorChanger.height = stage.stageHeight;
            backgroundColorChanger.width = stage.stageWidth
        }
        
    }
}





    import flash.display.Sprite;
    import flash.events.Event;
//-----------------------------------------------------------------------------------------------------------
    class Bling extends Sprite {
//-----------------------------------------------------------------------------------------------------------
        private var ag:AnimatingGradient;
//-----------------------------------------------------------------------------------------------------------
        public function Bling($width:int, $height:int, $color1:int, $color2:int)
        {
            this.ag = new AnimatingGradient($width, $height, $color1, $color2);    
            this.addChild(this.ag);
            this.ag.tweenGradient(Math.random()*0xffffff, Math.random()*0xffffff, 300);
            this.ag.addEventListener("finish", tweenAgain)            
        }
//-----------------------------------------------------------------------------------------------------------        
        private function tweenAgain(event:Event):void    {
            this.ag.tweenGradient(Math.random()*0xffffff, Math.random()*0xffffff, 300);
        }
//-----------------------------------------------------------------------------------------------------------END
    }





    import flash.display.BlendMode;
    import flash.display.Sprite; 
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.events.Event;
//-----------------------------------------------------------------------------------------------------------
    class Round extends Sprite {
        private static const TWO_PI : Number = Math.PI * 2.0;
        private var _angle : Number = random(TWO_PI);
        private var _speed : Number = random(0.2, 1.5);
        private var _maxStep : Number = random(Math.PI * 0.15);
        
        public function Round(refStage:FlashyBackground, refX:uint, refY:uint){
            this.graphics.beginFill(0XA4CDFF);
            this.graphics.drawCircle(refX, refY, 14);
            this.graphics.endFill();
            this.blendMode = BlendMode.ADD;
            this.blurOn();
            refStage.addChild(this);
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function blurOn():void{
            var blur:BlurFilter = new BlurFilter();
            blur.blurX = 3;
            blur.blurY = 3;
            blur.quality = BitmapFilterQuality.MEDIUM;
            this.filters = [blur];
        }
        
        private function random(min : Number, max : Number = NaN) : Number{
            if(isNaN(max)){
                max = min;
                min = 0;
            }
            return min + (Math.random() * (max - min));
        }

        private function onEnterFrame(event : Event) : void {
            wander();
        }
        
        private function wander() : void{
            _angle += random(-_maxStep, _maxStep);
            this.x += Math.cos(_angle) * _speed;
            this.y += Math.sin(_angle) * _speed;
                
           var w : int = stage.stageWidth;
           var h : int = stage.stageHeight;
                
           this.x = this.x < 0 ? w : this.x > w ? 0 : this.x;
           this.y = this.y < 0 ? h : this.y > h ? 0 : this.y;
        }
    }






//-----------------------------------------------------------------------------------------------------------
    import flash.geom.*
    import flash.display.*
    import flash.events.*;
//-----------------------------------------------------------------------------------------------------------    
    class AnimatingGradient extends Sprite    {
//-----------------------------------------------------------------------------------------------------------             
        public var sColor:uint;
        public var eColor:uint;
        
        private var sTwnSteps:Array;
        private var eTwnSteps:Array;
        
        private var gWidth:uint;
        private var gHeight:uint;
        private var alphas:Array;
        private var ratios:Array;
        private var matr:Matrix;
        private var spreadMethod:String;
        private var fillType:String;
        
        private var twnFrames:uint;
        private var currentFrame:uint;
//-----------------------------------------------------------------------------------------------------------        
        public function AnimatingGradient(width:uint, height:uint, startColor:uint, endColor:uint)    {
            this.sColor = startColor;
            this.eColor = endColor;
            
            var colors:Array = [startColor, endColor];
        
            this.gWidth=width;
            this.gHeight=height;
            this.fillType = GradientType.LINEAR;
            this.alphas = [100, 100];
            this.ratios = [0x00, 0xFF];
            this.matr = new Matrix();
            matr.createGradientBox(width, height, (90 * Math.PI/180), 0, 0);
            this.spreadMethod = SpreadMethod.PAD;
            this.updateGradient(startColor, endColor);        
        }
//-----------------------------------------------------------------------------------------------------------        
        public function stop():void    {
            this.removeEventListener(Event.ENTER_FRAME, doTween);
            this.dispatchEvent(new Event("stopped"));
        }
//-----------------------------------------------------------------------------------------------------------        
        public function tweenGradient(startColor:int, endColor:int, steps:int):void    {
            this.currentFrame=0
            this.stop();
            
            this.sTwnSteps = this.getDifferenceAsSteps(this.HEXtoRGB(this.sColor), this.HEXtoRGB(startColor), steps);
            this.eTwnSteps = this.getDifferenceAsSteps(this.HEXtoRGB(this.eColor), this.HEXtoRGB(endColor), steps);
            this.sColor = startColor;
            this.eColor = endColor;
            this.addEventListener(Event.ENTER_FRAME, doTween);
        }
//-----------------------------------------------------------------------------------------------------------        
        private function doTween(event:Event):void    {
            this.dispatchEvent(new Event("changed"));
            this.updateGradient(this.RGBtoHEX(sTwnSteps[this.currentFrame].r,sTwnSteps[this.currentFrame].g,sTwnSteps[this.currentFrame].b), this.RGBtoHEX(eTwnSteps[this.currentFrame].r,eTwnSteps[this.currentFrame].g,eTwnSteps[this.currentFrame].b));
            if(this.currentFrame==this.twnFrames-1) {
                delete this.removeEventListener(Event.ENTER_FRAME, doTween);
                this.dispatchEvent(new Event("finish"));
            }
            else this.currentFrame++;
        }
//-----------------------------------------------------------------------------------------------------------        
        private function updateGradient(s:int,e:int):void    {
            this.graphics.clear();
            this.graphics.beginGradientFill(this.fillType, [s, e], this.alphas, this.ratios, this.matr, this.spreadMethod);  
            this.graphics.drawRect(0,0,this.gWidth,this.gHeight);
            this.graphics.endFill();
        }
//-----------------------------------------------------------------------------------------------------------        
        private function HEXtoRGB(hex:uint):Object{
                return {r:hex >> 16, g:(hex >> 8) & 0xff, b:hex & 0xff};
        }
//-----------------------------------------------------------------------------------------------------------        
        private function RGBtoHEX(red:uint, green:uint, blue:uint):uint    {
            var s:String = new String('0x');
            var r:String = red.toString(16);
            s += (r.length<2)?('0'+r):r;
            var g:String = green.toString(16);
            s += (g.length<2)?('0'+g):g;
            var b:String = blue.toString(16);
            s += (b.length<2)?('0'+b):b;
            return Number(s);
        }
//-----------------------------------------------------------------------------------------------------------        
        private function getDifferenceAsSteps(a:Object, z:Object, stepCount:uint):Array {
            stepCount--;
            
            var r:Number = ((z.r - a.r) / stepCount);
            var g:Number = ((z.g - a.g) / stepCount);
            var b:Number = ((z.b - a.b) / stepCount);  

            var rgbVector:Array = new Array(); 
            var i:int=0;
            var obj:Object = new Object();
            while(i < stepCount){
                obj = (i > 0) ? rgbVector[i-1] : a;
                rgbVector.push({r:obj.r+r, g:obj.g+g, b:obj.b+b});
                i++;
            }
            rgbVector.unshift(a);
            this.twnFrames = rgbVector.length;
            return rgbVector;
            
        }
    }