/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ly7
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
    
    public class FlashTest extends Sprite {
        private var _world:BasicView;
        private var _rot:Number = 0;
        
        public function FlashTest() {
            init();
        }
        
        private function init():void {
            _world = new BasicView(465, 465);
            addChild(_world);
            
            for( var i:uint = 0; i < 100; i++) {
                var plane:Plane = new Plane(null, 100, 100);
                plane.x = int(Math.random() * 2000) - 1000;
                plane.y = int(Math.random() * 2000) - 1000;
                plane.z = int(Math.random() * 2000) - 1000;
                plane.rotationX = int(Math.random() * 360);
                plane.rotationY = int(Math.random() * 360);
                plane.rotationZ = int(Math.random() * 360);
                
                _world.scene.addChild(plane);
            }
            
            _world.camera.x = 0;
            _world.camera.y = 0;
            _world.camera.z = -1000;
            _world.startRendering();
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            _rot += 1;
            _world.camera.x = 1000 * Math.cos(_rot * Math.PI/180);
            _world.camera.z = 1000 * Math.sin(_rot * Math.PI/180);
        }
    }
}