/**
 * Copyright kawamura ( http://wonderfl.net/user/kawamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8lOs
 */

////////////////////////////////////////////////////////////////////////////////
// Optical Illusion (3)
////////////////////////////////////////////////////////////////////////////////

package {
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import frocessing.color.ColorHSV;
    
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]
    
    public class TestProject extends Sprite {
        private static var max:uint = 16;
        private var container:Sprite;
        private var circles:Array;
        private static var center:uint = 125;
        private static var radius:uint = 95;
        private static var speed:Number = 3.2/4;
        private static var radian:Number = Math.PI/180;
        private var bitmapData:BitmapData;
        private var canvas:Bitmap;
        private var matrix:Matrix;
        private var blur:BlurFilter;
        private var count:Number = 0;
        
        public function TestProject() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }
        
        private function init():void {
            
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            bitmapData = new BitmapData(465, 465, true, 0x00000000);
            canvas = new Bitmap(bitmapData);
            addChild(canvas);
            //
            matrix = new Matrix();
            matrix.translate(232, 232);
            blur = new BlurFilter(4, 4, 8);
            //
            container = new Sprite();
            addChild(container);
            container.x = 232;
            container.y = 232;
            //
            circles = [];
            var color:ColorHSV = new ColorHSV();
            
            for (var n:uint = 0; n < max; n ++) {
                var angle:Number = (360/max)*n;
                color.h = angle;
                var circle:Circle = new Circle(color.value);
                circle.angle = angle * 3;
                var r:Number = center + radius * Math.sin(circle.angle*radian*3);
                circle.x =  r * Math.cos(circle.angle*radian);
                circle.y =  r * Math.sin(circle.angle*radian);
                container.addChild(circle);
                circles.push(circle);
            }
            //
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            count += 1 * speed * Math.PI / 180;
            if(count > 2* Math.PI)
            {
                count -= 2*Math.PI;
            }
            for (var n:uint = 0; n < max; n ++) {
                var circle:Circle = circles[n];
                circle.angle += speed;
                var r:Number = center + radius*Math.sin(count + circle.angle*radian*3);
                circle.x =  r * Math.cos(circle.angle*radian);
                circle.y =  r * Math.sin(circle.angle*radian);
            }
            //
            bitmapData.lock();
            bitmapData.draw(container, matrix);
            bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(), blur);
            bitmapData.unlock();
        }
    }
    
}


//////////////////////////////////////////////////
// Circle
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;

class Circle extends Sprite {
    public var id:uint;
    private var color:uint;
    private var _angle:Number = 0;
    private static var radius:uint = 6;
    
    public function Circle(c:uint) {
        color = c;
        init();
    }
    
    private function init():void {
        var circle:Shape = new Shape();
        circle.graphics.beginFill(color);
        circle.graphics.drawCircle(0, 0, radius);
        circle.graphics.endFill();
        addChild(circle);
    }
    public function get angle():Number {
        return _angle;
    }
    public function set angle(value:Number):void {
        _angle = (value + 360)%360;
    }
}