/**
 * Copyright umhrhrs ( http://wonderfl.net/user/umhrhrs )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8l9I
 */

package
{
	import com.bit101.components.Style;
	import com.bit101.components.TextArea;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.globalization.DateTimeFormatter;
	import flash.globalization.LocaleID;
	
	/**
	 * ...
	 * @author umhr
	 */
	public class Main extends Sprite
	{
		private var _text:String = "";
		
		public function Main()
		{
			if (stage)
				init();
			else
				addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			
			var text:String = "";
			var date:Date = new Date();
			
			setText("var date:Date = new Date();", "");
			setText("date", date);
			
			// http://help.adobe.com/ja_JP/FlashPlatform/reference/actionscript/3/flash/globalization/DateTimeFormatter.html
			setText("====DateTimeFormatter====", "");
			// SQLに渡すときに便利
			// http://help.adobe.com/ja_JP/as3/dev/WSd47bd22bdd97276f1365b8c112629d7c47c-8000.html
			var df:DateTimeFormatter = new DateTimeFormatter(LocaleID.DEFAULT);
			df.setDateTimePattern("yyyy/MM/dd HH:mm");
			setText("yyyy/MM/dd HH:mm", df.format(date));
			
			df.setDateTimePattern("yyyy-MM-dd'T'HH:mm:ss");
			setText("yyyy-MM-dd'T'HH:mm:ss", df.format(date));
			
			setText("====Properties====", "");
			setText("date.date", date.date);
			setText("date.dateUTC", date.dateUTC);
			setText("date.day", date.day);
			setText("date.dayUTC", date.dayUTC);
			setText("date.fullYear", date.fullYear);
			setText("date.fullYearUTC", date.fullYearUTC);
			setText("date.hours", date.hours);
			setText("date.hoursUTC", date.hoursUTC);
			setText("date.milliseconds", date.milliseconds);
			setText("date.millisecondsUTC", date.millisecondsUTC);
			setText("date.minutes", date.minutes);
			setText("date.minutesUTC", date.minutesUTC);
			setText("date.month", date.month);
			setText("date.monthUTC", date.monthUTC);
			setText("date.seconds", date.seconds);
			setText("date.secondsUTC", date.secondsUTC);
			setText("date.time", date.time);
			setText("date.timezoneOffset", date.timezoneOffset);
			
			setText("====Methods====", "");
			setText("date.getDate()", date.getDate());
			setText("date.getDay()", date.getDay());
			setText("date.getFullYear()", date.getFullYear());
			setText("date.getHours()", date.getHours());
			setText("date.getMilliseconds()", date.getMilliseconds());
			setText("date.getMinutes()", date.getMinutes());
			setText("date.getMonth()", date.getMonth());
			setText("date.getSeconds()", date.getSeconds());
			setText("date.getTime()", date.getTime());
			setText("date.getTimezoneOffset()", date.getTimezoneOffset());
			setText("date.getUTCDate()", date.getUTCDate());
			setText("date.getUTCDay()", date.getUTCDay());
			setText("date.getUTCFullYear()", date.getUTCFullYear());
			setText("date.getUTCHours()", date.getUTCHours());
			setText("date.getUTCMilliseconds()", date.getUTCMilliseconds());
			setText("date.getUTCMinutes()", date.getUTCMinutes());
			setText("date.getUTCMonth()", date.getUTCMonth());
			setText("date.getUTCSeconds()", date.getUTCSeconds());
			setText("date.toDateString()", date.toDateString());
			setText("date.toLocaleDateString()", date.toLocaleDateString());
			setText("date.toLocaleString()", date.toLocaleString());
			setText("date.toLocaleTimeString()", date.toLocaleTimeString());
			setText("date.toString()", date.toString());
			setText("date.toTimeString()", date.toTimeString());
			setText("date.toUTCString()", date.toUTCString());
			setText("date.valueOf()", date.valueOf());
			
			
			Style.embedFonts = false;
			Style.fontName = "_等幅";
			Style.fontSize = 12; //13ポイントが読みやすい
			//
			new TextArea(this, 0, 0, _text).setSize(stage.stageWidth, stage.stageHeight);
		}
		
		private function setText(name:String, value:*):void
		{
			var spacer:String = "";
			var n:int = 5 - Math.floor(name.length / 8);
			for (var i:int = 0; i < n; i++)
			{
				spacer += "\t"
			}
			_text += name + spacer + value + "\n";
		}
	
	}

}