/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8kxR
 */

// forked from majoraze's 
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class Bubbles extends Sprite {
        private var balls:Array;
        private var numBalls:Number = 15;
        private var bounce:Number = -0.5;
        private var spring:Number = .04;
        private var gravity:Number = .5;
        
        public function Bubbles() {
            init();
        }
        
        private function init():void {
            balls = [];
            
            for (var i:int = 0; i < numBalls; i++) {
                var ball:Ball = new Ball(Math.random()*40+5, Math.random() * 0xffffff + 0xff000000);
                ball.x = Math.random() * stage.width;
                ball.y = Math.random() * stage.height;
                ball.vx = Math.random() * 6 - 3;
                ball.vy = Math.random() * 6 - 3;
                addChild(ball);
                balls.push(ball);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);

        }
        
        private function onEnterFrame(e:Event):void {
            for (var i:int = 0; i < numBalls - 1; i++) {
                var ballCheck:Ball = balls[i] as Ball; //the ball who will collide
                for (var j:int = i + 1; j < numBalls; j++) {
                    var ballCollide:Ball = balls[j];
                    var dx:Number = ballCheck.x - ballCollide.x;
                    var dy:Number = ballCheck.y - ballCollide.y;
                    var dist:Number = Math.sqrt(dx * dx + dy * dy);
                    var minDist:Number = ballCheck.radius + ballCollide.radius;
                    if (dist < minDist) {
                        var angle:Number = Math.atan2(dy,dx);
                        var tx:Number = ballCheck.x + Math.cos(angle) * minDist;
                        var ty:Number = ballCheck.y + Math.sin(angle) * minDist;
                        var ax:Number = (tx - ballCollide.x) * spring;
                        var ay:Number = (ty - ballCollide.y) * spring;
                        ballCheck.vx -= ax;
                        ballCheck.vy -= ay;
                        ballCollide.vx += ax;
                        ballCollide.vy += ay;
                    }
                }
            }
            
            for (i = 0; i < numBalls; i++) {
                var ball:Ball = balls[i];
                move(ball);
            }


        }
        
        private function move(ball:Ball):void {
            ball.x += ball.vx;
            ball.y += ball.vy;
            if (ball.x + ball.radius > stage.stageWidth) {
                ball.x = stage.stageWidth - ball.radius;
                ball.vx *= bounce;
            } else if (ball.x - ball.radius < 0) {
                ball.x = ball.radius;
                ball.vx *= bounce;
            }

            if (ball.y + ball.radius > stage.stageHeight) {
                ball.y = stage.stageHeight - ball.radius;
                ball.vy *= bounce;
            } else if (ball.y - ball.radius < 0) {
                ball.y = ball.radius;
                ball.vy *= bounce;
            }



        }



    }
}




//ball class
import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    private var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;   
    public var isDragging:Boolean = false; 
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}