/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8kY1
 */

// forked from nn2's forked from: Bubbles (2)
// forked from ProjectNya's Bubbles (2)
////////////////////////////////////////////////////////////////////////////////
// Bubbles (2)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.geom.Matrix;
    import flash.display.GradientType;
    import flash.system.Security;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var bubbles:Array;
        private static var max:uint = 600;
        private static var radian:Number = Math.PI/180;
        private static var basePath:String = "http://www.project-nya.jp/images/flash/aquarium/";
        private static var bubblesPath:String = "bubbles.mp3";
        private var se:SoundEffect;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            Security.allowDomain("www.project-nya.jp");
            Security.loadPolicyFile("http://www.project-nya.jp/crossdomain.xml");
            se = new SoundEffect();
            se.addEventListener(Event.COMPLETE, loaded, false, 0, true);
            se.load(basePath + bubblesPath);
            //
            draw();
            create();
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function loaded(evt:Event):void {
            se.play(0.2, true);
        }
        private function create():void {
            bubbles = new Array();
            for (var n:uint = 0; n < max; n++) {
                var bubble:Bubble = new Bubble();
                addChild(bubble);
                bubble.x = Math.random()*465;
                bubble.y = Math.random()*465 + 465;
                bubble.scale = Math.random()*0.8 + 0.2;
                bubble.alpha = Math.random()*0.5 + 0.5;
                bubble.yspeed = Math.random()*0.5;
                bubble.acceleration = Math.random()*0.1;
                bubble.angle = Math.random()*360;
                bubble.acceleangle = Math.random()*0.1;
                bubble.degree = Math.random()*4 + 1;
                bubbles.push(bubble);
            }
        }
        private function update(evt:Event):void {
            for (var n:uint = 0; n < max; n++) {
                var bubble:Bubble = bubbles[n];
                bubble.yspeed += bubble.acceleration;
                bubble.angle += bubble.acceleangle;
                bubble.x += Math.sin(bubble.angle*radian)*bubble.degree + bubble.xspeed;
                bubble.y -= bubble.yspeed;
                if (bubble.y + bubble.height < 0) {
                    bubble.x = Math.random()*465;
                    bubble.y =Math.random()*465 + 465;
                    bubble.yspeed = Math.random()*0.5;
                }
            }
        }
        private function draw():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 465, 0.5*Math.PI, 0, 0);
            graphics.beginGradientFill(GradientType.LINEAR, [0x00AAE4, 0x0069A0], [1, 1], [0, 255], matrix);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            var label:Label = new Label(200, 40, 40, Label.CENTER);
            addChild(label);
            label.x = 132;
            label.y = 132;
            label.textColor = 0xFFFFFF;
            label.text = "泡のテストです_あき爺";
            label.alpha = 0.4;
        }
        
    }

}


//////////////////////////////////////////////////
// Bubbleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.BlendMode;

class Bubble extends Sprite {
    private static var radius:uint = 10;
    private var _scale:Number = 1;
    public var xspeed:Number = 0;
    public var yspeed:Number = 0;
    public var acceleration:Number = 0;
    public var angle:Number = 0;
    public var acceleangle:Number = 0;
    public var degree:Number = 0;

    public function Bubble() {
        draw();
    }

    private function draw():void {
        var circle:Shape = new Shape();
        addChild(circle);
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius*2, radius*2, 0.5*Math.PI, -radius*1.5, -radius*0.5);
        circle.graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0xCCCCCC], [1, 0.3], [0, 255], matrix);
        circle.graphics.drawCircle(0, 0, radius);
        circle.graphics.endFill();
        circle.blendMode = BlendMode.LIGHTEN;
        //
        var light:Shape = new Shape();
        addChild(light);
        var _matrix:Matrix = new Matrix();
        _matrix.createGradientBox(radius*0.8, radius*0.8, 0.5*Math.PI, -radius*0.4, -radius*0.6);
        light.graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0x0069A0], [1, 0.5], [0, 255], _matrix);
        light.graphics.drawEllipse(-radius*0.4, -radius*0.3, radius*0.8, radius*0.6);
        light.graphics.endFill();
        light.x = radius*0.45;
        light.y = -radius*0.45;
        light.rotation = 45;
        light.blendMode = BlendMode.LIGHTEN;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}


//////////////////////////////////////////////////
// SoundEffectクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.net.URLRequest;

class SoundEffect extends EventDispatcher {
    public var id:String;
    private var sound:Sound;
    private var channel:SoundChannel;
    private var level:Number;
    private var volume:Number = 1;
    private var looping:Boolean = false;
    public var initialized:Boolean = false;
    public var playing:Boolean = false;

    public function SoundEffect() {
    }

    public function init(Snd:Class):void {
        sound = new Snd();
    }
    public function load(filePath:String):void {
        sound = new Sound();
        sound.load(new URLRequest(filePath));
        sound.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        sound.addEventListener(Event.COMPLETE, initialize, false, 0, true);
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function initialize(evt:Event):void {
        initialized = true;
        channel = sound.play();
        channel.stop();
        dispatchEvent(evt);
    }
    public function play(lv:Number, loop:Boolean = false):void {
        playing = true;
        channel.stop();
        level = lv;
        looping = loop;
        channel = sound.play();
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume;
        channel.soundTransform = transform;
        if (looping) {
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
        }
    }
    public function stop():void {
        playing = false;
        channel.stop();
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
    }
    public function setVolume(v:Number):void {
        volume = v;
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume;
        channel.soundTransform = transform;
    }
    private function complete(evt:Event):void {
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        if (looping) {
            channel = sound.play(0);
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume;
            channel.soundTransform = transform;
        } else {
            playing = false;
        }
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
