/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8j7x
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var _frame:uint = 0;
        private var _isInc:Boolean = true;
        
        public function FlashTest() {
            this.addEventListener(Event.ENTER_FRAME, proc);
        }

        private function proc(e:Event):void {
            if (_isInc) {
                ++_frame;
                if (_frame == 127) {
                    _isInc = false;
                }
            }
            else {
                --_frame;
                if (_frame == 0) {
                    _isInc = true;
                }
            }

            this.graphics.clear();
            var width:uint = 38;
            var height:uint = 38;
            for (var y:uint = 0; y < height; ++y) {
                for (var x:uint = 0; x < width; ++x) {
                    var r:uint = 255 - (x * 4);
                    var g:uint = 255 - (y * 4);
                    var b:uint = (x * 2) + (y * 2);
                    var scale:Number = (_frame / 127.0) + ((width - x) / (width * 4)) + ((height - y) / (height * 4));
                    if (scale > 1.0) scale = 1.0;
                    var size:Number = scale * 10;
                    this.graphics.beginFill(color(r, g, b));
                    this.graphics.drawRect(4 + (x * 12), 4 + (y * 12), size, size);
                    this.graphics.endFill();
                }                
            }            
        }

        
        private function color(r:uint, g:uint, b:uint):uint {
            return (r << 16) + (g << 8) + (b << 0);
        }
    }
}