/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ipT
 */

// forked from zonnbe's pixels 3d video (Not PV3D)
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.display.LoaderInfo;
    import flash.events.MouseEvent;
    import flash.events.NetStatusEvent;
    import flash.display.MovieClip;
    import flash.system.LoaderContext;
    import flash.geom.Matrix;
    import flash.system.Security;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.media.Video;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0x333333")]
    public class dot3d extends Sprite
    {
        private static const LOCAL_VIDEO:String = "http://commondatastorage.googleapis.com/bradsedito/video/fringe_intro_seq.mp4";
        private var player:Object;
        private var loader:Loader;
        private var bmpd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);
        private var bmp:Bitmap = new Bitmap(bmpd);
        private var focalLength:Number = 500;
        private var vertices:Vector.<Dot> = new Vector.<Dot>();
        private var matrix:matx = new matx([1,0,0, 0,1,0, 0,0,1]);
        private var cp:Dot = new Dot(stage.stageWidth/2, stage.stageHeight/2+50);
        private var ct:ColorTransform =  new ColorTransform(1,1,1,0.9);
        private var exrad:Number = 0;
        private var ppr:int = 40; // pixels per round
        private var distance:int = 10;
        private var videobmpd:BitmapData;
        private var w:int = 0;
        private var h:int = 0;
        private var drag:Boolean = false;
        private var start_m:Dot = new Dot();
        private var old_mouse:Dot = new Dot();
        private var new_mouse:Dot = new Dot();
        private var mat:Matrix = new Matrix();
        private var ns:NetStream;
        private var nc:NetConnection;
        private var video:Video;
        private var vmatrix:Matrix;
        
        public function dot3d()
        {
            addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x333333)));
            addChild(bmp);
            bmpd.fillRect(bmpd.rect, 0x0);
            
            nc = new NetConnection();
            nc.connect(null);
            
            ns = new NetStream(nc);
            ns.addEventListener(NetStatusEvent.NET_STATUS, videoNetStatusHandler);
            ns.client = {
                onMetaData:function(param:Object):void{}
            };
            ns.checkPolicyFile = false;
            ns.play(LOCAL_VIDEO);
            
            video = new Video();
            video.attachNetStream(ns);
        }
        
        private function videoNetStatusHandler(e:NetStatusEvent):void 
        {
            init();
        }
        
        private function init(e:Event = null):void
        {
            var i:int = 0;
            var j:int = 0;
            
            vmatrix = new Matrix();
         //   vmatrix.scale( 200 / video.width, 200 / video.height);
            
            videobmpd = new BitmapData(200, 200, false);
            w = videobmpd.width;
            h = videobmpd.height;

            for(i = 0; i < distance; i++)
            {
                for(j = 0; j < ppr; j++)
                {
                    vertices.push( new Dot() );
                }
            }
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onmouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onmouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onmouseMove);
            stage.addEventListener(Event.ENTER_FRAME, processing);
        }
        
        private function onmouseDown(e:MouseEvent):void
        {
            drag = true;
            old_mouse.x = mouseX;
            old_mouse.y = mouseY;
        }
        
        private function onmouseUp(e:MouseEvent):void
        {
            drag = false;
        }
        
        private function onmouseMove(e:MouseEvent):void
        {
            new_mouse.x = mouseX;
            new_mouse.y = mouseY;
            
            if(drag)
            {
                var difference:Dot = new Dot(new_mouse.x - old_mouse.x, new_mouse.y - old_mouse.y);
                var vector:Dot = new Dot(difference.x, difference.y, 0);
 
                var rotationAxis:Dot = vector.cross_r(new Dot(0,0,1));
                rotationAxis.normalize();
                
                var distance:Number = Math.sqrt(difference.x * difference.x + difference.y * difference.y);
                var rotationMatrix:matx = new matx();
                matrix.rotate_around_arbitrary_axis_m(new Dot(rotationAxis.x, rotationAxis.y, rotationAxis.z), distance/150);
            }
            
            old_mouse.x = mouseX;
            old_mouse.y = mouseY;
        }
        
        private function processing(e:Event):void
        {
            update();
            paint();
        }
        
        private function update():void
        {
            var i:int = 0;
            var j:int = 0;
            var rad:Number = Math.PI*2/ppr+1;
            var radius:Number = 10;
            
            exrad += Math.PI/180 * 3;
            if(exrad > Math.PI*2) exrad = 0;
            
            for(i = 0; i < distance; i++)
            {
                radius = 10;
                for(j = 0; j < ppr-1; j++)
                {
                    radius = 10 + i * 5;
                    vertices[i * ppr + j].val_p_( Math.cos(rad * j + exrad) * radius, i * 10 + j, Math.sin(rad * j + exrad) * radius);
                }
            }
            videobmpd.draw(video, vmatrix);
        }
        
        private function paint():void
        {
            var i:int = 0;
            var j:int = 0;
            var p2x:Number = 0;
            var p2y:Number = 0;
            var fx:Number = 0;
            var fy:Number = 0;
            var vert:Dot = new Dot();
            var ratio:Number = 0;
            var divider:Number = 4;
            var margin:Number = 5;
            
            bmpd.lock();
            bmpd.colorTransform(bmpd.rect, ct);

            for(i = 0; i < vertices.length; i++)
            {
                vert.x = vertices[i].x;
                vert.y = vertices[i].y;
                vert.z = vertices[i].z;
                
                vert.mul_m_(matrix);
                
                ratio = focalLength/(focalLength + vert.z);
                p2x = vert.x * ratio + cp.x;
                p2y = vert.y * ratio + cp.y;
                
                if(p2x > 0 && p2x < stage.stageWidth && p2y > 0 && p2y < stage.stageHeight) bmpd.setPixel32(int(p2x), int(p2y), 0xffffffff);
            }
            for(i = 0; i < w/divider; i++)
            {
                for(j = 0; j < h/divider; j++)
                {
                    vert.x = (Math.cos((i * margin) * Math.PI/180 + exrad) * 20) + i * divider - w/2;//i * divider - w/2;
                    vert.y = (Math.sin((i * margin) * Math.PI/180 + exrad) * 20) + j * divider - h;
                    vert.z = Math.cos((i * margin) * Math.PI/180 + exrad) * 20;
                    
                    vert.mul_m_(matrix);
                    
                    ratio = focalLength/(focalLength + vert.z);
                    p2x = vert.x * ratio + cp.x;
                    p2y = vert.y * ratio + cp.y;
                    if(p2x > 0 && p2x < stage.stageWidth && p2y > 0 && p2y < stage.stageHeight) bmpd.setPixel32(int(p2x), int(p2y), videobmpd.getPixel32(i * divider, j * divider));
                }
            }
            bmpd.unlock();
        }
    }
}

class matx
{
    public var n11:Number = 1;
    public var n12:Number = 0;
    public var n13:Number = 0;
    
    public var n21:Number = 0;
    public var n22:Number = 1;
    public var n23:Number = 0;
    
    public var n31:Number = 0;
    public var n32:Number = 0;
    public var n33:Number = 1;
    
    public function matx(arr:Array = null):void
    {
        if(arr) { n11 = arr[0]; n12 = arr[1]; n13 = arr[2]; n21 = arr[3]; n22 = arr[4]; n23 = arr[5]; n31 = arr[6]; n32 = arr[7]; n33 = arr[8]; }
    }
    
    public function clone():matx { return new matx([n11, n12, n13, n21, n22, n23, n31, n32, n33]); }
    public function copy(m:matx):void { n11 = m.n11; n12 = m.n12; n13 = m.n13; n21 = m.n21; n22 = m.n22; n23 = m.n23; n31 = m.n31; n32 = m.n32; n33 = m.n33; }
    
    public function rotate_around_arbitrary_axis_m(arb_axis:*, speed:Number):void
    {
        var Cos:Number = Math.cos(speed);
        var Sin:Number = Math.sin(speed);
        var Tan:Number = 1 - Cos;
        
        var arb_axis_length:Number = arb_axis.len();
        
        var n1:Number = arb_axis.x/arb_axis_length;
        var n2:Number = arb_axis.y/arb_axis_length;
        var n3:Number = arb_axis.z/arb_axis_length;

        var m:matx = new matx();

        m.n11 = n1 * n1 * Tan + Cos;
        m.n12 = n1 * n2 * Tan - n3 * Sin;
        m.n13 = n1 * n3 * Tan + n2 * Sin
        
        m.n21 = n1 * n2 * Tan + n3 * Sin;
        m.n22 = n2 * n2 * Tan + Cos;
        m.n23 = n2 * n3 * Tan - n1 * Sin
        
        m.n31 = n1 * n3 * Tan - n2 * Sin
        m.n32 = n2 * n3 * Tan + n1 * Sin;
        m.n33 = n3 * n3 * Tan + Cos;
        
        mxm3d(m);
    }
    
    public function mxm3d(m1:*):void
    {
        var m2:matx = clone();
        this.n11 = m1.n11 * m2.n11 + m1.n12 * m2.n21 + m1.n13 * m2.n31;
        this.n12 = m1.n11 * m2.n12 + m1.n12 * m2.n22 + m1.n13 * m2.n32;
        this.n13 = m1.n11 * m2.n13 + m1.n12 * m2.n23 + m1.n13 * m2.n33;
        
        this.n21 = m1.n21 * m2.n11 + m1.n22 * m2.n21 + m1.n23 * m2.n31;
        this.n22 = m1.n21 * m2.n12 + m1.n22 * m2.n22 + m1.n23 * m2.n32;
        this.n23 = m1.n21 * m2.n13 + m1.n22 * m2.n23 + m1.n23 * m2.n33;
        
        this.n31 = m1.n31 * m2.n11 + m1.n32 * m2.n21 + m1.n33 * m2.n31;
        this.n32 = m1.n31 * m2.n12 + m1.n32 * m2.n22 + m1.n33 * m2.n32;
        this.n33 = m1.n31 * m2.n13 + m1.n32 * m2.n23 + m1.n33 * m2.n33;
    }
}

class Dot
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
    
    public function Dot(px:Number = 0, py:Number = 0, pz:Number = 0) { x = px; y = py; z = pz; }
    
    public function val_p_(px:Number = 0, py:Number = 0, pz:Number = 0):void { x = px; y = py; z = pz; }
    public function clone():Dot { return new Dot(x, y, z); }
    public function sub_v_(p:*):void { x -= p.x; y -= p.y; z -= p.z; }
    public function cross_r(p:*):Dot { return new Dot(y * p.z - z * p.y, z * p.x - x * p.z, x * p.y - y * p.x); }
    public function normalize():void { var l:Number = len(); x/=l; y/=l; z/=l; }
    public function len():Number { return Math.sqrt(x*x + y*y + z*z); }
    
    public function mul_m_(m:*):Dot {
        var c:Dot = clone();
        x = c.x * m.n11 + c.y * m.n12 + c.z * m.n13;
        y = c.x * m.n21 + c.y * m.n22 + c.z * m.n23;
        z = c.x * m.n31 + c.y * m.n32 + c.z * m.n33;
        return this;
    }
}