/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ip9
 */

package {
  import com.actionscriptbible.Example;
  import flash.events.Event;

  public class ch20ex1 extends Example {
    public function ch20ex1() {
      var t:Thermometer = new Thermometer();
      t.addEventListener(Thermometer.TEMP_CHANGED, onTempChanged);
      t.debugSimulateCrazyWeather();
    }
    
    protected function onTempChanged(event:Event):void {
      var t:Thermometer = Thermometer(event.target);
      trace("It's now " + t.temp.toFixed(1) + "°F");
    }
  }
}

import flash.events.*;
import flash.utils.setInterval;
class Thermometer extends EventDispatcher {
  protected var _temp:Number = 72;
  public static const TEMP_CHANGED:String = "tempChanged";

  public function set temp(newTemp:Number):void {
    _temp = newTemp;
    dispatchEvent(new Event(TEMP_CHANGED));
  }
  
  public function get temp():Number {
    return _temp;
  }
  
  internal function debugSimulateCrazyWeather():void {
    setInterval(function():void {temp += 3 * (Math.random() - 0.5);}, 1000);
  }
}