/**
 * Copyright pseudoDust ( http://wonderfl.net/user/pseudoDust )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ibg
 */

// forked from pseudoDust's forked from: Sound Visualizer
package {
    // forked from hycro's Sound Visualizer
    // pseudoDust: just added shake to the thing, 
    // the whole thing will move up and down slightly according to base levels
    // and a "motion" blur is applied
    //----------------------------------
    // Music by "SHW"(http://shw.in/) 
    //----------------------------------
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.filters.BitmapFilter;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.ByteArray;
    import flash.media.SoundLoaderContext;
    
    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]
    public class SoundTest extends Sprite {
        private static const POLICY_FILE:String = "http://hycro.crz.jp/crossdomain.xml";
        private static const SOUND_FILE:String = "http://hycro.crz.jp/wonderfl/sound/u-chi-u.mp3";
        
        private var _sound:Sound = new Sound();
        private var _channel:SoundChannel;
        
        
        { 
            Wonderfl.capture_delay( 33 );
        }
        

        public function SoundTest() {

            Security.loadPolicyFile(POLICY_FILE);
            

            _sound.addEventListener(Event.COMPLETE, onLoadComplete);
            _sound.addEventListener(IOErrorEvent.IO_ERROR, onLoadError);
            _sound.load(new URLRequest(SOUND_FILE), new SoundLoaderContext(10000, true));
        }
        

        private function onLoadComplete(evt:Event):void {
            this.addEventListener(Event.ENTER_FRAME, loop);
            _channel = _sound.play(0, int.MAX_VALUE);
        }
        
        

        private function loop(evt:Event):void {
            var data:ByteArray = new ByteArray();
            var matrix:Matrix;


            SoundMixer.computeSpectrum(data, true);
            

            var d:Number = Math.max(_channel.rightPeak, _channel.leftPeak) * .02;
        }
        

        private function onLoadError(evt:IOErrorEvent):void {
            trace("ロードに失敗しました");
        }
    }
}

