/**
 * Copyright 0xFFFFFF ( http://wonderfl.net/user/0xFFFFFF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8hen
 */

package {
    import flash.filters.ColorMatrixFilter;    
    import flash.filters.DisplacementMapFilter;    
    import flash.display.Sprite;    
    import flash.display.BitmapDataChannel;    
    import flash.events.Event;    
    import flash.display.Bitmap;    
    import flash.display.BitmapData;    
    import flash.display.MovieClip;
    import flash.geom.Point;
    
    public class Sunset extends Sprite {
        private const WIDTH:Number = 300;
        private const HEIGHT:Number = 300;
        
        private var redMap : BitmapData;
        private var blueMap : BitmapData;
        private var output : BitmapData;
        private var output1 : BitmapData;
        private var output2 : BitmapData;
        private var displaceMap : BitmapData;
        private var origin : Point = new Point(0,0);
        
        private var position1:Point = new Point(0, 0);
        private var position2:Point = new Point(0, 0);
        
        private var rect : Sprite;
        private var ct1 : ColorMatrixFilter;

        public function Sunset() {
            super();
            
            redMap = new BitmapData(WIDTH, HEIGHT);
            blueMap = new BitmapData(WIDTH, HEIGHT);
            displaceMap = new BitmapData(WIDTH, HEIGHT);
            
            output = new BitmapData(WIDTH, HEIGHT);
            output1 = new BitmapData(WIDTH, HEIGHT,false,0);
            output2 = new BitmapData(WIDTH, HEIGHT,false,0);
            
            addChild(new Bitmap(output));
            
            addEventListener(Event.ENTER_FRAME, loop);
            
            addChild(new Bitmap(output));
            
            rect = new Sprite();
            rect.graphics.lineStyle(3,0xFFaaaa);
            rect.graphics.moveTo(0,300);
            rect.graphics.lineTo(300,300);
                                
            ct1 =  new ColorMatrixFilter([
                                    1,        0,        0,        0,        0,
                                    0,        1,        0,        0,        0,
                                    .01,        0.01,        1,        0,        0,
                                    0,        0,        0,        1,        0]);
                            
        }
        
        private function loop(event : Event) : void {
            
            redMap.perlinNoise(1000, 1000, 5, 3, true, true, BitmapDataChannel.RED , false, [position1,position2,position1,position2]);
            
            position1.offset(1, 1);
            position2.offset(-1, .5);
            
            displaceMap.copyChannel(redMap, redMap.rect, origin, BitmapDataChannel.RED, BitmapDataChannel.RED);
            
            output1.draw(rect);
            output1.applyFilter(output1, output1.rect, origin, ct1);
            
            var displace : DisplacementMapFilter = new DisplacementMapFilter(displaceMap,origin,BitmapDataChannel.RED, BitmapDataChannel.BLUE,5,2);
            output1.applyFilter(output1, output1.rect, origin, displace);
            
            output.copyPixels(output1, output1.rect, origin);
        }

    }
}