/**
 * Copyright szbzs2004 ( http://wonderfl.net/user/szbzs2004 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8h0f
 */

// http://www.swf.hu/forum/topic/kulso-script-de-hogyan
package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    public class FlashTest extends Sprite {

        private var mice:Mice;
        private var cat:Cat;

        public function FlashTest() {
            mice = new Mice();
            mice.x = stage.stageWidth / 3;
            mice.y = stage.stageHeight / 2;
            addChild(mice);
            mice.startDrag(true);
            cat = new Cat();
            cat.x = 2 * stage.stageWidth / 3;
            cat.y = stage.stageHeight / 2;
            addChild(cat);
            cat.addEventListener(Event.ENTER_FRAME, catMove);
        }
 
        private function catMove(e:Event):void {
            const SPEED:Number = 10;
            var c:Cat = e.currentTarget as Cat;
            var distanceX:Number = c.x - mice.x;
            var distanceY:Number = c.y - mice.y;
            c.x -= distanceX / SPEED;
            c.y -= distanceY / SPEED;
        }
    }
}

import flash.display.Sprite;
import flash.display.Graphics;

class Mice extends Sprite {
 
       public function Mice(size:Number = 30) {
            var g:Graphics = this.graphics;
            // head
            g.beginFill(0xa0a0a0);
            g.drawTriangles(Vector.<Number>([-size / 2, -size / 2, size / 2, -size / 2, 0, size / 2]));
            // ears
            g.drawCircle(-size /3, -size / 2, size / 3);    // left ear
            g.drawCircle( size /3, -size / 2, size / 3);    // right ear
            g.endFill();
            // eyes
            g.beginFill(0);
            g.drawCircle(-size / 6, -size / 9, size / 15);    // left eye
            g.drawCircle( size / 6, -size / 9, size / 15);    // right eye
            g.endFill();
        }
}

class Cat extends Sprite {
 
        public function Cat(size:Number = 50) {
            var g:Graphics = this.graphics;
            // head
            g.beginFill(0xcc6600);
            g.drawEllipse(-size / 2, -size / 3, size, 2 * size / 3);
            // ears
            var ears:Vector.<Number> = new Vector.<Number>();
            ears.push(-size / 2, 0, 0, 0, -size / 4, -size / 2);    // left ear
            ears.push(0, 0, size / 2, 0, size / 4, - size / 2);    // right ear
            g.drawTriangles(ears);
            g.endFill();
            // eyes
            g.beginFill(0x003300);
            g.drawCircle(-size / 5, - size / 10, size / 20);    // left eye
            g.drawCircle(size / 5, - size / 10, size / 20);        // right eye
            g.endFill();
            // mouth
            g.lineStyle(1, 0);
            g.moveTo(-size / 6, size / 9);
            g.lineTo(0, size / 16);
            g.lineTo(size / 6, size / 9);
        }
}
