/**
 * Copyright omochieater ( http://wonderfl.net/user/omochieater )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8gUy
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.getTimer;
    
    /**
     * 変数宣言をしてからのループと変数宣言を含むループの処理速度比較
     * ※計測処理の構造は、muta244氏を参考にさせていただきました。
     */
    public class Main extends Sprite {
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            setup();
            exec();
        }
        
        private function exec():void {
            var NUM_TIMES:uint = 1000000;
            var NUM_TIMES2:uint = 1000;
            var object:Object = function():Object {
                var o:Object = {};
                for (var i:uint = 0; i < NUM_TIMES; ++i) {
                    o[i] = i;
                }
                return o;
            }();

            debug(
                //"各テスト" + NUM_TIMES + "回処理させた結果 [単位：ミリ秒]\n" +
                "各テストを処理させた結果 [単位：ミリ秒]\n" +
                "（誤差は多少生じます）\n"
            );
            measure("変数宣言をしてからのループ ループ回数=" + NUM_TIMES, function():void {
                var i:uint;
                for (i = 0; i < NUM_TIMES; ++i) {
                }
            });
            measure("変数宣言を含むループ ループ回数=" + NUM_TIMES, function():void {
                for (var i:uint = 0; i < NUM_TIMES; ++i) {
                }
            });
            measure("変数宣言をしてからの二重ループ ループ回数=" + NUM_TIMES2 + " * " + NUM_TIMES2, function():void {
                var i:uint, j:uint;
                for (i = 0; i < NUM_TIMES2; ++i) {
                    for (j = 0; j < NUM_TIMES2; ++j) {
                    }
                }
            });
            measure("変数宣言を含む二重ループ ループ回数=" + NUM_TIMES2 + " * " + NUM_TIMES2, function():void {
                for (var i:uint = 0; i < NUM_TIMES2; ++i) {
                    for (var j:uint = 0; j < NUM_TIMES2; ++j) {
                    }
                }
            });
            measure("変数宣言をしてからのループ for each ... in ループ回数=" + NUM_TIMES, function():void {
                var i:uint;
                for each (i in object) {
                }
            });
            measure("変数宣言を含むループ for each ... in ループ回数=" + NUM_TIMES, function():void {
                for each (var i:uint in object) {
                }
            });
        }
        
        private function measure(title:String, func:Function, ...params):void {
            mTime = getTimer();
            func.apply(this, params);
            mTime = getTimer() - mTime;
            debug("[" + title + "] --> " + mTime + "ms");
        }
        
        private function debug(log:String):void {
            mTextField.appendText(log + "\n");
        }
        
        private function setup():void {
            mTextField = new TextField();
            mTextField.width = stage.stageWidth - 40;
            mTextField.height = stage.stageHeight - 60;
            mTextField.x = 20;
            mTextField.y = 60;
            mTextField.multiline = true;
            mTextField.wordWrap = true;
            
            var textFormat:TextFormat = mTextField.defaultTextFormat;
            textFormat.font = "_sans";
            mTextField.defaultTextFormat = textFormat;
            
            addChild(mTextField);
            
            var button:TextField = new TextField();
            button.x = 20;
            button.y = 20;
            button.htmlText = "<p align='center'><fontface='_sans'>再計算</fontface></p>";
            button.background = true;
            button.backgroundColor = 0xEEEEEE;
            button.border = true;
            button.borderColor = 0xBBBBBB;
            button.width = 100;
            button.height  = 20;
            button.selectable = false;
            
            addChild(button);
            
            button.addEventListener(MouseEvent.CLICK, function():void {
                mTextField.text = "";
                exec();
            });
        }

        private var mTime:uint;
        private var mTextField:TextField;
        
    }
}
