/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8gEs
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.geom.Matrix;
    
    [SWF(width="465",height="465",frameRate="30",backgroundColor="0xCCCCFF")]
    public class Main extends Sprite {
        private static const RADIUS:int = 100;
        
        public function Main() {
            var screen:BitmapData = new BitmapData(465, 465, true, 0x00FFFFFF);
            addChild(new Bitmap(screen));
            
            var source:BitmapData = new BitmapData(2 * RADIUS, 2 * RADIUS, true, 0x00FFFFFF);
            var image:Sprite = new Sprite();
            image.graphics.beginFill(0x000000, 0.3);
            image.graphics.drawCircle(RADIUS, RADIUS, RADIUS);
            image.graphics.endFill();
            source.draw(image);
            
            var matrix:Matrix = new Matrix();
            matrix.translate( -RADIUS, -RADIUS);
            matrix.rotate(-Math.PI / 4);
            matrix.translate(232.5, 232.5);
            
            var blendMode:String = BlendMode.ADD;
            
            screen.draw(source, matrix, null, blendMode);
            matrix.translate(-20, -20);
            screen.draw(source, matrix, null, blendMode);
            matrix.translate(40, 40);
            screen.draw(source, matrix, null, blendMode);
        }
    }
}