/**
 * Copyright mmlemon_ ( http://wonderfl.net/user/mmlemon_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8g77
 */

package {
    import flash.display.Sprite;
    import flash.display.DisplayObject;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    
    
    [SWF(backgroundColor=0x0,frameRate=60)]
    public class FlashTest extends Sprite {
    		
    		private var m_len:int = 0;
        public function FlashTest() {
            // write as3 code here..
            addEventListener(Event.ADDED_TO_STAGE, init, false, 0, false);
            addEventListener(Event.REMOVED_FROM_STAGE, removeFromHandler, false, 0, false);
        }
        /**
         * initializing
         */
        private function init(event:Event):void
        {
        		removeEventListener(Event.ADDED_TO_STAGE, init, false);
        		
        		m_len = Math.random() * 90 + 10;
        		generateCircles();
        }
        
        private function generateCircles():void
        {
        		var line1:LineEquation = new LineEquation();
        		var line2:LineEquation = new LineEquation();
        		var line3:LineEquation = new LineEquation();
        		var line4:LineEquation = new LineEquation();
        		for(var i:int=0; i < m_len; i++)
        		{
        			var _x:Number = Math.random() * stage.stageWidth;
        			var _y:Number = Math.random() * stage.stageHeight;
        			var nearId:int = getNearestLineId(line1, line2, line3, line4, new Point(_x, _y));
        			var col:uint = getColorFromId(nearId);
        			var c:Circle = new Circle(col, Math.random()*10 + 5, 0.5);
        			c.x = _x;
     			c.y = _y;
        			addChild(c);
        		}
        }
     
     	private function getColorFromId(_id:int):uint
     	{
    			 var res:uint;
  			  	switch(_id)        			{        				case 0:        					res = MathUtil.getCol(255, 0, 0);        					break;        				case 1:      
  	  					res = MathUtil.getCol(0, 255, 0);        				
  	  					break;					case 2:        					
  	  					res = MathUtil.getCol(0, 0, 255);
  	  					break;					case 3:        					
  	  					res = MathUtil.getCol(0, 255, 255);
  	  					break;        			}
  		   return res;
    		}
        
        private function getNearestLineId(_line1:LineEquation, _line2:LineEquation, 
        					_line3:LineEquation, _line4:LineEquation, _pos:Point):int
        {
        		var res:int;
       		 		
     		var distance1:Number;
     		var distance2:Number;
     		var distance3:Number;
     		var distance4:Number;
     		
        		return res;
        }        
        private function removeFromHandler(event:Event):void
        {
        		removeEventListener(Event.REMOVED_FROM_STAGE, removeFromHandler, false);
        		
        }
        
        private function dispose():void
        {
        		for(var i:int = numChildren-1; i < 0; i--)
        		{
        			var c:DisplayObject = getChildAt(i);
        			
        			removeChild(c);
        		}
        }
    }
}

import flash.errors.IllegalOperationError;
import flash.geom.Point;
class MathUtil
{
	/**
	 * get a distance between point and line.
	 * @param _pos position
	 * @param _line lineentity
	 * @return distance.
	 */
	public static function getDistanceToLine(_pos:Point,_line:LineEquation):Number
	{
		var res:Number;
		var numerator:Number = Math.abs(_line.a*_pos.x + _line.b*_pos.y + _line.c);
		var denominator:Number = Math.sqrt(_line.a*_line.a + _line.b*_line.b);
		
		res = numerator / denominator;
		
		return res;
	}
	/**
	 * get color as uint from r, g, b values.
	 * @param _r red
	 * @param _g green
	 * @param _b blue
	 * @return color as uint
	 */
	public static function getCol(_r:int, _g:int, _b:int):uint
	{
		return _r << 16 | _g << 8 | _b;
	}
	
	public function MathUtil()
	{
		throw new IllegalOperationError("cannot instanciate");
	}
}
/**
 * This is the entity import flash.net.URLVariables;
 class to express line equation.
 * formula:  ax + by + c = 0
 */
class LineEquation
{
	public var a:Number;
	public var b:Number;
	public var c:Number;
	
	public function LineEquation(_a:Number=NaN, _b:Number=NaN, _c:Number=NaN)
	{
		a = _a;
		b = _b;
		c = _c;
	}
}

import flash.display.Shape;
class Circle extends Shape
{
	private var m_col:uint;
	private var m_size:Number;
	private var m_alpha:Number;
	public function Circle(_col:uint=0xffffff, _size:Number=10, _alpha:Number=0.5)
	{
		m_col = _col;
		m_size = _size;
		m_alpha = _alpha;
		graphics.beginFill(m_col, m_alpha);
		graphics.drawCircle(-m_size/2, -m_size/2, m_size);
		graphics.endFill();
	}
}
