/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ekB
 */

/*
直前のフレームと比較して色の変化している部分を抜き出す。

両方のフレームをgetPixelして比較すると、
計算量が多くなりそうな気がしたので、
まずはBlendModeのdifferenceで比較してから（右上）、
差の大きい部分のみを取り出している（右下）。

でも、これで意味があるほど計算量が減っているのかどうかの
確認はしていない。


参考
http://un-q.net/2007/01/actionscript3web.html
*/
package {
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.*;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.utils.Timer;
	
	public class CameraEx extends Sprite {
		
		private var video:Video;
//		private var btn:Sprite;
		private var _bitmapProcess:BitmapProcess;
		
		public function CameraEx() {
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			// camera
			var camera:Camera = Camera.getCamera();
			
			if (camera != null) {
				video = new Video(camera.width, camera.height);
				video.attachCamera(camera);
				addChild(video);
			} else {
				trace("You need a camera.");
			}
			
			
			_bitmapProcess = new BitmapProcess();
			_bitmapProcess.x = camera.width;
			this.addChild(_bitmapProcess);
			
//			// button
//			btn = new Sprite();
//			btn.buttonMode = true
//			btn.graphics.beginFill(0x333333);
//			btn.graphics.drawRect(0,0,100,30);
//			btn.y = camera.height + 10;            
//			addChild(btn);
//			btn.addEventListener(MouseEvent.MOUSE_UP, btnUp);
			
			var timer:Timer = new Timer(100,9999);
			timer.addEventListener(TimerEvent.TIMER,onTime);
			timer.start();
		}
		private function onTime(e:TimerEvent):void {
			_bitmapProcess.setBitmap(video);
		}
		
//		private function btnUp(e:MouseEvent):void {
//			_bitmapProcess.setBitmap(video);
//		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
//import flash.geom.ColorTransform;
import flash.geom.Rectangle;
import flash.media.Video;

class BitmapProcess extends Sprite{
	private var _bitmap0:Bitmap;
	private var _bitmap1:Bitmap;
	private var _bitmap2:Bitmap;
	private var _bitmapData0:BitmapData;
	private var _bitmapData1:BitmapData;
	private var _bitmapData2:BitmapData;
	public function BitmapProcess(){
		_bitmapData0 = new BitmapData(160,120,false,0x000000);
		_bitmap0 = new Bitmap(_bitmapData0);
		_bitmap0.scaleX = _bitmap0.scaleY = 2;
		this.addChild(_bitmap0);
		
		_bitmapData1 = new BitmapData(160,120,false,0x000000);
		_bitmap1 = new Bitmap(_bitmapData1);
		_bitmap1.scaleX = _bitmap1.scaleY = 2;
		_bitmap1.y = 240;
		this.addChild(_bitmap1);
		
		_bitmapData2 = new BitmapData(160,120,false,0x000000);
		_bitmap2 = new Bitmap(_bitmapData2);
//		_bitmap2.scaleX = _bitmap2.scaleY = 2;
//		_bitmap2.y = 500;
//		this.addChild(_bitmap2);
	}
	public function setBitmap(video:Video):void{
		_bitmapData0.draw(video);
		_bitmapData0.draw(_bitmap2,null,null,"difference");
		_bitmapData2.draw(video);
		
		_bitmapData1.lock();
		_bitmapData1.fillRect(new Rectangle(0,0,160,120),0xFF);
		var n:int = _bitmapData0.height;
		var m:int = _bitmapData0.width;
		for (var i:int = 0; i < n; i++) {
			for (var j:int = 0; j < m; j++) {
				if(getGray(_bitmapData0.getPixel(j,i))>8){
					_bitmapData1.setPixel(j,i,_bitmapData2.getPixel(j,i));
				}
			}
		}
		_bitmapData1.unlock();
	}
	public function getGray(rgb:uint):int{
		var r:int = rgb >> 16 & 0xFF;
		var g:int = rgb >> 8 & 0xFF;
		var b:int = rgb & 0xFF;
		return (r+g+b)/3;
	}
}