/**
 * Copyright Armando.Carreteros.Torres ( http://wonderfl.net/user/Armando.Carreteros.Torres )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8drq
 */

// forked from paq's Droid
package
{
    import flash.display.MovieClip;
    import flash.events.Event;
    
    /**
     * お年賀企画のFlash2Android用に作った.
     * ただし、Androidはもっていない.
     * ふて寝しているように見えてくる.
     * @author paq89
     */
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
    public class Android extends MovieClip
    {
        private var happy:Year;
        
        public function Android()
        {
            happy = new Year(2011, this);
            happy.start("あけましておめでとうございます。今年はFlashでAndroidアプリを作ってみませんか？");
        }
    }
    
}


//package
//{
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickObject;
    import flash.display.DisplayObject;
    import flash.display.DisplayObjectContainer;
    import flash.display.Graphics;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * Year クラスは クラス名とはかけ離れていますが、中身はDroidです.
     * TODO: 整ったコードにする
     * @author paq89
     */
    /*public*/ class Year extends Sprite
    {
        private var _box2d:QuickBox2D;
        private var mc:MovieClip;
        private var bodyGroup:QuickObject;
        
        /**
         * コンストラクター.
         */
        public function Year(arg:*, parent:DisplayObjectContainer)
        {
            parent.addChild(this);
            _box2d = new QuickBox2D(addChild(new MovieClip()) as MovieClip);
            _box2d.mouseDrag();
            createWalls();
        }
        
        /**
         * エンターフレームイベント.
         */
        private function loop(event:Event = null):void
        {
            mc.x = bodyGroup.x * 30;
            mc.y = bodyGroup.y * 30;
            mc.rotation = bodyGroup.angle * (180 / Math.PI);
        }
        
        /**
         * QuickBox2Dを開始します.
         */
        public function start(arg:*):void
        {
            _box2d.start();
            addEventListener(Event.ENTER_FRAME, loop);
            createDroid(2, 2, 1);
        }
        
        /**
         * 壁を作成します.
         */
        private function createWalls():void
        {
            var sw:Number = _box2d.main.stage.stageWidth / 30;
            var sh:Number = _box2d.main.stage.stageHeight / 30;
            
            // Top
            _box2d.addBox( { x:sw / 2, y: -0.5, width:sw, height:1, lineAlpha: 0, fillAlpha: 0, density:0.0 } );
            // Bottom
            _box2d.addBox( { x:sw / 2, y:sh + 0.5, width:sw, height:1, lineAlpha: 0, fillAlpha: 0, density:0.0 } );
            // Left
            _box2d.addBox( { x: -0.5, y:sh / 2, width:1, height:sh, lineAlpha: 0, fillAlpha: 0, density:0.0 } );
            // Right
            _box2d.addBox( { x:sw + 0.5, y:sh / 2, width:1, height:sh, lineAlpha: 0, fillAlpha: 0, density:0.0 } );
        }
        
        /**
         * Droidを作成します.
         * scaleはバグる
         */
        private function createDroid(x:Number, y:Number, scale:Number = 1, color:uint = 0xA4CA39):void
        {
            _box2d.setDefault( { fillColor:color, lineAlpha:0, fillAlpha:1 } );
            
            // 顔
            mc = new MovieClip();
            var g:Graphics = mc.graphics;
            g.beginFill(color);
            g.drawRoundRect(0, 60, 120 * scale, 120 * scale, 15, 15);
            g.beginFill(0xFFFFFF);
            g.drawRect(0, 62, 120 * scale, 5 * scale);
            g.drawCircle(32 * scale, 32 * scale, 4 * scale);
            g.drawCircle(88 * scale, 32 * scale, 4 * scale);
            addChild(mc);
            
            var head:QuickObject = _box2d.addCircle({
                x: x,
                y: y,
                radius: 2 * scale
            });
            var earLeft:QuickObject = _box2d.addBox({
                x: x - 1.2 * scale,
                y: y - 1.8 * scale,
                width: 1 * scale,
                height: 0.2 * scale,
                angle: 1
            });
            var earRight:QuickObject = _box2d.addBox({
                x: x + 1.2 * scale,
                y: y - 1.8 * scale,
                width: 1 * scale,
                height: 0.2 * scale,
                angle: -1
            });
            
            // 胴体を作る
            var bodyBox:QuickObject = _box2d.addBox({
                x: x,
                y: y + 1.8 * scale,
                width: 4 * scale,
                height: 4 * scale,
                fillAlpha: 0
            });
            // 顔と体と耳(?)をひとまとめにする
            bodyGroup = _box2d.addGroup( { objects: [head, bodyBox, earLeft, earRight] } );
            
            // 角を丸くするためのパラメーター
            var circleParamsA:Object = {
                x: x - 0.5 * scale,
                y: y - 1.0 * scale,
                radius: 0.5 * scale
            }
            var circleParamsB:Object = {
                x: x - 0.5 * scale,
                y: y + 1.0 * scale,
                radius: 0.5 * scale
            }
            
            // 左腕を作る
            var armLeft:QuickObject = _box2d.addBox({
                x: x - 0.5 * scale,
                y: y * scale,
                height: 2.2 * scale
            });
            var armLeftCircleA:QuickObject = _box2d.addCircle(circleParamsA);
            var armLeftCircleB:QuickObject = _box2d.addCircle(circleParamsB);
            var armLeftGroup:QuickObject = _box2d.addGroup( { x: 0.8 * scale, y: 4.2 * scale, objects: [armLeftCircleA, armLeft, armLeftCircleB] } );
            // 胴体と繋げる
            _box2d.addJoint({
                type: QuickBox2D.DISTANCE,
                a:armLeftGroup.body,
                b:bodyGroup.body,
                x1: armLeftCircleA.x + 0.8 * scale,
                x2: armLeftCircleA.x + 1.8 * scale,
                y1: armLeftCircleA.y + 4.2 * scale,
                y2: armLeftCircleA.y + 4.2 * scale
            });
            
            // 右腕を作る
            var armRight:QuickObject = _box2d.addBox({
                x: x - 0.5 * scale,
                y: y * scale,
                height: 2.2 * scale
            });
            var armRightCircleA:QuickObject = _box2d.addCircle(circleParamsA);
            var armRightCircleB:QuickObject = _box2d.addCircle(circleParamsB);
            var armRightGroup:QuickObject = _box2d.addGroup( {  x: 6.2 * scale, y: 4.2 * scale, objects: [armRightCircleA, armRight, armRightCircleB] } );
            // 胴体と繋げる
            _box2d.addJoint({
                type: QuickBox2D.DISTANCE,
                a:armRightGroup.body,
                b:bodyGroup.body,
                x1: armRightCircleA.x + 6.2 * scale,
                x2: armRightCircleA.x + 5.2 * scale,
                y1: armRightCircleA.y + 4.2 * scale,
                y2: armRightCircleA.y + 4.2 * scale
            });
            
            // 左足を作る
            var legLeft:QuickObject = _box2d.addBox({
                x: x - 0.5 * scale,
                y: y * scale,
                height: 1.8 * scale
            });
            var legLeftCircleA:QuickObject = _box2d.addCircle({
                x: x - 0.5 * scale,
                y: y + 0.8 * scale,
                radius: 0.5 * scale
            });
            var legLeftGroup:QuickObject = _box2d.addGroup( { x: 2.5 * scale, y: 7 * scale, objects: [legLeftCircleA, legLeft] } );
            // 胴体と繋げる
            _box2d.addJoint( {
                type: QuickBox2D.REVOLUTE,
                a: legLeftGroup.body,
                b: bodyGroup.body,
                x1: legLeft.x + 2.5 * scale,
                y1: legLeft.y + 6 * scale,
                x2: bodyGroup.x + 1 * scale,
                y2: legLeft.y + 6.4 * scale,
                collideConnected: false,
                enableLimit: true,
                lowerAngle: -1,
                upperAngle: 0.5
            });
            
            // 右足を作る
            var legRight:QuickObject = _box2d.addBox({
                x: x - 0.5 * scale,
                y: y * scale,
                height: 1.8 * scale
            });
            var legRightCircleA:QuickObject = _box2d.addCircle({
                x: x - 0.5 * scale,
                y: y + 0.8 * scale,
                radius: 0.5 * scale
            });
            var legRightGroup:QuickObject = _box2d.addGroup( { x: 4.5 * scale, y: 7 * scale, objects: [legRightCircleA, legRight] } );
            // 胴体と繋げる
            _box2d.addJoint( {
                type: QuickBox2D.REVOLUTE,
                a: legRightGroup.body,
                b: bodyGroup.body,
                x1: legRight.x + 4.5 * scale,
                y1: legRight.y + 6 * scale,
                x2: bodyGroup.x + 3.5 * scale,
                y2: legRight.y + 6.4 * scale,
                collideConnected: false,
                enableLimit: true,
                lowerAngle: -0.5,
                upperAngle: 1
            });
            
            loop();
        }
    }

//}