/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8dih
 */

/**
 * forked from : abakane (http://wonderfl.net/user/abakane)
 * 
 * SHAA ...ZAAM ! by the FLAHMAFIA
 * ~ lil' optimizations & tweaks ~
 * 
 **/
package {
    import flash.display.GradientType;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;

    [SWF(width='465', height='465', frameRate='45', backgroundColor='0x00000')]
    public class ShaaaZaaam extends Sprite {
        //
        public static const SW : Number = 465;
        public static const SH : Number = 465;
        private static const MAXLIGHTS : uint = 150;
        private const STARTRADIUS : Number = 32;
        //
        private var _bg : Shape;
        private var _container : Sprite;
        private var _lights : Vector.<Light>;
        private var _lum : Number;
        private var _ct : ColorTransform;
        private var _rotation : Number;

        public function ShaaaZaaam() {
            super();

            stage.quality = StageQuality.LOW;
            mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;

            _lum = Math.PI / 2;
            _ct = new ColorTransform();

            var m : Matrix = new Matrix();
            var a : int = Math.min(SW, SH);
            m.createGradientBox(a, a, 0, (SW - a) * 0.5, (SH - a) * 0.5);

            addChild(_bg = new Shape());
            _bg.filters = [new GlowFilter(0x00000, 0.22, SW / 4, SH / 4, 2, BitmapFilterQuality.HIGH, true)];
            _bg.graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0x808080], [1, 1], [0x00, 0xFF], m);
            _bg.graphics.drawRect(0.0, 0.0, SW, SH);
            _bg.graphics.endFill();
            _bg.opaqueBackground = _bg.cacheAsBitmap = true;

            addChild(_container = new Sprite());
            _container.x = SW / 2;
            _container.y = SH / 2;

            _lights = new Vector.<Light>(MAXLIGHTS, true);
            var n : uint = _lights.length;
            while (n-- != 0) _container.addChild(_lights[n] = new Light());

            _rotation = 0.0;

            addEventListener(Event.ENTER_FRAME, update);
        }

        private function update(e : Event) : void {
            // animate lum
            _lum += 0.0088;
            var lumSin : Number = Math.sin(_lum);

            // reset
            for each (var light : Light in _lights) {
                var rnd : Number = lumSin * Math.random();

                if (light.invAlpha < 0.01) {
                    light.invAlpha = 0.1 + 0.9 * rnd;
                    light.rotation = 360 * 3 * rnd;
                    var angle : Number = light.rotation / 360 * Math.PI * 2;

                    light.speed = 1 + light.invAlpha;
                    light.x = (light.dx = Math.cos(angle)) * light.speed * STARTRADIUS;
                    light.y = (light.dy = Math.sin(angle)) * light.speed * STARTRADIUS;
                }

                // animate light
                light.alpha = 1 - (light.invAlpha *= 0.8);
                light.speed *= 1.11;
                light.x += light.dx * light.speed;
                light.y += light.dy * light.speed;
            }

            // animate light space
            _container.rotation += 2.0;

            // apply lum
            _ct.redMultiplier = (_ct.greenMultiplier = (_ct.blueMultiplier = lumSin) * 0.9) * 0.9;
            _bg.transform.colorTransform = _ct;
        }
    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.Shape;
import flash.filters.BitmapFilterQuality;
import flash.filters.BlurFilter;

class Light extends Bitmap {
    //
    private const BLUR : Number = 2;
    //
    public var dx : Number;
    public var dy : Number;
    public var speed : Number;
    public var invAlpha : Number;

    public function Light() {
        var length : Number = 4 + 24 * Math.random();
        var line : Shape = new Shape();
        line.graphics.lineStyle(0, 0xFFFFFF);
        line.graphics.moveTo(BLUR, BLUR);
        line.graphics.lineTo(BLUR + length, BLUR);
        line.filters = [new BlurFilter(BLUR, BLUR, BitmapFilterQuality.HIGH)];

        super(new BitmapData(length + BLUR * 2, BLUR * 2, true, 0x00000000));
        bitmapData.draw(line);

        blendMode = BlendMode.ADD;

        invAlpha = alpha = 0.0;
    }
}