/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8dbP
 */

// forked from yonatan's test
// Spritesheet by killy overdrive, from http://opengameart.org/content/spaceship-banking
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    import org.si.cml.*;
    import org.si.cml.extensions.*;
    import org.si.b3.*;
    import net.hires.debug.Stats;

    [SWF(frameRate="30")]
    public class CMLObjectSample extends Sprite {
        public var stageCML:String = "py-160[px$??*100n{{[rw]}vy$?*10+2i40v~bm$i?(5)+2,45f5vd-10}w10]";
        function CMLObjectSample() {
            var url:String = "http://assets.wonderfl.net/images/related_images/3/3d/3d07/3d0778eeedae01242fe344a84d0a20afc2ee78f7";
            var loader:Loader = new Loader;
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _onLoad);
            loader.load(new URLRequest(url), new LoaderContext(true));
        }

        private function _onLoad(e:Event):void {
            var occ:Sprite = new Sprite;
            var bmd:BitmapData = Bitmap(e.target.content).bitmapData;
            occ.addChild(bg = new Background(3));
            mc = new CMLMovieClip(occ, (465-W)/2, (465-H)/2, W, H, 0, true, _onFirstFrame);
            mc.screen = mc.bitmapData = new BitmapData(465, 465, true, 0); // hack - should work as long as setSize isn't called.
            ship = new CMLMovieClipTexture(bmd, 0, 0, bmd.width/7, bmd.height, false, 7);
            fx = new VolumetricPointLight(800, 600, occ, [0xc08040, 0x4080c0, 0], [1, 1, 1], [0, 20, 30]);
            fx.setViewportSize(465, 465);
            fx.srcX = 465/2;
            fx.srcY = 465/4;
            fx.intensity = 0;
            addChild(fx);
            fx.startRendering();
        }

        private function _onFirstFrame():void {
            var cmlMaster:CMLMaster = new CMLMaster;
            cmlMaster.create(0, 0);
            cmlMaster.execute(new CMLSequence(stageCML));
            addEventListener("enterFrame", _onEnterFrame);
            //addChild(new Stats);
        }

        private function _onEnterFrame(e:Event):void {
            // hit check between shots and enemies
            Actor.testf(shotFactory.evalIDNumber, enemyFactory.evalIDNumber);
            // hit check between bullets and player
            Actor.testf(playerFactory.evalIDNumber, bulletFactory.evalIDNumber);
            // hit check between powerups and player
            Actor.testf(playerFactory.evalIDNumber, powerUpFactory.evalIDNumber);
            // render
            if(player.ignoreHit) {
                fx.intensity = 1.5;
            } else {
                fx.intensity += 0.01;
            }
            fx.srcX = 232.5 + player.x;
            fx.srcY = 232.5 + player.y;
            bg.draw(Math.sin(frameCount/20)*400 - player.x+465/2, frameCount*8);
            mc.screen.lock();
            mc.clearScreen();
            // mc.screen.colorTransform(mc.screen.rect, new ColorTransform(1, 1, 1, 0.5))
            Actor.draw();
            mc.screen.unlock();
            frameCount++;
        }
    }
}

import flash.display.*;
import flash.geom.*;
import org.si.cml.*;
import org.si.cml.extensions.*;
import org.si.b3.*;
import org.si.b3.modules.*;

const W:int = 465;
const H:int = 465;
var mc:CMLMovieClip;
var enemyFactory:ActorFactory;
var bulletFactory:ActorFactory;
var playerFactory:ActorFactory;
var shotFactory:ActorFactory;
var powerUpFactory:ActorFactory;
var player:Player;
var frameCount:int = 0;
var ship:CMLMovieClipTexture;
var bg:Background;
var fx:VolumetricPointLight;

class CMLMaster extends CMLObject {
    public function CMLMaster():void {
        enemyFactory = new ActorFactory(Enemy);
        bulletFactory = new ActorFactory(Bullet);
        playerFactory = new ActorFactory(Player);
        shotFactory = new ActorFactory(Shot);
        powerUpFactory = new ActorFactory(PowerUp);
        player = playerFactory.newInstance();
        player.create(0, 100);
        player.setAsDefaultTarget();
        super();
    }

    override public function onNewObject(args:Array):CMLObject {  
        return enemyFactory.newInstance();
    }
}

class Enemy extends Actor {
    public function Enemy() { size = 4; super(); }
    override public function onDestroy():void { 
        if(destructionStatus == 1 && Math.random() < 0.2) {
            var p:PowerUp = powerUpFactory.newInstance();
            p.create(x, y);
            p.vy = -5;
        }
    }
    override public function onFireObject(args:Array):CMLObject { return bulletFactory.newInstance(); }
    override public function onDraw():void { mc.fillRect(0xffff4040, x-4, y-4, 9, 9); }
    override public function onHit(act:Actor):void { destroy(1); }
}

class Bullet extends Actor {
    public function Bullet() { size = 2; super(); }
    override public function onDraw():void { mc.fillRect(0xffff8080, x-2, y-2, 5, 5); }
}

class Player extends Actor {
    public var ignoreHit:int = 100;
    public var numShots:int = 1;
    public var roll:int = 0;
    public function Player() { size = 4; super(); }
    override public function onDraw():void { 
        if(ignoreHit & 1) return;
        mc.copyTexture(ship, x, y+20, 3 + Math.round(roll)); // y+20 to line up the hitbox with the cockpit
    }

    override public function onUpdate():void {
        if(mc.control.x == 0) {
            if(roll) roll += roll>0 ? -1 : 1;
        } else {
            roll += mc.control.x;
            if(roll>3) roll = 3;
            if(roll<-3) roll = -3;
        }
        x += mc.control.x*8;
        y += mc.control.y*8;
        if(x > (W>>1)) x = W>>1;
        if(y > (H>>1)) y = H>>1;
        if(x < (-W>>1)) x = -W>>1;
        if(y < (-H>>1)) y = -H>>1;
        if(mc.control.isPressed(CMLMovieClipControl.KEY_BUTTON0)) {
            if(mc.control.getPressedFrame(CMLMovieClipControl.KEY_BUTTON0) & 1) {
                var angle:Number = -5 * (numShots-1);
                for(var i:int=0; i<numShots; i++) {
                    var shot:Shot = shotFactory.newInstance();
                    shot.create(x, y);
                    shot.vx = Math.sin(angle*Math.PI/180)*11;
                    shot.vy = Math.cos(angle*Math.PI/180)*-11;
                    angle += 10;
                }
            }
        }
        if(ignoreHit) ignoreHit--;
    }

    override public function onHit(act:Actor):void { 
        if(act is Bullet) {
            fx.intensity = 0;
            ignoreHit = 100;
            numShots = 1;
        } else if(act is PowerUp) {
            if(numShots<7) numShots++;
            act.destroy(1);
        }
    }
}

class Shot extends Actor {
    public function Shot() { size = 3; super(); }
    override public function onDraw():void { mc.fillRect(0xff8080ff, x-1, y-2, 3, 5); }
}

class PowerUp extends Actor {
    public function PowerUp() { size = 7; super(); }
    override public function onDraw():void { mc.fillRect(0xff80ff80, x-7, y-7, 14, 14); }
    override public function onUpdate():void { vy += 0.5; super.onUpdate(); }
}

class Background extends Shape {
    protected var _tilings:Array = [];
    protected var _layers:uint;

    public function Background(layers:uint) {
        _layers = layers;
        var ct:ColorTransform = new ColorTransform(0.6, 0.6, 0.6, 1.2);
        var tiling:BitmapData = new BitmapData(9, 9, true, 0);
        tiling.fillRect(new Rectangle(1, 1, 7, 7), 0xa0606060);
        for(var i:int=0; i<_layers; i++) {
            tiling.colorTransform(tiling.rect, ct);
            _tilings.push(tiling);
            tiling = tiling.clone();
        }
    }

    public function draw(x:Number, y:Number):void {
        var m:Matrix = new Matrix;
        graphics.clear();
        for(var i:int=0; i<_layers; i++) {
            m.identity();
            m.translate(x/20, y/20);
            m.scale(5+i*10, 5+i*10);
            m.rotate(frameCount/1000);
            graphics.beginBitmapFill(_tilings[i], m);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;

/**
* The EffectContainer class creates a volumetric light effect (also known as crepuscular or "god" rays).
* This is done in 2D with some bitmap processing of an emission object, and optionally an occlusion object.
*/
class EffectContainer extends Sprite {
    /**
    * When true a blur filter is applied to the final effect bitmap (can help when colorIntegrity == true).
    */
    public var blur:Boolean = false;
    /**
    * Selects rendering method; when set to true colors won't be distorted and performance will be
    * a little worse. Also, this might make the final output appear grainier.
    */
    public var colorIntegrity:Boolean = false;
    /**
    * Light intensity.
    */
    public var intensity:Number = 4;
    /**
    * Number of passes applied to buffer. Lower numbers mean lower quality but better performance,
    * anything above 8 is probably overkill.
    */
    public var passes:uint = 6;
    /**
    * Set this to one of the StageQuality constants to use this quality level when drawing bitmaps, or to
    * null to use the current stage quality. Mileage may vary on different platforms and player versions.
    * I think it should only be used when stage.quality is LOW (set this to BEST to get reasonable results).
    */
    public var rasterQuality:String = null;
    /**
    * Final scale of emission. Should always be more than 1.
    */
    public var scale:Number = 2;
    /**
    * Smooth scaling of the effect's final output bitmap.
    */
    public var smoothing:Boolean = true;
    /**
    * Light source x.
    * @default viewport center (set in constructor).
    */
    public var srcX:Number;
    /**
    * Light source y.
    * @default viewport center (set in constructor).
    */
    public var srcY:Number;

    protected var _blurFilter:BlurFilter = new BlurFilter(2, 2);
    protected var _emission:DisplayObject;
    protected var _occlusion:DisplayObject;
    protected var _ct:ColorTransform = new ColorTransform;
    protected var _halve:ColorTransform = new ColorTransform(0.5, 0.5, 0.5);
    protected var _occlusionLoResBmd:BitmapData;
    protected var _occlusionLoResBmp:Bitmap;
    protected var _baseBmd:BitmapData;
    protected var _bufferBmd:BitmapData;
    protected var _lightBmp:Bitmap = new Bitmap;
    protected var _bufferSize:uint = 0x8000;
    protected var _bufferWidth:uint;
    protected var _bufferHeight:uint;
    protected var _viewportWidth:uint;
    protected var _viewportHeight:uint;
    protected var _mtx:Matrix = new Matrix;

    /**
    * Creates a new effect container.
    *
    * @param width Viewport width in pixels.
    * @param height Viewport height in pixels.
    * @param emission A DisplayObject to which the effect will be applied. This object will be
    * added as a child of the container. When applying the effect the object's filters and color
    * transform are ignored, if you want to use filters or a color transform put your content in
    * another object and addChild it to this one instead.
    * @param occlusion An optional occlusion object, handled the same way as the emission object.
    */
    public function EffectContainer(width:uint, height:uint, emission:DisplayObject, occlusion:DisplayObject = null) {
        if(!emission) throw(new Error("emission DisplayObject must not be null."));
        addChild(_emission = emission);
        if(occlusion) addChild(_occlusion = occlusion);
        setViewportSize(width, height);
        _lightBmp.blendMode = BlendMode.ADD;
        addChild(_lightBmp);
        srcX = width / 2;
        srcY = height / 2;
    }

    /**
    * Sets the container's size. This method recreates internal buffers (slow), do not call this on
    * every frame.
    *
    * @param width Viewport width in pixels
    * @param height Viewport height in pixels
    */
    public function setViewportSize(width:uint, height:uint):void {
        _viewportWidth = width;
        _viewportHeight = height;
        scrollRect = new Rectangle(0, 0, width, height);
        _updateBuffers();
    }

    /**
    * Sets the approximate size (in pixels) of the effect's internal buffers. Smaller number means lower
    * quality and better performance. This method recreates internal buffers (slow), do not call this on
    * every frame.
    *
    * @param size Buffer size in pixels
    */
    public function setBufferSize(size:uint):void {
        _bufferSize = size;
        _updateBuffers();
    }

    protected function _updateBuffers():void {
        var aspect:Number = _viewportWidth / _viewportHeight;
        _bufferHeight = Math.max(1, Math.sqrt(_bufferSize / aspect));
        _bufferWidth  = Math.max(1, _bufferHeight * aspect);
        dispose();
        _baseBmd           = new BitmapData(_bufferWidth, _bufferHeight, false, 0);
        _bufferBmd         = new BitmapData(_bufferWidth, _bufferHeight, false, 0);
        _occlusionLoResBmd = new BitmapData(_bufferWidth, _bufferHeight, true, 0);
        _occlusionLoResBmp = new Bitmap(_occlusionLoResBmd);
    }

    /**
    * Render a single frame.
    *
    * @param e In case you want to make this an event listener.
    */
    public function render(e:Event = null):void {
        if(!(_lightBmp.visible = intensity > 0)) return;
        var savedQuality:String = stage.quality;
        if(rasterQuality) stage.quality = rasterQuality;
        var mul:Number = colorIntegrity ? intensity : intensity/(1<<passes);
        _ct.redMultiplier = _ct.greenMultiplier = _ct.blueMultiplier = mul;
        _drawLoResEmission();
        if(_occlusion) _eraseLoResOcclusion();
        if(rasterQuality) stage.quality = savedQuality;
        var s:Number = 1 + (scale-1) / (1 << passes);
        var tx:Number = srcX/_viewportWidth*_bufferWidth;
        var ty:Number = srcY/_viewportHeight*_bufferHeight;
        _mtx.identity();
        _mtx.translate(-tx, -ty);
        _mtx.scale(s, s);
        _mtx.translate(tx, ty);
        _lightBmp.bitmapData = _applyEffect(_baseBmd, _bufferBmd, _mtx, passes);
        _lightBmp.width = _viewportWidth;
        _lightBmp.height = _viewportHeight;
        _lightBmp.smoothing = smoothing;
    }

    /**
    * Draws a scaled-down emission on _baseBmd.
    */
    protected function _drawLoResEmission():void {
        _copyMatrix(_emission.transform.matrix, _mtx);
        _mtx.scale(_bufferWidth / _viewportWidth, _bufferHeight / _viewportHeight);
        _baseBmd.fillRect(_baseBmd.rect, 0);
        _baseBmd.draw(_emission, _mtx, colorIntegrity ? null : _ct);
    }

    /**
    * Draws a scaled-down occlusion on _occlusionLoResBmd and erases it from _baseBmd.
    */
    protected function _eraseLoResOcclusion():void {
        _occlusionLoResBmd.fillRect(_occlusionLoResBmd.rect, 0);
        _copyMatrix(_occlusion.transform.matrix, _mtx);
        _mtx.scale(_bufferWidth / _viewportWidth, _bufferHeight / _viewportHeight);
        _occlusionLoResBmd.draw(_occlusion, _mtx);
        _baseBmd.draw(_occlusionLoResBmp, null, null, BlendMode.ERASE);
    }

    /**
    * Render the effect on every frame until stopRendering is called.
    */
    public function startRendering():void {
        addEventListener(Event.ENTER_FRAME, render);
    }

    /**
    * Stop rendering on every frame.
    */
    public function stopRendering():void {
        removeEventListener(Event.ENTER_FRAME, render);
    }

    /**
    * Low-level workhorse, applies the lighting effect to a bitmap. This function modifies the src and buffer
    * bitmaps and its mtx argument.
    *
    * @param src The BitmapData to apply the effect on.
    * @param buffer Another BitmapData object for temporary storage. Must be the same size as src.
    * @param mtx Effect matrix.
    * @param passes Number of passes to make.
    * @return A processed BitmapData object (supplied in either src or buffer) with final effect output.
    */
    protected function _applyEffect(src:BitmapData, buffer:BitmapData, mtx:Matrix, passes:uint):BitmapData {
        var tmp:BitmapData;
        while(passes--) {
            if(colorIntegrity) src.colorTransform(src.rect, _halve);
            buffer.copyPixels(src, src.rect, src.rect.topLeft);
            buffer.draw(src, mtx, null, BlendMode.ADD, null, true);
            mtx.concat(mtx);
            tmp = src; src = buffer; buffer = tmp;
        }
        if(colorIntegrity) src.colorTransform(src.rect, _ct);
        if(blur) src.applyFilter(src, src.rect, src.rect.topLeft, _blurFilter);
        return src;
    }

    /**
    * Dispose of all intermediate buffers. After calling this the EffectContainer object will be unusable.
    */
    public function dispose():void {
        if(_baseBmd) _baseBmd.dispose();
        if(_occlusionLoResBmd) _occlusionLoResBmd.dispose();
        if(_bufferBmd) _bufferBmd.dispose();
        _baseBmd = _occlusionLoResBmd = _bufferBmd = _lightBmp.bitmapData = null;
    }

    protected function _copyMatrix(src:Matrix, dst:Matrix):void {
        dst.a = src.a;
        dst.b = src.b;
        dst.c = src.c;
        dst.d = src.d;
        dst.tx = src.tx;
        dst.ty = src.ty;
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

/**
* VolumetricPointLight creates a simple effect container with a gradient emission pattern.
* The gradient's center is automatically moved to the (srcX, srcY) coordinates
* and it's radius is adjusted to the length of the viewport's diagonal, so if you
* set srcX and srcY to the viewport's center then only half of the gradient colors
* will be used.
*
* <p>This should also perform a little better than EffectContainer.</p>
*/
class VolumetricPointLight extends EffectContainer {
    protected var _colors:Array;
    protected var _alphas:Array;
    protected var _ratios:Array;
    protected var _gradient:Shape = new Shape;
    protected var _gradientMtx:Matrix = new Matrix;
    protected var _gradientBmp:Bitmap = new Bitmap;
    protected var _lastSrcX:Number;
    protected var _lastSrcY:Number;
    protected var _lastIntensity:Number;
    protected var _lastColorIntegrity:Boolean = false;
    protected var _gradientLoResBmd:BitmapData;
    protected var _gradientLoResDirty:Boolean = true;

    /**
    * Creates a new effect container, with an emission created from the supplied color or gradient.
    * The constructor lets you use a shortcut syntax for creating simple single-color gradients.
    * @example The shortcut syntax:
    * <listing>new VolumetricPointLight(800, 600, occlusion, 0xc08040);</listing>
    * @example is equivalent to:
    * <listing>new VolumetricPointLight(800, 600, occlusion, [0xc08040, 0], [1, 1], [0, 255]);</listing>
    *
    * @param width Viewport width in pixels.
    * @param height Viewport height in pixels.
    * @param occlusion An occlusion object, will be overlayed above the lighting gradient and under the light effect bitmap.
    * @param colorOrGradient Either a gradient colors array, or a uint color value.
    * @param alphas Will only be used if colorOrGradient is an array. This will be passed to beginGradientFill.
    *               If not provided alphas will all be 1.
    * @param ratios Will only be used if colorOrGradient is an array. This will be passed to
    *               beginGradientFill. If colorOrGradient is an Array and ratios aren't provided default
    *               ones will be created automatically.
    */
    public function VolumetricPointLight(width:uint, height:uint, occlusion:DisplayObject, colorOrGradient:*, alphas:Array = null, ratios:Array = null) {
        if(colorOrGradient is Array) {
            _colors = colorOrGradient.concat();
            if(!ratios) _ratios = colorOrGradient.map(function(item:*, i:int, arr:Array):int { return 0x100*i/(colorOrGradient.length+i-1) });
            if(!alphas) _alphas = _colors.map(function(..._):Number { return 1 });
        } else {
            _colors = [colorOrGradient, 0];
            _ratios = [0, 255];
        }
        super(width, height, _gradientBmp, occlusion);
        if(!occlusion) throw(new Error("An occlusion DisplayObject must be provided."));
        if(!(colorOrGradient is Array || colorOrGradient is uint)) throw(new Error("colorOrGradient must be either an Array or a uint."));
    }

    protected function _drawGradient():void {
        var size:Number = 2 * Math.sqrt(_viewportWidth*_viewportWidth + _viewportHeight*_viewportHeight);
        _gradientMtx.createGradientBox(size, size, 0, -size/2 + srcX, -size/2 + srcY);
        _gradient.graphics.clear();
        _gradient.graphics.beginGradientFill(GradientType.RADIAL, _colors, _alphas, _ratios, _gradientMtx);
        _gradient.graphics.drawRect(0, 0, _viewportWidth, _viewportHeight);
        _gradient.graphics.endFill();
        if(_gradientBmp.bitmapData) _gradientBmp.bitmapData.dispose();
        _gradientBmp.bitmapData = new BitmapData(_viewportWidth, _viewportHeight, true, 0);
        _gradientBmp.bitmapData.draw(_gradient);
    }

    /**
    * Updates the lo-res gradient bitmap if neccesary and copies it to _baseBmd.
    */
    override protected function _drawLoResEmission():void {
        if(_gradientLoResDirty) {
            super._drawLoResEmission();
            _gradientLoResBmd.copyPixels(_baseBmd, _baseBmd.rect, _baseBmd.rect.topLeft);
            _gradientLoResDirty = false;
        } else {
            _baseBmd.copyPixels(_gradientLoResBmd, _baseBmd.rect, _baseBmd.rect.topLeft);
        }
    }

    /** @inheritDoc */
    override protected function _updateBuffers():void {
        super._updateBuffers();
        _gradientLoResBmd = new BitmapData(_bufferWidth, _bufferHeight, false, 0);
        _gradientLoResDirty = true;
    }

    /** @inheritDoc */
    override public function setViewportSize(width:uint, height:uint):void {
        super.setViewportSize(width, height);
        _drawGradient();
        _gradientLoResDirty = true;
    }

    /** @inheritDoc */
    override public function render(e:Event = null):void {
        var srcChanged:Boolean = _lastSrcX != srcX || _lastSrcY != srcY;
        if(srcChanged) _drawGradient();
        _gradientLoResDirty ||= srcChanged;
        _gradientLoResDirty ||= (!colorIntegrity && (_lastIntensity != intensity));
        _gradientLoResDirty ||= (_lastColorIntegrity != colorIntegrity);
        _lastSrcX = srcX;
        _lastSrcY = srcY;
        _lastIntensity = intensity;
        _lastColorIntegrity = colorIntegrity;
        super.render(e);
    }

    /** @inheritDoc */
    override public function dispose():void {
        super.dispose();
        if(_gradientLoResBmd) _gradientLoResBmd.dispose();
        _gradientLoResBmd = null;
    }
}
