/**
 * Copyright Takayuki.Yamazaki ( http://wonderfl.net/user/Takayuki.Yamazaki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8dUK
 */

// forked from Makoto_Tanaka's papervision3D 2010-3-17
package {
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    import org.papervision3d.view.layer.*;
    
    import flash.events.Event;
    import flash.geom.*;
    import flash.filters.*;
    import flash.display.*;
    
    public class PapervisionTest extends BasicView {
            
            private var _sphere:Sphere;
            
        public function PapervisionTest() {
            
            var bfx:BitmapEffectLayer = new BitmapEffectLayer(viewport, 465, 465);
            bfx.addEffect(new BitmapLayerEffect(new BlurFilter(16,16,2)));
            bfx.drawCommand = new BitmapDrawCommand(null, new ColorTransform(1, 1, 0.15), BlendMode.ADD);
            bfx.clippingPoint = new Point(0,-10);
            viewport.containerSprite.addLayer(bfx);
            
            // マテリアルを作成
            var material:WireframeMaterial = new WireframeMaterial(0xFF0000);
            
            // 3Dオブジェクトを作成
            _sphere = new Sphere(material, 300, 10, 10);
            var sphere2:Sphere = new Sphere(material, 300, 10, 10);
            
            _sphere.x = 500;
            sphere2.x = -500;
            
            // 3Dシーンに追加して、表示させる。
            scene.addChild(_sphere);
            scene.addChild(sphere2);
            
            bfx.addDisplayObject3D(_sphere);
            
            // レンダリング開始
            startRendering();
            
            addEventListener(Event.ENTER_FRAME, onLoop);
        }
        
        private function onLoop(e:Event):void {
                _sphere.rotationX += 0;
                _sphere.rotationY += 1;
                _sphere.rotationZ += 0;
                
                var rateX:Number = mouseX / stage.stageWidth;
                var targetX:Number = -500 * (rateX - 0.5);
                camera.x += (targetX - rateX) * 0.2;
                
                var rateY:Number = mouseY / stage.stageHeight;
                var targetY:Number = 500 * (rateY - 0.5); 
                camera.y = (targetY - rateY) * 0.2;
        }
    }
}