/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8dEo
 */

//--------------------------------------------
//TriangleMesh3Dの練習
//　URL:http://programmingatelier.net/
//--------------------------------------------
package 
{
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.materials.*;  
    import org.papervision3d.objects.primitives.*;  
    import org.papervision3d.objects.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.view.*;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.geom.renderables.Triangle3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import flash.events.Event;

    public class Main extends BasicView
    {
        //3D形状の配置領域
        private var rootNode:DisplayObject3D;
        //ライト
        private var light:PointLight3D;
        //カメラ位置を求める角度
        private     var kakudo0:Number;
        private     var kakudo1:Number;
        private     var kakudo2:Number;
        
        public function Main():void {
            //3D形状の配置領域作成
            rootNode = new DisplayObject3D();
            this.scene.addChild(rootNode);
            //光源
            light = new PointLight3D();
            light.x = -1000;
            light.y = 1000;
            light.z = 1000;

            //マテリアル定義
            var compoMat:CompositeMaterial = new CompositeMaterial();
            var matShade:FlatShadeMaterial = new FlatShadeMaterial(light, 0xaaffaa, 0x668866);
            var matWire:WireframeMaterial = new WireframeMaterial( 0x000000, 0.2);
            compoMat.addMaterial(matShade);
            compoMat.addMaterial(matWire);
            compoMat.doubleSided = true;  //裏表示
            //使用する座標を求める
            var arrVec3D:Array = new Array();
            var mesh:TriangleMesh3D = new TriangleMesh3D( compoMat, new Array(), new Array(), null );
            for (var x:Number = -200; x <= 200; x += 20) {
                for (var y:Number = -200; y <= 200; y += 20) {
                    var v3dP:Vertex3D = new Vertex3D(x, fncGetZ(x, y), y);
                    arrVec3D.push(v3dP);
                    mesh.geometry.vertices.push( v3dP );
                }
            }
            //形状の作成
            for (var i:Number = 0; i < 20; i++) {
                for (var j:Number = 0; j < 20; j++) {
                    //三角2枚で四角を作成
                    mesh.geometry.faces.push( new Triangle3D( mesh, 
                            new Array(
                                arrVec3D[i+j*21],
                                arrVec3D[i+21+j*21],
                                arrVec3D[i+1+j*21])
                            , null,null ));
                    mesh.geometry.faces.push( new Triangle3D( mesh, 
                            new Array(
                                arrVec3D[i+1+j*21],
                                arrVec3D[i+21+j*21],
                                arrVec3D[i+22+j*21])
                            , null,null ));
                }
            }
            rootNode.addChild(mesh);
            //カメラ用角度クリア
            kakudo0 = 0;
            kakudo1 = 0;
            kakudo2 = 0;
            //繰り返し処理登録
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        //XYからZ値を求める式
        private function fncGetZ(x:Number, y:Number):Number {
            var z:Number = 30.0 * (Math.cos(Math.sqrt(x * x + y * y)*Math.PI/180.0) 
                        + Math.cos(3.0 * Math.sqrt(x * x + y * y)*Math.PI/180.0));
            return z;
        }
        private function onFrame(e:Event):void {
            //カメラを回転させるための角度を増加させる
            kakudo0 += 0.3;
            kakudo1++;
            if (kakudo1 >= 360) { kakudo1 = 0; }
            if (kakudo0 >= 360) { kakudo0 -= 360; }
            kakudo2 = Math.sin(kakudo0 * Math.PI / 180) * 80;
            //カメラの位置セット、形状表示
            onSlChmg();
        }
        
        //カメラの位置セット、形状表示
        private function onSlChmg():void {
            //カメラ位置
            var kyori:Number = 500;//原点・カメラの距離
            //高さ方向の角度（ラジアン）
            var ang1:Number =  kakudo2 * Math.PI / 180.0;    
            //方向（ラジアン）
            var ang2:Number = (kakudo1-180) * Math.PI / 180.0;    
            var x:Number=kyori*Math.cos(ang1)*Math.sin(ang2);
            var y:Number=kyori*Math.cos(ang1)*Math.cos(ang2);
            var z:Number = kyori*Math.sin(ang1);
            this.camera.x = x;
            this.camera.z = y;
            this.camera.y = z;

            //描画処理
            this.renderer.renderScene( this.scene , this.camera , this.viewport );
        }
    }

}