/**
 * Copyright hacker_d9x06x60 ( http://wonderfl.net/user/hacker_d9x06x60 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8d1m
 */

// forked from hacker_d9x06x60's forked from: [Stardust][Away3D Lite] Icon Shower
// forked from paq's [Stardust][Away3D Lite] Icon Shower
package 
{
    import away3dlite.cameras.HoverCamera3D;
    import away3dlite.containers.ObjectContainer3D;
    import away3dlite.containers.Scene3D;
    import away3dlite.containers.View3D;
    import away3dlite.core.clip.RectangleClipping;
    import away3dlite.materials.BitmapMaterial;
    import flash.display.BitmapData;
    import flash.display.IBitmapDrawable;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import idv.cjcat.stardust.threeD.away3dlite.handlers.Away3DLiteObject3DHandler;
    import net.hires.debug.Stats;
    
    /**
     * IconShower はStardustとAway3D Liteを使ったサンプルです.
     * @author paq89
     */
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
    public class IconShower extends Sprite 
    {
        /** @private */ private var _emitter:IconEmitter;
        
        /** @private */ private var _scene:Scene3D;
        /** @private */ private var _view:View3D;
        /** @private */ private var _camera:HoverCamera3D;
        /** @private */ private var _clipping:RectangleClipping;
        /** @private */ private var _container:ObjectContainer3D;
        
        /** @private */ private var _lastMouseX:int;
        /** @private */ private var _lastMouseY:int;
        /** @private */ private var _material:BitmapMaterial;
        
        /**
         * コンストラクタ.
         */
        public function IconShower():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * 初期化します.
         * @private
         * @param    event
         */
        private function init(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            initStage();
            initResources();
        }
        
        /**
         * ステージを最適な設定にします.
         * @private
         */
        private function initStage():void 
        {
            stage.quality = StageQuality.LOW;
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _lastMouseX = stage.stageWidth / 2;
            _lastMouseY = stage.stageHeight / 2;
        }
        
        /**
         * 必要な外部リソースを読み込みます.
         * @private
         */
        private function initResources():void 
        {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);
            var url:String = this.root.loaderInfo.parameters["viewer.iconURL"];
            var req:URLRequest = new URLRequest("http://wonderfl.net/images/icon/9/9a/9a3d/9a3d6f78091dce4ac57ebf3f8d754e6cdeca9013m")
            if (url) req.url = url;
            req.url = "http://wonder-tools.appspot.com/api/proxy?url=" + req.url;
            loader.load(req, new LoaderContext(true));
        }
        
        /**
         * 外部リソースの読み込みが完了したときに実行されます.
         * @private
         * @param    event
         */
        private function loadComplete(event:Event):void
        {
            event.target.removeEventListener(Event.COMPLETE, loadComplete);
            
            initEngine();
            initMaterial(event.target.content);
            initEmitter();
            initListeners();
        }
        
        /**
         * 3Dエンジンを初期化します.
         * @private
         */
        private function initEngine():void 
        {
            _scene = new Scene3D();
            
            _camera = new HoverCamera3D();
            _camera.focus = 50;
            _camera.minTiltAngle = -90;
            _camera.maxTiltAngle = 90;
            _camera.panAngle = 0;
            _camera.tiltAngle = 0;
            _camera.hover(true);
            
            _clipping = new RectangleClipping();
            _clipping.minX = -400;
            _clipping.minY = -400;
            _clipping.maxX = 400;
            _clipping.maxY = 400;
            
            _view = new View3D();
            _view.scene = _scene;
            _view.camera = _camera;
            _view.clipping = _clipping;
            
            _container = new ObjectContainer3D();
            _scene.addChild(_container);
            
            onResize();
            
            addChild(_view);
            addChild(new Stats());
        }
        
        /**
         * イベントリスナーを登録します.
         * @private
         */
        private function initListeners():void 
        {
            addEventListener(Event.ENTER_FRAME, mainLoop);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(Event.RESIZE, onResize);
        }
        
        /**
         * ソースを元にCube6用のマテリアルを作成します.
         * @private
         * @param    source
         */
        private function initMaterial(source:IBitmapDrawable):void 
        {
            var bmd:BitmapData = new BitmapData(300, 200);
            var mat:Matrix = new Matrix();
            for (var i:int = 0; i < 6; i++) 
            {
                mat.tx = i % 3 * 100;
                mat.ty = i % 2 * 100;
                bmd.draw(source, mat);
            }
            //addChild(new Bitmap(bmd) as Bitmap);
            
            _material = new BitmapMaterial(bmd);
        }
        
        /**
         * Stardust Emitterを初期化します.
         * @private
         */
        private function initEmitter():void 
        {
            _emitter = new IconEmitter(_material);
            _emitter.particleHandler = new Away3DLiteObject3DHandler(_container);
        }
        
        /**
         * マウスダウンしたときに実行されます.
         * @private
         * @param    event
         */
        private function onMouseDown(event:MouseEvent):void 
        {
            _lastMouseX = stage.mouseX;
            _lastMouseY = stage.mouseY;
        }
        
        /**
         * 画面がリサイズされたときに実行されます.
         * @private
         * @param    event
         */
        private function onResize(event:Event = null):void 
        {
            _view.x = stage.stageWidth / 2;
            _view.y = stage.stageHeight / 2;
        }
        
        /**
         * 毎フレーム実行される処理です.
         * @private
         * @param    event
         */
        private function mainLoop(event:Event):void 
        {
            // Stardust Emitter
            _emitter.step();
            
            // Camera
            _camera.panAngle = 0.3 * (stage.mouseX - _lastMouseX);
            _camera.tiltAngle = 0.3 * (stage.mouseY - _lastMouseY);
            _camera.hover();
            
            // Away3D View
            _view.render();
        }
    }
    
}

import away3dlite.materials.Material;
import away3dlite.primitives.Cube6;
import away3dlite.primitives.Sphere;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.SteadyClock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.threeD.actions.BillboardOriented;
import idv.cjcat.stardust.threeD.actions.Gravity3D;
import idv.cjcat.stardust.threeD.actions.Move3D;
import idv.cjcat.stardust.threeD.away3dlite.initializers.Away3DLiteObject3DClass;
import idv.cjcat.stardust.threeD.emitters.Emitter3D;
import idv.cjcat.stardust.threeD.fields.UniformField3D;
import idv.cjcat.stardust.threeD.initializers.Position3D;
import idv.cjcat.stardust.threeD.initializers.Rotation3D;
import idv.cjcat.stardust.threeD.initializers.Velocity3D;
import idv.cjcat.stardust.threeD.zones.SinglePoint3D;
import idv.cjcat.stardust.threeD.zones.SphereZone;

/**
 * IconEmitter クラスは、IconShowerに使われるエミッタークラスです.
 * @see IconShower
 */
internal class IconEmitter extends Emitter3D
{
    /**
     * コンストラクタ.
     * @param    material
     */
    public function IconEmitter(material:Material)
    {
        super(new SteadyClock(2));
        
        addInitializer(new Life(new UniformRandom(50, 0)));
        addInitializer(new Position3D(new SinglePoint3D()));
        addInitializer(new Away3DLiteObject3DClass(Sphere, [material, 10, 10]));
        addInitializer(new Velocity3D(new SphereZone(0, 0, 0, 50)));
        var rotRand:UniformRandom = new UniformRandom(0, 360);
        addInitializer(new Rotation3D(rotRand, rotRand, rotRand));
        
        var gravity:Gravity3D = new Gravity3D();
        gravity.addField(new UniformField3D(1, 1));
        
        addAction(gravity);
        addAction(new Move3D());
        addAction(new Age());
        addAction(new DeathLife());
        addAction(new ScaleCurve(14, 10));
        addAction(new BillboardOriented());
    }
}