/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8cTj
 */

// 玉の大きさの計算が適当すぎる。というか正しく計算できてない気がする
package {
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix3D;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Utils3D;
	import flash.geom.Vector3D;
	import flash.utils.getTimer;
	
	import net.hires.debug.Stats;
	[SWF (width = 400, height = 400, frameRate = 60, backgroundColor = 0x000000)]
    public class Ball3D extends Sprite {
		private const _SW:int = stage.stageWidth;
		private const _SH:int = stage.stageHeight;
		private var _spViewport:Sprite;
		private var _vertices:Vector.<Number>;
		private var _uvtData:Vector.<Number>;
		private var _matWorld:Matrix3D;
		private var _matView:Matrix3D;
		private var _projection:PerspectiveProjection;
		private var _colors:Vector.<uint>;
		private var _ballVectors:Vector.<Vector3D>;
		
        public function Ball3D() {
			stage.addChild(new Stats());
            
			_spViewport = new Sprite();
			_spViewport.x = _SW * 0.5;
			_spViewport.y = _SH * 0.5;
			addChild(_spViewport);
			
			createMesh();
			
			_matWorld = new Matrix3D();
			_matView = new Matrix3D();
			_matView.appendTranslation(0, 0, 150);
			_projection = new PerspectiveProjection();
			_projection.fieldOfView = 60;
			
			stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:Event):void {
				stage.removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
			});
			stage.addEventListener(MouseEvent.MOUSE_UP, function(e:Event):void {
				stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			});
        }
		
		private function enterFrameHandler(e:Event):void 
		{
			update();
			render();
		}
		
		private function render():void
		{
			var m:Matrix3D = new Matrix3D();
			m.append(_matWorld);
			m.append(_matView);
			m.append(_projection.toMatrix3D());
			
			var projected:Vector.<Vector3D> = new Vector.<Vector3D>;
			_ballVectors.forEach(function(item:Vector3D, index:int, vector:Vector.<Vector3D>):void {
				var v:Vector3D = m.transformVector(item);
				v.w = index;
				projected.push(v);
			},this);
			
			_spViewport.graphics.clear();
			projected.sort(function(x:Vector3D, y:Vector3D):Number { return y.z - x.z; } );
			for (var i:int = 0; i < projected.length; i++) {
				_spViewport.graphics.lineStyle(0, 0xFFFFFF, 0.0);
				_spViewport.graphics.beginFill(_colors[projected[i].w], 1);
				_spViewport.graphics.drawCircle(projected[i].x / projected[i].z, projected[i].y / projected[i].z, 1000 / projected[i].z);
				_spViewport.graphics.endFill();
			}
		}
		
		private function update():void
		{
			_matWorld.appendRotation(Math.sin(getTimer() / 30 % 360 * Math.PI / 180) , Vector3D.X_AXIS);
			_matWorld.appendRotation(1, Vector3D.Y_AXIS);
		}
		
		private function createMesh():void
		{
			_vertices = new Vector.<Number>;
			_uvtData = new Vector.<Number>;
			_ballVectors = new Vector.<Vector3D>;
			_colors = new Vector.<uint>;
			for (var i:int = 0; i < 100; i++) {
				_colors.push(Math.random() * 0x404040 + 0xC0C0C0);
				_ballVectors.push(new Vector3D(Math.random() * 100 - 50, Math.random() * 100 - 50, Math.random() * 100 - 50));
			}
		}
    }
}