/**
 * Copyright poiasd ( http://wonderfl.net/user/poiasd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8bTe
 */

// forked from poiasd's Chain
package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;

    [SWF (width = "465", height = "465", frameRate = "30", backgroundColor = "0x333333")]

    public class Chain extends Sprite {
        
        private const LINK_LENGTH:uint = 2;
        private const JOINT_COUNT:uint = 100;
        private const DELAY:Number = 0.9;
        private var jointList:Array = [];
        
        public function Chain ():void {
            var i:int;
            for (i = 0; i < JOINT_COUNT; i++) {
                jointList [i] = new Point ();
                jointList [i].x = Math.random () * stage.stageWidth;
                jointList [i].y = Math.random () * stage.stageHeight;
            }
            addEventListener (Event.ENTER_FRAME, loop);
        }
        
        private function loop (event:Event):void {
            jointList [0].x = mouseX;
            jointList [0].y = mouseY;
            graphics.clear ();
            graphics.lineStyle (2, 0xFFFFFF, 0.5);
            graphics.moveTo (jointList [0].x, jointList [0].y);
            var i:int;
            for (i = 0; i < JOINT_COUNT - 1; i++) {
                chaseJoint (jointList [i], jointList [i + 1]);
                graphics.lineTo (jointList [i + 1].x, jointList [i + 1].y);
            }
        }
        
        private function chaseJoint (joint1:Point, joint2:Point):void {
            var dx:Number = joint1.x - joint2.x;
            var dy:Number = joint1.y - joint2.y;
            var d:Number = Math.sqrt (dx * dx + dy * dy);
            var rate:Number = (d - LINK_LENGTH) / d * DELAY;
            rate = (Math.abs (rate) < 0.1) ? 0 : rate;
            joint2.x += dx * rate;
            joint2.y += dy * rate;
        }
        
    }
    
}