// forked from makc3d's How do you make a pentagon in sandy
// Re: http://www.flashsandy.org/forum/viewtopic.php?t=1479
// License: WTFPL v2, http://sam.zoy.org/wtfpl

// code modified from Terry Corbet's modification
// of Max Pellizzaro's tutorial 44

package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.*;
    import flash.ui.*;
    import flash.geom.Point;
    
    import sandy.core.Scene3D;
    import sandy.core.scenegraph.Camera3D;
    import sandy.core.scenegraph.Group;
    import sandy.core.scenegraph.Shape3D;
    import sandy.materials.*;
    import sandy.materials.attributes.*;
    import sandy.primitive.Box;
    import sandy.extrusion.Extrusion;
    import sandy.extrusion.data.*;
    import sandy.core.data.*;
 
    public class Ex44 extends Sprite {
 
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var c:Box;
        private var ext:Extrusion;
        
        public function Ex44() {
            
            camera = new Camera3D(stage.stageWidth, stage.stageHeight);
            scene = new Scene3D("myScene", this, camera , new Group("root"));
            
            var arrayTri:Array = new Array();
            arrayTri[0] = new Point (-25, -25);
            arrayTri[1] = new Point (25, -25);
            arrayTri[2] = new Point (25, 25);
            arrayTri[3] = new Point (-25, 25);
            //arrayTri[4] = new Point (-25, -25); // <- you do not close profiles
            var theTri:Polygon2D = new Polygon2D(arrayTri);
            
			var matrices:Array = [];
			for (var i:int = 0; i < 5; i++) {
				// generate matrices to form pentagon in XZ plane
				var a:Number = 360 * i / 5; // <- section angle
				var m0:Matrix4 = new Matrix4; m0.translation (70, 0, 0); // <- translate outwards
				var m1:Matrix4 = new Matrix4; m1.rotationY (a); // <- rotate "theTri" around Y axis
				m1.multiply (m0); // <- combine both in same matrix
				matrices.push (m1);
			}
			matrices.push (Matrix4 (matrices [0]).clone ()); // <- copy first matrix to close loop
            
            ext = new Extrusion("tri", theTri, matrices,
				false, false); // <- since we have a loop, we dont need to close extrusion ends
            ext.appearance = new Appearance (new ColorMaterial (0xB0E0E6, 1,
                new MaterialAttributes (new LightAttributes( true, 0.1)/*, 
                                new OutlineAttributes(3, 0xFC5858, 1),
                                new LineAttributes(1, 0x000000, 1)*/)));
            ext.appearance.frontMaterial.lightingEnable = true;
            
            //ext.geometryCenter= new sandy.core.data.Point3D (-48,-15,0); <- dunno why we need this...
            
            ext.rotateY = 130            //ext.x = 120; <- ...or this
            ext.pan = 40;
            scene.root.addChild(ext);
            
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMovedHandler);
            addEventListener(Event.ENTER_FRAME, render);
        } // End of Constructor.
 
        private function render(event:Event):void {
            scene.render();
            ext.roll += 1; // .1 -> 1, just to speed it up
        }
        
        private function mouseMovedHandler(event:MouseEvent):void {
           //ext.pan=(event.stageX-550/2)/5;
           //ext.tilt=(event.stageY-400/2)/20;
 
        }
    } // End of Class.
 
} // End of Package Declaration.