/**
 * Copyright hacker_1vmxfaw1 ( http://wonderfl.net/user/hacker_1vmxfaw1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8aI8
 */

// forked from krogue's #16 Conway's Game of Life v3 ( flash on 2009-9-2 )
/**
 * #16 Conway's Game of Life v3
 * 
 * ConvolutionFilter + paletteMap によるライフゲーム高速化実験。
 * 意図的に遅くしないといけないとか、速すぎます。
 * 色は意外と作られていない白黒にしてみました。おおよそ理解できたつもり。
 * ところで黒白はどうやって作れば良いのでしょうか？
 *
 * FIXED:
 * 乱数の種を常に0にしてたの忘れてた。ちょっとだけ増やしときますね。
 * 
 * NOTE:
 * コーディングルールの意識(再確認)
 * ・イベントハンドラはon*ではなく*Handler
 * ・{}は縦に並ぶように
 * 意図的違反: 優先順位を明確にするための()
 * 
 * @author krogue
 */
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="30", height="30", 
    backgroundColor="0", frameRate="60")]
    public class Main extends Sprite
    {
        private var game:ConwayGame;
        private var frame:int = 0;
        
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
        
        private function addedToStageHandler(event:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            initialize();
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(event:Event):void
        {
            update();
        }
        
        private function initialize():void
        {
            game = addChild(new ConwayGame()) as ConwayGame;
        }
        
        private function update():void
        {
            if (frame % 10 == 0)
                game.update();
            frame = (frame + 1 == 60 ? 0 : frame + 1);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.filters.ConvolutionFilter;
import flash.geom.Point;
import flash.display.BitmapDataChannel;

class ConwayGame extends Sprite
{
    private static const COLOR_BLACK:uint = 0x000000;
    private static const COLOR_RED:uint = 0xFF0000;
    private static const COLOR_GREEN:uint = 0x00FF00;
    private static const COLOR_BLUE:uint = 0x0000FF;
    private static const ZERO_POINT:Point = new Point(0, 0);
    
    private const bitmap:Bitmap = addChild(new Bitmap()) as Bitmap;
    private const filter:ConvolutionFilter = buildFilter();
    private const rule1:Array /* of uint */ = new Array(256);
    private const rule2:Array /* of uint */ = new Array(256);
    private const rule3:Array /* of uint */ = new Array(256);
    
    public function ConwayGame()
    {
        bitmap.bitmapData = new BitmapData(465, 465, false, COLOR_BLACK);
        randomize(bitmap.bitmapData);
        
        // init rules (23/3)
        const n:int = 256;
        for (var i:int = 0; i < n; i++)
        {
            rule1[i] = COLOR_BLACK;
            rule2[i] = COLOR_BLACK;
            rule3[i] = COLOR_BLACK;
        }
        rule1[1 + 1 + 9] = COLOR_RED;
        rule1[1 + 1 + 1 + 9] = COLOR_RED;
        rule1[1 + 1 + 1] = COLOR_RED;
        rule2[1 + 1 + 9] = COLOR_GREEN;
        rule2[1 + 1 + 1 + 9] = COLOR_GREEN;
        rule2[1 + 1 + 1] = COLOR_GREEN;
        rule3[1 + 1 + 9] = COLOR_BLUE;
        rule3[1 + 1 + 1 + 9] = COLOR_BLUE;
        rule3[1 + 1 + 1] = COLOR_BLUE;
    }
    
    public function update():void
    {
        const bmd:BitmapData = bitmap.bitmapData;
        bmd.applyFilter(bmd, bmd.rect, ZERO_POINT, filter);
        bmd.paletteMap(bmd, bmd.rect, ZERO_POINT, rule1, rule2, rule3);
    }
    
    private static function randomize(bmd:BitmapData):void
    {
        bmd.lock();
        
        // randomize bmd (bmd = 0x000000 or 0x010101)
        const randomSeed:int = Math.floor(Math.random() * 0x100000000);
        const low:uint = 0;
        const high:uint = 1;
        bmd.noise(randomSeed, low, high, BitmapDataChannel.BLUE, true);
        
        // create rules (0x010101 => 0xFFFFFF)
        const rule1:Array /* of uint */ = new Array(256);
        const rule2:Array /* of uint */ = new Array(256);
        const rule3:Array /* of uint */ = new Array(256);
        const n:int = 256;
        for (var i:int = 0; i < n; i++)
        {
            rule1[i] = COLOR_BLACK;
            rule2[i] = COLOR_BLACK;
            rule3[i] = COLOR_BLACK;
        }
        rule1[1] = COLOR_RED;
        rule2[1] = COLOR_GREEN;
        rule3[1] = COLOR_BLUE;
        
        // apply rule (bmd = 0x000000 or 0xFFFFFF)
        bmd.paletteMap(bmd, bmd.rect, ZERO_POINT, rule1, rule2, rule3);
        
        bmd.unlock();
    }
    
    private static function buildFilter():ConvolutionFilter
    {
        // 順番に注意 (matrixX/Y => matrix)
        const filter:ConvolutionFilter = new ConvolutionFilter();
        filter.matrixX = 3;
        filter.matrixY = 3;
        filter.matrix = [ 1, 1, 1, 1, 9, 1, 1, 1, 1 ];
        filter.divisor = 0xFF;
        filter.bias = 0;
        return filter;
    }
}
