/**
 * Copyright spanvega ( http://wonderfl.net/user/spanvega )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ZeM
 */

package
{
    import flash.events.Event;
    import flash.geom.Vector3D;

    import away3d.utils.Cast;
    import away3d.containers.*;
    import away3d.entities.Mesh;
    import away3d.core.math.Plane3D;
    import away3d.primitives.PlaneGeometry;
    import away3d.materials.TextureMaterial;

    /**  @author SPANVEGA // CHRISTIAN  **/

    public class PRINT3D extends View3D
    {
        private var nb : int = 400, dimension : int = 400, span : Number = dimension / nb;

        private var meshes : Vector.<Mesh> = new <Mesh>[], mesh : Mesh;

        private var container : ObjectContainer3D;

        private var slice : SLICE, head : Number;


        public function PRINT3D () { addEventListener (Event.ADDED_TO_STAGE, init); }

        private function init (e : Event) : void
        {
            removeEventListener (Event.ADDED_TO_STAGE, init);

            //

            with (stage) { scaleMode = 'noScale'; align = 'TL'; frameRate = 30; showDefaultContextMenu = false; }

            camera.y = camera.z = 600; camera.lookAt (new Vector3D ());

            backgroundColor = 0xFFFFFF; antiAlias = 4;

            // background

            with
            (scene.addChild (new Mesh (new PlaneGeometry (1650, 1650),
                                       new TextureMaterial (Cast.bitmapTexture (new BACKGROUND (512))))))
            { y = z = -dimension; rotationX = 45; }

            // main

            scene.addChild (container = new ObjectContainer3D ());

            slice = new SLICE (256);

            head = -span * (nb - 1) / 2;

            for (var i : int = 0; i < nb; i++) 

            make ();

            //

            addEventListener (Event.ENTER_FRAME, frame);
        }

        private function make () : void
        {
            slice.render ();

            var material : TextureMaterial = new TextureMaterial (Cast.bitmapTexture (slice.clone ()));
            material.alphaBlending = true;

            mesh = new Mesh (new PlaneGeometry (dimension, dimension), material);

            mesh.y -= head + (meshes.length * span);

            container.addChild (mesh);

            meshes.push (mesh);
        }

        public function frame (e : Event) : void
        {
            container.rotationY += ((stage.stageWidth >> 1) - mouseX) * 0.01;

            for (var i : int = 0; i < nb; i++)
            {
                mesh = meshes [i];

                mesh.y += span;

                if (mesh.y > -head)
                {
                    slice.render ();

                    TextureMaterial (mesh.material).texture = Cast.bitmapTexture (slice);

                    mesh.y = head;
                }
            }

            super.render ();
        }
    }
}


import flash.geom.*;
import flash.display.*;
import flash.filters.GlowFilter;

final class SLICE extends BitmapData
{
    private var f : GlowFilter = new GlowFilter (0x0, 0.1, 5, 5, 1, 1);
    private var o : Array = [new Point (), new Point ()];
    private var a : Number = Math.random () * 360;
    private var s : uint = SEED.generate ();
    private var p : Array = [];

    public function SLICE (size : int = 256)
    {
        super (size, size, true, 0);
    }

    public function render () : void
    {
        perlinNoise (100, 100, 2, s, false, true, 1, false, o);

        threshold (this, rect, rect.topLeft, '<', 0xFF808080);

        map (hsv2rgb ((a += 0.225) % 360, 0.75, 1.0));

        paletteMap (this, rect, rect.topLeft, p);

        applyFilter (this, rect, rect.topLeft, f);

        o[0].y = -(o[1].y += 0.5);
        o[0].x = -(o[1].x -= 0.5);
    }

    private function map (c : uint) : void
    {
        for (var i : int = 0x80; i < 0xFF; i++)
        
        p [i] = c;
    }

    private function hsv2rgb (h : Number = 0, s : Number = 1, v : Number = 1) : uint
    {
        var i : int = int (h / 60);
        var f : Number = h / 60 - i;
        var p : Number = v * (1 - s);
        var q : Number = v * (1 - s * f);
        var t : Number = v * (1 - s * (1 - f));

        switch (i)
        {
            case 0 : return v * 0xFF << 16 | t * 0xFF << 8 | p * 0xFF << 0;
            case 1 : return q * 0xFF << 16 | v * 0xFF << 8 | p * 0xFF << 0;
            case 2 : return p * 0xFF << 16 | v * 0xFF << 8 | t * 0xFF << 0;
            case 3 : return p * 0xFF << 16 | q * 0xFF << 8 | v * 0xFF << 0;
            case 4 : return t * 0xFF << 16 | p * 0xFF << 8 | v * 0xFF << 0;
            case 5 : return v * 0xFF << 16 | p * 0xFF << 8 | q * 0xFF << 0;
        }

        return 0;
    }
}


final class BACKGROUND extends BitmapData
{
    public function BACKGROUND (size : int = 256)
    {
        super (size, size, true, 0);

        var b : BitmapData = clone ();

        for (var i : uint = 1; i < 8; i++)
        {
            b.perlinNoise (25 * i, 25 * i, 5, SEED.generate (), true, true, 1, true);

            draw (b, null, null, i % 2 == 0 ? BlendMode.LIGHTEN : BlendMode.SCREEN);
        }
    }
}


final class SEED
{
    public static function generate () : int
    {
        var n : int = Math.random () * 10000 + 1;

        if (ERROR_SEEDS.indexOf (n) >= 0) n++;

        return n;
    }

    public static const ERROR_SEEDS : Array = [346, 514, 1155, 1519, 1690, 1977, 2327,
               2337, 2399, 2860, 2999, 3099, 4777, 4952, 5673, 6265, 7185, 7259, 7371,
               7383, 7717, 7847, 8032, 8350, 8676, 8963, 8997, 9080, 9403, 9615, 9685];
}