/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ZQh
 */

// forked from ProjectNya's controller
////////////////////////////////////////////////////////////////////////////////
// controller
////////////////////////////////////////////////////////////////////////////////

package {
    import flash.media.*;
    import flash.net.*;
    import flash.text.*;
    import flash.display.*;
    import flash.events.*;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var playBtn:IconBtn;
        private var pauseBtn:IconBtn;
        private var stopBtn:IconBtn;
        private var slider:Slider;
        
        private var openBtn:IconBtn;
        
        
        private var file:FileReference = new FileReference();
        private var loader:MP3FileReferenceLoader = new MP3FileReferenceLoader();
        private var sound:Sound;

        public function Main() {
            init();
        }

        private function init():void {
            //ファイルオープン
            openBtn = new IconBtn(OpenIcon);
            openBtn.init({width:40});
            //openBtn.text = "File";
            openBtn.x = 30;
            openBtn.y = 232;
            addChild(openBtn);
            
            //再生
            playBtn = new IconBtn(PlayIcon);
            addChild(playBtn);
            playBtn.x = 95;
            playBtn.y = 232;
            playBtn.init({width: 40});
            
            //一時停止
            pauseBtn = new IconBtn(PauseIcon);
            pauseBtn.x = 95;
            pauseBtn.y = 232;
            addChild(pauseBtn);
            pauseBtn.init({width: 40});
            
            //停止
            //stopBtn = new IconBtn(StopIcon);
            stopBtn = new IconBtn(StopIcon);
            stopBtn.x = 155;
            stopBtn.y = 232;
            addChild(stopBtn);
            stopBtn.init({width: 40});
            //シークバー
            slider = new Slider();
            slider.x = 200;
            slider.y = 202;
            addChild(slider);
            slider.init({width: 200, min: 0, max: 100, init: 0});
            //
            setup();
        }
        
        private function setup():void {
            pauseBtn.visible = false;
            playBtn.addEventListener(MouseEvent.CLICK, play);
            pauseBtn.addEventListener(MouseEvent.CLICK, pause);
            stopBtn.addEventListener(MouseEvent.CLICK, stop);
            slider.addEventListener(CompoEvent.CHANGE, change);
            openBtn.addEventListener(MouseEvent.CLICK, onClick);
            
        }
        
        private function onClick(e:MouseEvent):void{
            file.addEventListener(Event.SELECT,onSelect); 
            file.browse();
        }
        private function onSelect(e:Event):void{
            loader.addEventListener(MP3SoundEvent.COMPLETE,onComplete);
            file.removeEventListener(Event.SELECT,onSelect);
            loader.getSound(file);
        }
    
        private var ch:SoundChannel;
        private var tf:TextField = new TextField();
        private function onComplete(e:MP3SoundEvent):void{
            addChild(tf);
            tf.text = "play";
            sound = e.sound;
            slider.init({width: 200, min: 0, max: (sound.length/1000), init: 0});
            if(ch!=null){ 
                ch.stop();
                ch=null;
            }
            
            play();

            //ch = sound.play();
            addEventListener(Event.ENTER_FRAME,function():void{
                tf.text = Math.floor(ch.position / 1000).toString()+"\n";
                tf.appendText(Math.floor(sound.length/1000).toString()+"\n");
                slider.value=(ch.position/1000);
            });
            slider.addEventListener(CompoEvent.SELECT,function(e:CompoEvent):void{
                ch.stop();
                ch = sound.play(e.value*1000);
                
            });

            loader.removeEventListener(Event.COMPLETE,onComplete); 

        }


        //_bar.x += (SWF_WIDTH * _playingPosition / _wave.length - _bar.x) * 0.25;
        
        private function play(evt:MouseEvent=null):void {
            playBtn.visible = false;
            pauseBtn.visible = true;
            pauseBtn.clicked = true;
            stopBtn.enabled = true;
            if(ch!=null){
                ch.stop();
                ch = sound.play(ch.position);
            }
            else if(sound != null){
                ch = sound.play();
            }


        }
        
        private function pause(evt:MouseEvent=null):void {
            playBtn.visible = true;
            pauseBtn.visible = false;
            pauseBtn.clicked = false;
            stopBtn.enabled = false;
            if(ch!=null){
                ch.stop();
            }

        }
        
        private function stop(evt:MouseEvent=null):void {
            playBtn.visible = true;
            pauseBtn.visible = false;
            pauseBtn.clicked = false;
            stopBtn.enabled = false;
            slider.reset();
            if(ch!=null){
                ch.stop();
                ch = null;
            }

        }
        
        private function change(evt:CompoEvent):void {
            trace(evt.value);
            //_bar.x += (SWF_WIDTH * _playingPosition / _wave.length - _bar.x) * 0.25;
            
        }

    }

}

//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////


import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    //private static var gColor:uint = 0x00ff00;
    private static var gColor:uint = 0x0099fff;
    //private var cColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        
        switch (type) {//カラーパターン
        case 1 ://　White
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :// Black
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    
    
    public function get text():String{
        return txt.text;
    }
    public function set text(str:String):void{
        txt.text = str;
    }


    
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
//  吹出し
//////////////////////////////////////////////////

import flash.text.*;
import flash.display.*;
class InfoLabel extends Sprite{
    private var _text:String ="";
    public function InfoLabel(str:String=""){
        _text = str;
        this.mouseEnabled = this.mouseChildren = false;
        draw();
    }
    public function set text(str:String):void{
        _text = str;
        draw();
    }

    //描画
    private function draw():void{
        while(0<this.numChildren)this.removeChildAt(0);
        var tf:TextField = new TextField();
        tf = new TextField();
        tf.selectable = false;
        tf.text = _text;
        tf.width = tf.textWidth+5;
        tf.height = tf.textHeight+5;
        
        var c:uint = 0xdddddd;     
        var x1:Number= tf.width/2;
        var y1:Number= tf.height+15;
        var x2:Number= x1-5;
        var x3:Number= x1+5;
        var y2:Number= tf.height+5;
        
        
        var s:Sprite = new Sprite();
        with(s.graphics){
            clear();
            beginFill(c);
            drawRoundRect(-10,-5,tf.width+20,tf.height+10,10,10);

            endFill();
            beginFill(c);
            moveTo(x2,y2);
            lineTo(x3,y2)
            lineTo(x1,y1);
            lineTo(x2,y2);
            endFill();
        }
        s.addChild(tf);
        s.x = -x1;
        s.y = -y1;
        s.alpha = 0.8;
        this.addChild(s);
        
    }
}



//////////////////////////////////////////////////
//     Sliderクラス
//////////////////////////////////////////////////

import flash.display.*;;
import flash.filters.*;
import flash.geom.*;
import flash.events.*;

class Slider extends Sprite {
    private var hole:Shape;
    private var line:Sprite;
    private var thumb:Sprite;
    private var light:Shape;
    private var shade:Shape;
    private var base:Shape;
    
    private var _width:uint = 100;
    private var _height:uint = 3;
    private static var bHeight:uint = 30;
    private static var bColor:uint = 0xFFFFFF;
    private static var bgColor:uint = 0x0099FF;
    private static var sColor:uint = 0x000000;
    private static var offColor:uint = 0x999999;
    
    private var min:Number = 0;//スライダー左端の値
    private var max:Number = 100;//スライダー右端の値
    private var initValue:Number = 0;//リセット時の初期値
    
    private var blueGlow:GlowFilter;
    private var shadeDrop:DropShadowFilter;
    private var _value:Number;
    private var _enabled:Boolean = true;
    private var info:InfoLabel = new InfoLabel();

    public function Slider() {
    }

    public function init(option:Object):void {
        if (option.width != undefined) _width = option.width;
        if (option.min != undefined) min = option.min;
        if (option.max != undefined) max = option.max;
        if (option.init != undefined) initValue = option.init;
        draw();
    }
    
    //描画
    private function draw():void {
        while(0<this.numChildren)this.removeChildAt(0);
        shadeDrop = new DropShadowFilter(1, 90, sColor, 0.5, 4, 4, 2, 3, false, false);
        blueGlow = new GlowFilter(bgColor, 0.6, 5, 5, 2, 3, false, true);
        hole = createGradientHole(_width, _height);
        line = new Sprite();
        thumb = new Sprite();
        
        shade = createThumb(8, 20, 12, sColor);
        shade.filters = [shadeDrop];
        light = createThumb(8, 20, 12, bgColor);
        light.filters = [blueGlow];
        base = createThumb(8, 20, 12, bColor);
        
        addChild(hole);
        addChild(line);
        //addChild(thumb);
        
        thumb.addChild(shade);
        thumb.addChild(light);
        thumb.addChild(base);
        
        hole.y = bHeight;
        line.y = bHeight;
        reset();
        thumb.y = bHeight;
        
        
        _up();
        enabled = true;
        thumb.mouseChildren = false;
    }
   
   //イベント設定 
    private function rollOver(evt:MouseEvent):void {
        _over();
        thumb.addChild(info);
        info.y = -5;
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
        thumb.removeChild(info);
    }
    private function press(evt:MouseEvent):void {
        _down();
        var rect:Rectangle = new Rectangle(0, bHeight, _width, 0);
        thumb.startDrag(false, rect);
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        thumb.addEventListener(Event.ENTER_FRAME, change, false, 0, true);
        isSlide=true;
    }
    private function release(evt:MouseEvent):void {
        _up();
        thumb.stopDrag();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, _value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        thumb.removeEventListener(Event.ENTER_FRAME, change);
        isSlide=false;
    }
    private function leave(evt:Event):void {
        _up();
        thumb.stopDrag();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, _value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        thumb.removeEventListener(Event.ENTER_FRAME, change);
        //isSlide=false;
        
    }
    
    
    private function _up():void {
        light.visible = false;
        
    }
    private function _over():void {
        light.visible = true;
    }
    private function _down():void {
        light.visible = true;
    }
    private function _off():void {
        light.visible = false;
    }
    private var isSlide:Boolean;
    //
    private function change(evt:Event):void {
        _down();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.CHANGE, _value);
        dispatchEvent(e);
        lineDraw();
        time(_value);
    }
    
    //スライダーの状態から値を取得
    private function checkValue():void {
        _value = min + Math.round(thumb.x/_width*(max-min));
    }
    
    public function get value():Number{
        return _value;
    }
    public function set value(v:Number):void{
        if(isSlide)return;
        if(v<min)_value = min;
        else if(max<v)_value = max;
        else _value = v;
        thumb.x = _width*(_value-min)/(max-min);//スライダー位置の更新
        lineDraw();
        time(_value);
    }
    private function time(s:Number):void{
        
        var sec:int = s%60;
        var min:int = Math.floor(s/60)%60;
        var hour:int = Math.floor(s/3600);
        var str:String = "";
        if(3600<max)str+=hour.toString()+":";
        if(60<max)str+=min.toString()+":";
        str+=sec.toString();
        info.text = str;
    }

    
    private function lineDraw():void{
        var w:uint = thumb.x;
        var c:Number = _height;
        with(line){
            graphics.clear();
            graphics.beginFill(0x44aaff,0.8);
            graphics.drawRoundRect(-c, -c, w+c*2, c*2, c*2);
            graphics.endFill();
        }
    }


    //操作受付の設定 true:操作可能　false：操作不可
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        if (!_enabled) _off();
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;
        if (_enabled) {
            thumb.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addChild(thumb);
        } else {
            thumb.removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            thumb.removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
            removeChild(thumb);
        } 
    }
    
    
    public function reset():void {
        thumb.x = _width*(initValue-min)/(max-min);//デフォルト位置に移動
        _value = initValue;//デフォルト値に設定
        lineDraw();
    }
    
    private function createThumb(w:uint, h:uint, y:uint, color:uint, alpha:Number = 1):Shape{
        var target:Shape = new Shape();
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -y, w, h, w);
        target.graphics.endFill();
        return target;
    }

    private function createGradientHole(w:uint, c:Number):Shape{
        var target:Shape = new Shape();
        var colors:Array = [0x000000, 0x000000];
        var alphas:Array = [0.4, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w+c*2, c*2, 0.5*Math.PI, -c, -c);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-c, -c, w+c*2, c*2, c*2);
        target.graphics.endFill();
        return target;
    }

}

//////////////////////////////////////////////////
// IconBtnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;

class IconBtn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var icon:Shape;
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var cColor:uint = 0x0099FF;
    private var colorGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function IconBtn(Icon:Class) {
        icon = new Icon();
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        if (option.color != undefined) cColor = option.color;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        colorGlow = new GlowFilter(cColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(icon);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, cColor);
        light.filters = [colorGlow];
        createBase(base, _width, _height, corner, bColor);
        icon.y = -1;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        icon.y = -1;
        icon.transform.colorTransform = upColorTrans;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        icon.y = -1;
        icon.transform.colorTransform = overColorTrans;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        icon.y = 0;
        icon.transform.colorTransform = overColorTrans;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        icon.y = 0;
        icon.transform.colorTransform = offColorTrans;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        if (_clicked) {
            _down();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
        } else {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// Iconクラス
//////////////////////////////////////////////////

import flash.display.Shape;

class PlayIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function PlayIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(-4, -6);
        graphics.lineTo(-4, 6);
        graphics.lineTo(8, 0);
        graphics.endFill();
    }

}

class PauseIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function PauseIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-5, -5, 4, 10);
        graphics.endFill();
        graphics.beginFill(bColor);
        graphics.drawRect(3, -5, 4, 10);
        graphics.endFill();
    }

}

class StopIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function StopIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-5, -5, 10, 10);
        graphics.endFill();
    }

}

class NextIcon extends Shape {
    private static var bColor:uint = 0x000000;
    public function NextIcon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(-14, -6);
        graphics.lineTo(-14, 6);
        graphics.lineTo(0, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.moveTo(0, -6);
        graphics.lineTo(0, 6);
        graphics.lineTo(12, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(12,-6, 4, 12);
        graphics.endFill();
    }

}

class BackIcon extends Shape {
    private static var bColor:uint = 0x000000;
    public function BackIcon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(12, -6);
        graphics.lineTo(12, 6);
        graphics.lineTo(0, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.moveTo(0, -6);
        graphics.lineTo(0, 6);
        graphics.lineTo(-12, 0);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.drawRect(-12,-5, 4, 10);
        graphics.endFill();
    }

}

class OpenIcon extends Shape {
    private static var bColor:uint = 0x000000;
    public function OpenIcon() {
        draw();
    }
    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-8, -5, 16, 2);
        graphics.endFill();
        
        graphics.beginFill(bColor);
        graphics.moveTo(-8, -1);
        graphics.lineTo(8, -1);
        graphics.lineTo(0, 6);
        graphics.endFill();
    }

}

//////////////////////////////////////////////////
// CompoEventクラス
//////////////////////////////////////////////////

import flash.events.Event;

class CompoEvent extends Event {
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    public override function clone():Event {
        return new CompoEvent(type, value);
    }

}







////////////////////////////////////////////////////
// MP3FileReferenceクラス
////////////////////////////////////////////////////

import flash.display.*;
import flash.events.*;
import flash.media.Sound;
import flash.net.FileReference;
import flash.utils.ByteArray;
import flash.utils.Endian;
    
[Event(name="complete", type="MP3SoundEvent")]
class MP3FileReferenceLoader extends EventDispatcher{
        private var mp3Parser:MP3Parser;
        
        public function MP3FileReferenceLoader(){
            mp3Parser=new MP3Parser();
            mp3Parser.addEventListener(Event.COMPLETE,parserCompleteHandler);
            
        }

        public function getSound(fr:FileReference):void    {
            
            mp3Parser.loadFileRef(fr);
        }
        private function parserCompleteHandler(ev:Event):void{
            var parser:MP3Parser=ev.currentTarget as MP3Parser;
            generateSound(parser);
        }
        private function generateSound(mp3Source:MP3Parser):Boolean{
            var swfBytes:ByteArray=new ByteArray();
            swfBytes.endian=Endian.LITTLE_ENDIAN;
            for(var i:uint=0;i<SoundClassSwfByteCode.soundClassSwfBytes1.length;++i){
                swfBytes.writeByte(SoundClassSwfByteCode.soundClassSwfBytes1[i]);
            }
            var swfSizePosition:uint=swfBytes.position;
            swfBytes.writeInt(0); //swf size will go here
            for(i=0;i<SoundClassSwfByteCode.soundClassSwfBytes2.length;++i){
                swfBytes.writeByte(SoundClassSwfByteCode.soundClassSwfBytes2[i]);
            }
            var audioSizePosition:uint=swfBytes.position;
            swfBytes.writeInt(0); //audiodatasize+7 to go here
            swfBytes.writeByte(1);
            swfBytes.writeByte(0);
            mp3Source.writeSwfFormatByte(swfBytes);
            
            var sampleSizePosition:uint=swfBytes.position;
            swfBytes.writeInt(0); //number of samples goes here
            
            swfBytes.writeByte(0); //seeksamples
            swfBytes.writeByte(0);
                        
            var frameCount:uint=0;
            
            var byteCount:uint=0; //this includes the seeksamples written earlier
                        
            for(;;){
            
                var seg:ByteArraySegment=mp3Source.getNextFrame();
                if(seg==null)break;
                swfBytes.writeBytes(seg.byteArray,seg.start,seg.length);
                byteCount+=seg.length;
                frameCount++;
            }
            if(byteCount==0){
                return false;
            }
            byteCount+=2;

            var currentPos:uint=swfBytes.position;
            swfBytes.position=audioSizePosition;
            swfBytes.writeInt(byteCount+7);
            swfBytes.position=sampleSizePosition;
            swfBytes.writeInt(frameCount*1152);
            swfBytes.position=currentPos;
            for(i=0;i<SoundClassSwfByteCode.soundClassSwfBytes3.length;++i){
                swfBytes.writeByte(SoundClassSwfByteCode.soundClassSwfBytes3[i]);
            }
            swfBytes.position=swfSizePosition;
            swfBytes.writeInt(swfBytes.length);
            swfBytes.position=0;
            var swfBytesLoader:Loader=new Loader();
            swfBytesLoader.contentLoaderInfo.addEventListener(Event.COMPLETE,swfCreated);
            swfBytesLoader.loadBytes(swfBytes);
            return true;
        }
        private function swfCreated(ev:Event):void{

            var loaderInfo:LoaderInfo=ev.currentTarget as LoaderInfo;
            var soundClass:Class=loaderInfo.applicationDomain.getDefinition("SoundClass") as Class;
            var sound:Sound=new soundClass();
            dispatchEvent(new MP3SoundEvent(MP3SoundEvent.COMPLETE,sound));
            
        }
}

import flash.events.Event;
import flash.media.Sound;

class MP3SoundEvent extends Event{

        public var sound:Sound;
        
        public static const COMPLETE:String="complete";
        public function MP3SoundEvent(type:String, sound:Sound, bubbles:Boolean=false, cancelable:Boolean=false){
            super(type, bubbles, cancelable);
            this.sound=sound;
        }
        
}


import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.net.FileReference;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;
import flash.utils.ByteArray;
    
[Event(name="complete", type="flash.events.Event")]
class MP3Parser extends EventDispatcher{
        private var mp3Data:ByteArray;
        private var loader:URLLoader;
        private var currentPosition:uint;
        private var sampleRate:uint;
        private var channels:uint;
        private var version:uint;
        private static var bitRates:Array=[-1,32,40,48,56,64,80,96,112,128,160,192,224,256,320,-1,-1,8,16,24,32,40,48,56,64,80,96,112,128,144,160,-1];
        private static var versions:Array=[2.5,-1,2,1];
        private static var samplingRates:Array=[44100,48000,32000];
        public function MP3Parser(){
            
            loader=new URLLoader();
            loader.dataFormat=URLLoaderDataFormat.BINARY;
            loader.addEventListener(Event.COMPLETE,loaderCompleteHandler);
            
            
        }
        internal function load(url:String):void{
            var req:URLRequest=new URLRequest(url);
            loader.load(req);
        }
        internal function loadFileRef(fileRef:FileReference):void{
            fileRef.addEventListener(Event.COMPLETE,loaderCompleteHandler);
            fileRef.addEventListener(IOErrorEvent.IO_ERROR,errorHandler);
            //fileRef.addEventListener(Event.COMPLETE,loaderCompleteHandler);
            fileRef.load();
        }
        private function errorHandler(ev:IOErrorEvent):void{
            trace("error\n"+ev.text);
        }
        private function loaderCompleteHandler(ev:Event):void{
            mp3Data=ev.currentTarget.data as ByteArray;
            currentPosition=getFirstHeaderPosition();
            dispatchEvent(ev);
        }
        private function getFirstHeaderPosition():uint{
            mp3Data.position=0;
            
            
            while(mp3Data.position<mp3Data.length){
                var readPosition:uint=mp3Data.position;
                var str:String=mp3Data.readMultiByte(3,"us-ascii");
                
                
                if(str=="ID3"){
                    mp3Data.position+=3;
                    var b3:int=(mp3Data.readByte()&0x7F)<<21;
                    var b2:int=(mp3Data.readByte()&0x7F)<<14;
                    var b1:int=(mp3Data.readByte()&0x7F)<<7;
                    var b0:int=mp3Data.readByte()&0x7F;
                    var headerLength:int=b0+b1+b2+b3;
                    var newPosition:int=mp3Data.position+headerLength;
                    trace("Found id3v2 header, length "+headerLength.toString(16)+" bytes. Moving to "+newPosition.toString(16));
                    mp3Data.position=newPosition;
                    readPosition=newPosition;
                }
                else{
                    mp3Data.position=readPosition;
                }
                
                var val:uint=mp3Data.readInt();
                
                if(isValidHeader(val)){
                    parseHeader(val);
                    mp3Data.position=readPosition+getFrameSize(val);
                    if(isValidHeader(mp3Data.readInt())){
                        return readPosition;
                    }
                    
                }

            }
            throw(new Error("Could not locate first header. This isn't an MP3 file"));
        }
        internal function getNextFrame():ByteArraySegment{
            mp3Data.position=currentPosition;
            var headerByte:uint;
            var frameSize:uint;    
            while(true){
                if(currentPosition>(mp3Data.length-4)){
                    trace("passed eof");
                    return null;
                }
                headerByte=mp3Data.readInt();
                if(isValidHeader(headerByte)){
                    frameSize=getFrameSize(headerByte);
                    if(frameSize!=0xffffffff){
                        break;
                    }
                }
                currentPosition=mp3Data.position;
                
            }

            mp3Data.position=currentPosition;
            
            if((currentPosition+frameSize)>mp3Data.length){
                return null;
            }
            
            currentPosition+=frameSize;
            return new ByteArraySegment(mp3Data,mp3Data.position,frameSize);
        }
        internal function writeSwfFormatByte(byteArray:ByteArray):void{
            var sampleRateIndex:uint=4-(44100/sampleRate);
            byteArray.writeByte((2<<4)+(sampleRateIndex<<2)+(1<<1)+(channels-1));
        }
        private function parseHeader(headerBytes:uint):void{
            var channelMode:uint=getModeIndex(headerBytes);
            version=getVersionIndex(headerBytes);
            var samplingRate:uint=getFrequencyIndex(headerBytes);
            channels=(channelMode>2)?1:2;
            var actualVersion:Number=versions[version];
            var samplingRates:Array=[44100,48000,32000];
            sampleRate=samplingRates[samplingRate];
            switch(actualVersion){
                case 2:
                    sampleRate/=2;
                    break;
                case 2.5:
                    sampleRate/=4;
            }
            
        }
        private function getFrameSize(headerBytes:uint):uint{
            
            
            var version:uint=getVersionIndex(headerBytes);
            var bitRate:uint=getBitrateIndex(headerBytes);
            var samplingRate:uint=getFrequencyIndex(headerBytes);
            var padding:uint=getPaddingBit(headerBytes);
            var channelMode:uint=getModeIndex(headerBytes);
            var actualVersion:Number=versions[version];
            var sampleRate:uint=samplingRates[samplingRate];
            if(sampleRate!=this.sampleRate||this.version!=version){
                return 0xffffffff;
            }
            switch(actualVersion){
                case 2:
                    sampleRate/=2;
                    break;
                case 2.5:
                    sampleRate/=4;
            }
            var bitRatesYIndex:uint=((actualVersion==1)?0:1)*bitRates.length/2;
            var actualBitRate:uint=bitRates[bitRatesYIndex+bitRate]*1000;            
            var frameLength:uint=(((actualVersion==1?144:72)*actualBitRate)/sampleRate)+padding;
            return frameLength;
            
        }
        
         private function isValidHeader(headerBits:uint):Boolean{
            return (((getFrameSync(headerBits)      & 2047)==2047) &&
                    ((getVersionIndex(headerBits)   &    3)!=   1) &&
                    ((getLayerIndex(headerBits)     &    3)!=   0) && 
                    ((getBitrateIndex(headerBits)   &   15)!=   0) &&
                    ((getBitrateIndex(headerBits)   &   15)!=  15) &&
                    ((getFrequencyIndex(headerBits) &    3)!=   3) &&
                    ((getEmphasisIndex(headerBits)  &    3)!=   2)    );
        }
    
        private function getFrameSync(headerBits:uint):uint{
            return uint((headerBits>>21) & 2047); 
        }
    
        private function getVersionIndex(headerBits:uint):uint{ 
            return uint((headerBits>>19) & 3);  
        }
    
        private function getLayerIndex(headerBits:uint):uint{ 
            return uint((headerBits>>17) & 3);  
        }
    
        private function getBitrateIndex(headerBits:uint):uint{ 
            return uint((headerBits>>12) & 15); 
        }
    
        private function getFrequencyIndex(headerBits:uint):uint{ 
            return uint((headerBits>>10) & 3);  
        }
    
        private function getPaddingBit(headerBits:uint):uint{ 
            return uint((headerBits>>9) & 1);  
        }
    
        private function getModeIndex(headerBits:uint):uint{ 
            return uint((headerBits>>6) & 3);  
        }
    
        private function getEmphasisIndex(headerBits:uint):uint{ 
            return uint(headerBits & 3);  
        }
        
}

import flash.utils.ByteArray;
    
class ByteArraySegment    {
        public var start:uint;
        public var length:uint;
        public var byteArray:ByteArray;
        public function ByteArraySegment(ba:ByteArray,start:uint,length:uint){
            byteArray=ba;
            this.start=start;
            this.length=length;
        }
}


    
class SoundClassSwfByteCode{
    
        internal static const silentMp3Frame:Array=
        [
            0xFF , 0xFA , 0x92 , 0x40 , 0x78 , 0x05 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00,
            0x4B , 0x80 , 0x00 , 0x00 , 0x08 , 0x00 , 0x00 , 0x09 , 0x70 , 0x00 , 0x00,
            0x01 , 0x00 , 0x00 , 0x01 , 0x2E , 0x00 , 0x00 , 0x00 , 0x20 , 0x00 , 0x00,
            0x25 , 0xC0 , 0x00 , 0x00 , 0x04 , 0xB0 , 0x04 , 0xB1 , 0x00 , 0x06 , 0xBA,
            0xA8 , 0x22 , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF,
            0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF , 0xFF
        ]
        
        internal static const soundClassSwfBytes1:Array = [ 0x46 , 0x57 , 0x53 , 0x09 ];
        
        internal static const soundClassSwfBytes2:Array =
        [    
            0x78 , 0x00 , 0x05 , 0x5F , 0x00 , 0x00 , 0x0F , 0xA0 , 
            0x00 , 0x00 , 0x0C , 0x01 , 0x00 , 0x44 , 0x11 , 0x08 , 
            0x00 , 0x00 , 0x00 , 0x43 , 0x02 , 0xFF , 0xFF , 0xFF , 
            0xBF , 0x15 , 0x0B , 0x00 , 0x00 , 0x00 , 0x01 , 0x00 , 
            0x53 , 0x63 , 0x65 , 0x6E , 0x65 , 0x20 , 0x31 , 0x00 , 
            0x00 , 0xBF , 0x14 , 0xC8 , 0x00 , 0x00 , 0x00 , 0x00 , 
            0x00 , 0x00 , 0x00 , 0x00 , 0x10 , 0x00 , 0x2E , 0x00 , 
            0x00 , 0x00 , 0x00 , 0x08 , 0x0A , 0x53 , 0x6F , 0x75 , 
            0x6E , 0x64 , 0x43 , 0x6C , 0x61 , 0x73 , 0x73 , 0x00 , 
            0x0B , 0x66 , 0x6C , 0x61 , 0x73 , 0x68 , 0x2E , 0x6D , 
            0x65 , 0x64 , 0x69 , 0x61 , 0x05 , 0x53 , 0x6F , 0x75 , 
            0x6E , 0x64 , 0x06 , 0x4F , 0x62 , 0x6A , 0x65 , 0x63 , 
            0x74 , 0x0F , 0x45 , 0x76 , 0x65 , 0x6E , 0x74 , 0x44 , 
            0x69 , 0x73 , 0x70 , 0x61 , 0x74 , 0x63 , 0x68 , 0x65 , 
            0x72 , 0x0C , 0x66 , 0x6C , 0x61 , 0x73 , 0x68 , 0x2E , 
            0x65 , 0x76 , 0x65 , 0x6E , 0x74 , 0x73 , 0x06 , 0x05 , 
            0x01 , 0x16 , 0x02 , 0x16 , 0x03 , 0x18 , 0x01 , 0x16 , 
            0x07 , 0x00 , 0x05 , 0x07 , 0x02 , 0x01 , 0x07 , 0x03 , 
            0x04 , 0x07 , 0x02 , 0x05 , 0x07 , 0x05 , 0x06 , 0x03 , 
            0x00 , 0x00 , 0x02 , 0x00 , 0x00 , 0x00 , 0x02 , 0x00 , 
            0x00 , 0x00 , 0x02 , 0x00 , 0x00 , 0x01 , 0x01 , 0x02 , 
            0x08 , 0x04 , 0x00 , 0x01 , 0x00 , 0x00 , 0x00 , 0x01 , 
            0x02 , 0x01 , 0x01 , 0x04 , 0x01 , 0x00 , 0x03 , 0x00 , 
            0x01 , 0x01 , 0x05 , 0x06 , 0x03 , 0xD0 , 0x30 , 0x47 , 
            0x00 , 0x00 , 0x01 , 0x01 , 0x01 , 0x06 , 0x07 , 0x06 , 
            0xD0 , 0x30 , 0xD0 , 0x49 , 0x00 , 0x47 , 0x00 , 0x00 , 
            0x02 , 0x02 , 0x01 , 0x01 , 0x05 , 0x1F , 0xD0 , 0x30 , 
            0x65 , 0x00 , 0x5D , 0x03 , 0x66 , 0x03 , 0x30 , 0x5D , 
            0x04 , 0x66 , 0x04 , 0x30 , 0x5D , 0x02 , 0x66 , 0x02 , 
            0x30 , 0x5D , 0x02 , 0x66 , 0x02 , 0x58 , 0x00 , 0x1D , 
            0x1D , 0x1D , 0x68 , 0x01 , 0x47 , 0x00 , 0x00 , 0xBF , 
            0x03 
        ];
        
        internal static const soundClassSwfBytes3:Array=
        [ 
            0x3F , 0x13 , 0x0F , 0x00 , 0x00 , 0x00 , 0x01 , 0x00 , 
            0x01 , 0x00 , 0x53 , 0x6F , 0x75 , 0x6E , 0x64 , 0x43 , 
            0x6C , 0x61 , 0x73 , 0x73 , 0x00 , 0x44 , 0x0B , 0x0F , 
            0x00 , 0x00 , 0x00 , 0x40 , 0x00 , 0x00 , 0x00 
        ];

}