/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8Z1ht
 */

/*
multipart project 2
part 5, finale

Background:
description withheld

Task:
- combine all previous parts
- except for part 2; man I'm an idiot
- I guess I won't need part 1 either then
- geez that's like half of it right there
- gotta find the perfect song for this

P. S., congrats to Wonderfl on reaching 5 digits. 8Z1ht
*/
package {
    import net.hires.debug.Stats;
    import com.actionscriptbible.Example
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import flash.system.*;
    import flash.utils.*;
    public class Finale extends Example {
        
        private static const PROXY:String = 'http://p.jsapp.us/proxy/';
        private static const ORIGIN:Point = new Point();
        private static const R256:Rectangle = new Rectangle(0, 0, 256, 256);
        
        private const grad:Array = new Array(256);
        private const lsrc:BitmapData = new BitmapData(256, 256, false, 0x000000);
        private const rsrc:BitmapData = new BitmapData(256, 256, false, 0x000000);
        private const left:BitmapData = new BitmapData(256, 256, false, 0xffffff);
        private const right:BitmapData = new BitmapData(256, 256, false, 0xffffff);
        
        private const spec:ByteArray = new ByteArray();
        private const col:Rectangle = new Rectangle(0, 0, 1, 1);
        private const fade:ColorTransform = new ColorTransform(1, 1, 1, 1, -1);
        private const drops:Vector.<Drop> = new Vector.<Drop>(512, true);

        public function Finale() {
            var i:int;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            // prepare gradient
            var colors:Array = [0xffffff, 0xe0d090, 0x602000, 0xff2000];
            var alphas:Array = [     1.0,      1.0,      1.0,      1.0];
            var ratios:Array = [    0x00,     0x30,     0x60,     0xc0];
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(256, 0, 0, 0, 0);
            var s:Shape = new Shape();
            s.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
            s.graphics.drawRect(0, 0, 256, 256);
            s.graphics.endFill();
            var d:BitmapData = new BitmapData(256, 1, false);
            d.draw(s);
            for (i = 0; i < 256; i++)
                grad[i] = d.getPixel(i, 0);
            
            // load background
            var bg:Loader = new Loader();
            bg.load(new URLRequest('http://farm3.static.flickr.com/2061/2436755566_fcd953837b.jpg'), new LoaderContext(true));
            addChild(bg);
            
            // load sound
            var au:Sound = new Sound(new URLRequest(PROXY + 'http://audio.apmmusic.com/mp3_128/SEL/SEL/SEL_SEL_5140/SEL_SEL_5140_02901.mp3'), new SoundLoaderContext(1000, true));
            // var au:Sound = new Sound(new URLRequest(PROXY + 'http://audio.apmmusic.com/mp3_128/WOM/FEM/WOM_FEM_0002/WOM_FEM_0002_00201.mp3'), new SoundLoaderContext(1000, true));
            au.play();
            
            // prepare left
            var lv:Vector.<Number> = new Vector.<Number>(16, true);
            lv[0] = -1.0956996927051497;
            lv[1] = 0.1578400478969285;
            lv[2] = -0.4770838773665918;
            lv[4] = 0.012341189209581296;
            lv[5] = 0.6680324713000458;
            lv[6] = 0.0744263290108076;
            lv[10] = 1;
            lv[12] = 331;
            lv[13] = 13;
            lv[15] = 1;
            var lb:Bitmap = new Bitmap(left);
            lb.blendMode = BlendMode.MULTIPLY;
            lb.transform.matrix3D = new Matrix3D(lv);
            addChild(lb);
            
            // prepare right
            var rv:Vector.<Number> = new Vector.<Number>(16, true);
            rv[0] = 0.2124737146278966;
            rv[1] = 0.1872564686385918;
            rv[2] = -0.6215092826229578;
            rv[4] = 0.022468770889037433;
            rv[5] = 0.6632023938836898;
            rv[6] = 0.12081879224369232;
            rv[10] = 1;
            rv[12] = 331;
            rv[13] = 13;
            rv[15] = 1;
            var rb:Bitmap = new Bitmap(right);
            rb.blendMode = BlendMode.MULTIPLY;
            rb.transform.matrix3D = new Matrix3D(rv);
            addChild(rb);
            
            // initialize drops
            for (i = 0; i < 512; i++)
                drops[i] = new Drop();
            
            // stats
            addChild(new Stats()).y = 334;
            
            // start rendering
            addEventListener(Event.ENTER_FRAME, comp);
        }
        
        private function comp(e:Event):void {
            var i:int, v:int;
            SoundMixer.computeSpectrum(spec, true);
            spec.position = 0;
            
            // advance left
            lsrc.colorTransform(R256, fade);
            for (i = 0; i < 256; i++) {
                v = spec.readFloat() * 128;
                col.x = i;
                col.height = v;
                lsrc.fillRect(col, 0xff0000);
                if (v > drops[i].y) {
                    drops[i].y = v;
                    drops[i].v = 254;
                }
                if (drops[i].v > 0xc0) {
                    lsrc.setPixel(i, drops[i].y, Math.max(drops[i].color, lsrc.getPixel(i, drops[i].y)));
                    drops[i].v--;
                    if (drops[i].v <= 0xc0)
                        drops[i].y = 0;
                    else if (Math.random() < 0.1)
                        drops[i].y++;
                }
            }
            left.paletteMap(lsrc, R256, ORIGIN, grad);
            
            // advance right
            rsrc.colorTransform(R256, fade);
            for (i = 256; i < 512; i++) {
                v = spec.readFloat() * 128;
                col.x = i - 256;
                col.height = v;
                rsrc.fillRect(col, 0xff0000);
                if (v > drops[i].y) {
                    drops[i].y = v;
                    drops[i].v = 254;
                }
                if (drops[i].v > 0xc0) {
                    rsrc.setPixel(i, drops[i].y, Math.max(drops[i].color, rsrc.getPixel(i, drops[i].y)));
                    drops[i].v--;
                    if (drops[i].v <= 0xc0)
                        drops[i].y = 0;
                    else if (Math.random() < 0.1)
                        drops[i].y++;
                }
            }
            right.paletteMap(rsrc, R256, ORIGIN, grad);
        }
        
    }
}

internal class Drop {
    
    public var y:int,  v:int;
    
    public function get color():uint {
        return v << 16;
    }
    
}