/**
 * Copyright nabe ( http://wonderfl.net/user/nabe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8Y3r
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	
	/**
	 * ...
	 * @author nabe
	 */
	public class Main extends Sprite 
	{
		private var s_:Shape;
		private var g_:Graphics;
		private var bd_:BitmapData;
		private var v_:Vector.<Number> = new Vector.<Number>;
		private var uvt_:Vector.<Number> = new Vector.<Number>;
		private var p_:Number = 0;

		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);

			s_ = new Shape;
			g_ = s_.graphics;

			//塗り潰しパターンの作成。
			g_.clear();
			g_.moveTo(50, 0);
			g_.lineStyle(3, 0xFF0000);
			g_.lineTo(0, 0);
			g_.lineStyle(3, 0xFF);
			g_.lineTo(0, 50);
			bd_ = new BitmapData(50, 50, false, 0);
			bd_.draw(s_);

			//画面一杯に塗り潰す。
			g_.clear();
			g_.beginBitmapFill(bd_);
			var w_:int = stage.stageWidth;
			var h_:int = stage.stageHeight;
			g_.drawRect(0, 0, w_, h_);
			g_.endFill();
			bd_ = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
			bd_.draw(s_);
			addChild(new Bitmap(bd_));


			v_.push(w_ * 0.5, 0, w_, h_, 0, h_);
			uvt_.push(0.5, 0, 1, 1, 1, 1, 0, 1, 1);
			addChild(s_);
			update_();
			addEventListener(Event.ENTER_FRAME, update_);
		}

		private function update_(e:Event = null):void 
		{
			//変形塗り。
			g_.clear();
			g_.beginBitmapFill(bd_);
			p_ += 0.2;
			if (p_ > 100) p_ = -100;
			uvt_[2] = Math.cos(Math.PI * p_ / 100) * 2;
			//↑マイナスの値を指定しても動くのか。
			g_.drawTriangles(v_, null, uvt_);
			g_.endFill();
		}
	}
}