/**
 * Copyright king_nomura ( http://wonderfl.net/user/king_nomura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8Y1t
 */

// forked from king_nomura's アナログ入力実験
/*
 * Arduinoのアナログ入力[0,1]とデジタル入力[0]を使うサンプル
 * A0=中心位置(横方向)
 * A1=中心位置(縦方向)
 * D0=座標（ A0, A1 )を中心にパーティクルを運動させる
 *   ついでにD1もオンにする
 * created by nomura masayuki
 */
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="300", height="300", backgroundColor="0xFFFFFF", frameRate="30")]
    
    public class ArduinoSample extends Sprite
    {
        private var mc:CircleMC;
        public function ArduinoSample ()
        {
            mc = new CircleMC();
			mc.addEventListener(CircleMC.INIT_COMPLETE, circleMCInitCompleteHandler);
            addChild(mc);
        }
		
		private function circleMCInitCompleteHandler(event:Event):void
		{
			addChild(mc.ui);
		}
    }

}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.MovieClip;
import flash.events.Event;
import flash.geom.Point;
import flash.geom.Rectangle;
import funnel.Arduino;
import funnel.Configuration;
import funnel.Convolution;
import funnel.gui.ArduinoGUI;
import funnel.Pin;
import funnel.PinEvent;
import funnel.Scaler;

class CircleMC extends MovieClip
{
	public static const INIT_COMPLETE:String = "CircleMC.INIT_COMPLETE";
	private static const _PARTICLES_COUNT:uint = 3000;
	
	private var _arduinoUI:ArduinoGUI;
	private var _arduinoIO:Arduino;
	private var _particleArray:Array /* of Particle */ = [];
	private var centerX:Number;
	private var centerY:Number;
	private var bitmap:Bitmap;
	private var dio1:Boolean = false;
	
	public function CircleMC()
	{
		if (stage) init() else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	public function get ui():DisplayObject
	{
		return _arduinoUI;
	}
	
	private function init(event:Event = null):void
	{
		if (event) removeEventListener(Event.ADDED_TO_STAGE, init);
		
		initArduino();
		initGraphics(_arduinoIO.analogPin(0).value, _arduinoIO.analogPin(1).value);
		
		dispatchEvent(new Event(CircleMC.INIT_COMPLETE));
		
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	
	private function enterFrameHandler(event:Event):void
	{
		drawGraphics();
	}
	
	private function initArduino():void
	{
		var config:Configuration = Arduino.FIRMATA;
		config.setDigitalPinMode(0, Pin.DIN);
		config.setDigitalPinMode(1, Pin.DOUT);
		_arduinoIO = new Arduino(config);
		_arduinoUI = new ArduinoGUI();
		_arduinoIO.gui = _arduinoUI;
		var smoother:Convolution = new Convolution(Convolution.MOVING_AVERAGE);
		var xscaler:Scaler = new Scaler(
			_arduinoIO.analogPin(0).minimum, _arduinoIO.analogPin(0).maximum,
			stage.stageWidth, 0, Scaler.LINEAR, true);
		var yscaler:Scaler = new Scaler(
			_arduinoIO.analogPin(1).minimum, _arduinoIO.analogPin(1).maximum,
			stage.stageHeight, 0, Scaler.LINEAR, true);
		_arduinoIO.analogPin(0).filters = [smoother, xscaler];
		_arduinoIO.analogPin(1).filters = [smoother, yscaler];
		_arduinoIO.analogPin(0).addEventListener(PinEvent.CHANGE, pinChangeHandler);
		_arduinoIO.analogPin(1).addEventListener(PinEvent.CHANGE, pinChangeHandler);
		_arduinoIO.digitalPin(0).addEventListener(PinEvent.FALLING_EDGE, dout1ReleaseHandler);
		_arduinoIO.digitalPin(0).addEventListener(PinEvent.RISING_EDGE, dout1DownHandler);
	}
	
	private function pinChangeHandler(event:PinEvent):void
	{
		centerX = (event.target == _arduinoIO.analogPin(0))?
			_arduinoIO.analogPin(0).value : _arduinoIO.analogPin(0).lastValue;
		centerY = (event.target == _arduinoIO.analogPin(1))?
			_arduinoIO.analogPin(1).value : _arduinoIO.analogPin(1).lastValue;
		if (!dio1) return;
		var centerPoint:Point = new Point(centerX, centerY);
		for each (var particle:Particle in _particleArray)
		{
			particle.center = centerPoint;
		}
		drawGraphics();
	}
	
	private function initGraphics(_x:Number, _y:Number):void
	{
		centerX = _x;
		centerY = _y;
		for (var i:uint = 0; i < _PARTICLES_COUNT; i++)
		{
			var particle:Particle = new Particle(centerX, centerY);
			_particleArray.push(particle);
		}
		bitmap = new Bitmap();
		addChild(bitmap);
		drawGraphics();
	}
	
	private function dout1ReleaseHandler(event:PinEvent):void
	{
		dio1 = false;
		_arduinoIO.digitalPin(1).value = 0;
	}
	
	private function dout1DownHandler(event:PinEvent):void
	{
		dio1 = true;
		_arduinoIO.digitalPin(1).value = 1;
		pinChangeHandler(event);
	}
	
	private function drawGraphics():void
	{
		var bitmapData:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFFFF);
		var rect:Rectangle = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
		var color:uint = (dio1) ? 0x00660000 : 0x00666666;
		for each (var particle:Particle in _particleArray)
		{
			if (rect.contains(particle.x, particle.y))
				bitmapData.setPixel(particle.x, particle.y, color);
			particle.move(dio1);
		}
		bitmap.bitmapData = bitmapData;
	}
}

class Particle
{
	private static const _SIZE:Number = 100;
	private var _center:Point;
	private var _x:Number;
	private var _y:Number;
	private var _dx:Number;
	private var _dy:Number;
	
	public function Particle(__x:Number, __y:Number)
	{
		_center = new Point(__x, __y);
		var rad:Number = Math.random() * Math.PI * 2;
		_dx = Math.cos(rad);
		_dy = Math.sin(rad);
		var distance:Number = Math.random() * _SIZE;
		_x = __x + _dx * distance;
		_y = __y + _dy * distance;
	}
	
	public function move(mode:Boolean):void
	{
		_x -= _dx;
		_y -= _dy;
		if (!mode) return;
		var distance:Number = Point.distance(_center, point);
		if (distance > _SIZE) resetCenter();
		if (distance < 5)
		{
			var rad:Number = Math.random() * Math.PI * 2;
			_dx = Math.cos(rad);
			_dy = Math.sin(rad);
		}
	}
	
	public function get x():Number
	{
		return _x;
	}
	
	public function get y():Number
	{
		return _y;
	}
	
	public function get point():Point
	{
		return new Point(_x, _y);
	}
	
	public function set center(_point:Point):void
	{
		_center = _point.clone();
		resetCenter();
	}
	
	private function resetCenter():void
	{
		var newPoint:Point = new Point(_x - _center.x, _y - _center.y);
		newPoint.normalize(Math.random() * 3);
		_dx = newPoint.x;
		_dy = newPoint.y;
	}
	
	public function set dy(val:Number):void
	{
		_dy = val;
	}
}