/**
 * Copyright Heo.SangHun ( http://wonderfl.net/user/Heo.SangHun )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8Xvz
 */

// forked from Marc.Pelland's forked from SketchSample7 - drawer
// forked from lattan's 練習　from SketchSample7
// forked from nutsu's SketchSample7
// forked from nutsu's SketchSample6
// forked from nutsu's SketchSample5
// forked from nutsu's SketchSample4
// forked from nutsu's SketchSample3
// forked from nutsu's SketchSample2
// forked from nutsu's SketchSample1
// forked from nutsu's PaintSample
package {
    import frocessing.display.F5MovieClip2DBmp;
    import frocessing.geom.FGradientMatrix;
    import flash.filters.GlowFilter;
    [SWF(width=465,height=465,backgroundColor=0x000000,frameRate=60)]
    public class SketchSample7 extends F5MovieClip2DBmp
    {
        // 그라데이션의 변수
        private var mtx:FGradientMatrix;
        private var colors:Array;
        private var alphas:Array;
        private var ratios:Array;
         // 선 수
        private var n:int;
        private var brushs:Array;
        
        public function setup():void
        {
            // 캔버스의 크기 지정
            size( 465, 465 );
            // 배경 그리기
            background( 0 );
            //HSV
            colorMode( HSV, 1 );
            // 초기화
            n = 1;
            brushs = [];
            for ( var i:int = 0; i < n; i++ ) {
                var o:BrushState = new BrushState();
                o.vx = o.vy = 0.0;
                o.xx = mouseX;
                o.yy = mouseY;
                o.ac = 0.2; //random( 0.7, 0.80 );
                o.de = 0.56;
                o.wd = random( 0.13, 0.46 );
                o.px0 = [o.xx, o.xx, o.xx];
                o.py0 = [o.yy, o.yy, o.yy];
                o.px1 = [o.xx, o.xx, o.xx];
                o.py1 = [o.yy, o.yy, o.yy];
                brushs[i] = o;
            }
             // 그라데이션의 변수
            mtx = new FGradientMatrix();
            colors = [0, 0];
            alphas = [1.0,1.0];
            ratios = [0,255];
            filters = [new GlowFilter(0xff0000, 1, 24, 24, 5, 2)];
        }
        
        public function draw():void
        {
            if ( isMousePressed )
                background( 0 );
            // 그리기
            drawing( mouseX, mouseY );
        }
        
        private function drawing( x:Number, y:Number ):void
        {
            colors[0] = colors[1];
            colors[1] = color( random(0.95, 1), random(0.2, 1), random(0.3, 1) );
            
            for ( var i:int = 0; i < n; i++ ) {
                var brush:BrushState = brushs[i];
                
                with( brush ){
                    var px:Number = xx;
                    var py:Number = yy;
                    // 가속도 운동
                    xx += vx += ( x - xx ) * ac;
                    yy += vy += ( y - yy ) * ac;
                    
                    // 새 그리기 좌표
                    var x0:Number  = px + vy*wd;
                    var y0:Number  = py - vx*wd;
                    var x1:Number  = px - vy*wd;
                    var y1:Number  = py + vx*wd;
                    
                    // 그라데이션 모양 지정
                    mtx.createLinear( px0[1], py0[1], px0[2], py0[2] );
                    
                    // 그리기
                    noStroke();
                    //beginGradientFill( "linear", colors, alphas, ratios, mtx );
                    beginFill(0xff0000);
                    beginShape();
                    curveVertex( px0[0], py0[0] );
                    curveVertex( px0[1], py0[1] );
                    curveVertex( px0[2], py0[2] );
                    curveVertex( x0, y0 );
                    vertex( px1[2], py1[2] );
                    curveVertex( x1, y1 );
                    curveVertex( px1[2], py1[2] );
                    curveVertex( px1[1], py1[1] );
                    curveVertex( px1[0], py1[0] );
                    endShape();
                    endFill();
                    // 테두리 그리기
                    stroke( 0, 0.1 );
                    noFill();
                    curve( px0[0], py0[0], px0[1], py0[1], px0[2], py0[2], x0, y0 );
                    curve( px1[0], py1[0], px1[1], py1[1], px1[2], py1[2], x1, y1 );
                    
                    // 그리기 좌표
                    px0.shift(); px0.push( x0 ); 
                    py0.shift(); py0.push( y0 ); 
                    px1.shift(); px1.push( x1 ); 
                    py1.shift(); py1.push( y1 ); 
                    
                    // 감쇠 처리
                    vx *= de;
                    vy *= de;
                }
            }
        }
    }
}

class BrushState {
    // 가속도 운동의 변수
    public var xx:Number;
    public var yy:Number;
    public var vx:Number;
    public var vy:Number;
    public var ac:Number;
    public var de:Number;
    // 선폭의 계수
    public var wd:Number;
    // 그리기 좌표
    public var px0:Array;
    public var py0:Array;
    public var px1:Array;
    public var py1:Array;
    public function BrushState(){}
}