/**
 * Copyright geckojsc ( http://wonderfl.net/user/geckojsc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8XLu
 */

package

{

        import flash.display.Sprite;

        import flash.events.Event;

        import flash.events.MouseEvent;

        import flash.geom.Point;

       

        public class Main extends Sprite

        {

                private var dragging:Boolean = false;

                private var listX:Vector.<int> = new Vector.<int>();

                private var listY:Vector.<int> = new Vector.<int>();

                private var fromColor:uint = 0xFFFF00;

                private var toColor:uint = 0xFF3366;

                private var maxThickness:Number = 100;

               

                public function Main()

                {

                        addEventListener(Event.ADDED_TO_STAGE, onStage);

                }

               

                private function onStage(e:Event):void

                {

                        removeEventListener(Event.ADDED_TO_STAGE, onStage);

                        stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);

                        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);

                        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);

                }

               

                private function onMouseDown(e:MouseEvent):void

                {

                        dragging = true;

                        listX.length = 0;

                        listY.length = 0;

                }

               

                private function onMouseUp(e:MouseEvent):void

                {

                        dragging = false;

                }

               

                private function onMouseMove(e:MouseEvent):void

                {

                        if (dragging)

                        {

                                listX.push(mouseX);

                                listY.push(mouseY);

                               

                                var percent:Number;

                                var color:uint;

                                var thickness:Number;

                               

                                graphics.clear();

                                for (var i:int = 1; i < listX.length; i++)

                                {

                                        percent = i / listX.length;

                                        color = colorLerp(fromColor, toColor, percent);

                                        thickness = percent < 0.5 ? scale(percent, 0, 0.5, 0, maxThickness) : scale(percent, 0.5, 1, maxThickness, 0);

                                       

                                        graphics.lineStyle(thickness, color);

                                        graphics.moveTo(listX[i - 1], listY[i - 1]);

                                        graphics.lineTo(listX[i], listY[i]);

                                }

                        }

                }

               

                private function scale(value:Number, min:Number, max:Number, min2:Number, max2:Number):Number

                {

                        return min2 + ((value - min) / (max - min)) * (max2 - min2);

                }

               

                private function colorLerp(fromColor:uint, toColor:uint, t:Number):uint

                {

                        if (t <= 0)

                                return fromColor;

                        if (t >= 1)

                                return toColor;

                        var a:uint = fromColor >> 24 & 0xFF,

                                r:uint = fromColor >> 16 & 0xFF,

                                g:uint = fromColor >> 8 & 0xFF,

                                b:uint = fromColor & 0xFF,

                                dA:int = (toColor >> 24 & 0xFF) - a,

                                dR:int = (toColor >> 16 & 0xFF) - r,

                                dG:int = (toColor >> 8 & 0xFF) - g,

                                dB:int = (toColor & 0xFF) - b;

                        a += dA * t;

                        r += dR * t;

                        g += dG * t;

                        b += dB * t;

                        return a << 24 | r << 16 | g << 8 | b;

                }

        }

}