/**
 * Copyright postleswait ( http://wonderfl.net/user/postleswait )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8WBJ
 */

// forked from bkzen's こんなのどうでしょ？ forked from: クリックしにくい
// forked from bkzen's クリックしにくい
/**
 * クリックしにくいオブジェクトをクリックしやすくするには
 * どうしたらよいでしょうか？
 */
package  
{
    import flash.display.Sprite;
    public class Test extends Sprite 
    {
        public function Test() 
        {
            for (var i: int = 0; i < 10; i++) 
                addChildAt(new TestChild(i), Math.random() < 0.5 ? numChildren : 0);
        }
        
    }

}
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.filters.GlowFilter;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
class TestChild extends Sprite
{
    private var sp: Sprite;
    private static var FILTER: GlowFilter = new GlowFilter(0xFF0000, 1, 6, 6, 3);
    function TestChild(index: int)
    {
        // ここから
        mouseChildren = false;
        x = ((index % 5) + 1) * 25, y = ((index / 5 | 0) + 1) * 25 + 100;
        // ここまでを変更不可
        
        addChild(sp = makeGraphic(index));
        addChild(hitArea = getHitArea(sp));
        
        buttonMode = true;
        addEventListener(MouseEvent.MOUSE_OVER, onOver);
        addEventListener(MouseEvent.MOUSE_OUT, onOut);
    }
    
    private function getHitArea(disp: DisplayObject): Sprite
    {
        var s: Sprite = new Sprite();
        var g: Graphics = s.graphics;
        var r: Rectangle = disp.getBounds(null);
        var b: BitmapData = new BitmapData((r.width) / 2 + 12, (r.height) / 2 + 12, true, 0);
        g.beginFill(0xFFFFFF, 0.001);
        b.lock();
        b.draw(disp, new Matrix(.5, 0, 0, .5, -r.x / 2, -r.y / 2));
        b.applyFilter(b, b.rect, new Point(), FILTER);
        b.colorTransform(b.rect, new ColorTransform(1, 0, 0, 100, 0xFF, 0, 0, 0));
        var w: int = b.width, h: int = b.height;
        for (var y: int = 0; y < h; y++ )
        {
            for (var x: int = 0, tx: int = -1; x < w; x++ )
            {
                var c: uint = b.getPixel32(x, y);
                if (c == 0)
                {
                    if (tx >= 0) g.drawRect(r.x + (tx << 1), r.y + (y << 1), x - tx << 1, 2);
                    tx = -1;
                }
                else 
                {
                    if (tx < 0) tx = x;
                }
            }
        }
        b.unlock();
        b.dispose();
        return s;
    }
    
    // ここは変更不可
    private function makeGraphic(index: int): Sprite 
    {
        var s: Sprite = new Sprite();
        var g: Graphics = s.graphics;
        g.beginFill(0x004080);
        var n: int = Math.random() * 5 + 10;
        // 適当に斜めに描画
        for (var i:int = 0; i < n; i++) 
        {
            var w: int = 70 * ((index % 2) ? (n - i) : i) / n;
            var sy: int = i * 5 - n * 4;
            g.drawRect(w, sy, w, 1);
        }
        return s;
    }
    private var tmpIndex: int;
    
    private function onOut(e: MouseEvent): void 
    {
        parent.addChildAt(this, tmpIndex);
        sp.filters = null;
    }
    private function onOver(e: MouseEvent): void 
    {
        tmpIndex = parent.getChildIndex(this);
        sp.filters = [FILTER];
        parent.addChild(this);
    }
}